/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class PageDescContent
extends BaseMobileComponent
implements Serializable {
    private static final long serialVersionUID = 8344161027726171364L;
    public static final String COMPONENT_TYPE = "PAGE_DESC_CONTENT";
    private Integer iconData;
    private String text;
    private Integer type;
    private Action action;

    public PageDescContent() {
    }

    public PageDescContent(Integer iconData, String text, Integer type) {
        this.iconData = null == iconData || iconData <= 0 ? Integer.valueOf(58992) : iconData;
        this.text = null == text || text.trim().length() == 0 ? "No Data" : text;
        this.type = null == type ? PageDescContentTypeEnum.NORMAL.getValue() : type;
    }

    public PageDescContent(String text, Integer type) {
        this.text = StringUtil.isEmpty((CharSequence)text) ? "No Data" : text;
        this.type = Objects.isNull(type) ? PageDescContentTypeEnum.NORMAL.getValue() : type;
    }

    public static PageDescContent buildReassignReport(String locale, List<DigiwinReassignReport> reassignReportList) {
        PageDescContent pageDescContent = new PageDescContent();
        pageDescContent.setText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7531\u8f6c\u6d3e"), reassignReportList.get(0).getOldPerformerName()));
        pageDescContent.setAction(Action.createReassignReportAction((String)locale, reassignReportList));
        pageDescContent.setIconData(Integer.valueOf(58992));
        pageDescContent.setType(PageDescContentTypeEnum.NORMAL.getValue());
        return pageDescContent;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public Integer getIconData() {
        return this.iconData;
    }

    public String getText() {
        return this.text;
    }

    public Integer getType() {
        return this.type;
    }

    public Action getAction() {
        return this.action;
    }

    public void setIconData(Integer iconData) {
        this.iconData = iconData;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageDescContent)) {
            return false;
        }
        PageDescContent other = (PageDescContent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$iconData = this.getIconData();
        Integer other$iconData = other.getIconData();
        if (this$iconData == null ? other$iconData != null : !((Object)this$iconData).equals(other$iconData)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageDescContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $iconData = this.getIconData();
        result = result * 59 + ($iconData == null ? 43 : ((Object)$iconData).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    public String toString() {
        return "PageDescContent(iconData=" + this.getIconData() + ", text=" + this.getText() + ", type=" + this.getType() + ", action=" + this.getAction() + ")";
    }
}

