/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.CustomList;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTabContentContainerJsonDeserializer
extends JsonDeserializer<CustomTabContentContainer> {
    private static final Logger log = LoggerFactory.getLogger(CustomTabContentContainerJsonDeserializer.class);

    public CustomTabContentContainer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        log.debug("CustomTabContentContainerJsonDeserializer run to prehandle data to component instance...");
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        CustomTabContentContainer customTabContentContainer = (CustomTabContentContainer)JsonUtil.jsonStringToObject((String)node.toString(), CustomTabContentContainer.class);
        if (BooleanUtils.isTrue((Boolean)AppRequestContext.getContextEntity().getIsUpgrade())) {
            String componentType = Optional.ofNullable(node.get("componentType")).map(JsonNode::asText).orElse("");
            if (componentType.startsWith("DW_")) {
                componentType = componentType.substring(3);
            }
            customTabContentContainer.setContentCmptType("DW_" + componentType);
            Class cmptClazz = (Class)MobileRenderDataUtil.customizeListComponentsMap.get(componentType);
            if (null != cmptClazz) {
                MobileComponent mobileComponent = (MobileComponent)JsonUtil.objectToJavaObject((Object)node.get("data"), (Class)cmptClazz);
                CustomList customList = new CustomList();
                customList.setContent((List)mobileComponent);
                customList.setComponentType(componentType);
                customTabContentContainer.setData((Object)customList);
            }
        }
        return customTabContentContainer;
    }
}

