/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBarStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataList;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.SubmitButton;
import com.digiwin.mobile.mobileuibot.core.component.button.SubmitButtonBuilder;
import com.digiwin.mobile.mobileuibot.core.component.list.projectcc.DataItemInTaskList;
import com.digiwin.mobile.mobileuibot.core.component.list.projectcc.TaskList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="customTabsBuilder")
public class CustomTabsBuilder
implements MobileComponentBuilder<CustomTabs> {
    private static final Logger logger = LoggerFactory.getLogger(CustomTabsBuilder.class);
    @Autowired
    private BizProcessDataListBuilder bizProcessDataListBuilder;
    @Autowired
    private SubmitButtonBuilder submitButtonBuilder;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public String getMobileComponentType() {
        return "CUSTOM_TABS";
    }

    public CustomTabs build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<CustomTabs> clazz, Object ... args) {
        String locale = apiRequest.getLocale();
        Assert.notNull((Object)args, (String)"args must not null!");
        Assert.notEmpty((Object[])args, (String)"args must not empty!");
        Assert.notNull((Object)args[0], (String)"args[0] must not null!");
        Assert.isInstanceOf(UiBotLayout.class, (Object)args[0], (String)"args[0] must be instance of UiBotLayout.class!");
        String projectNo = "";
        String tenantId = "";
        try {
            projectNo = (String)args[2];
            tenantId = (String)args[3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Boolean isPcc = !PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.toString().equals(pageSetting.getPageId()) && !PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString().equals(pageSetting.getPageId());
        UiBotLayout pageSettingLayout = (UiBotLayout)args[0];
        if (null == pageSettingLayout.getMChildren() || pageSettingLayout.getMChildren().isEmpty()) {
            return CustomTabs.createEmpty();
        }
        CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)pageSettingLayout.getSchema()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        boolean selectable = false;
        for (int i = 0; i < pageSettingLayout.getMChildren().size(); ++i) {
            UiBotLayout pageSettingLayoutChild = (UiBotLayout)pageSettingLayout.getMChildren().get(i);
            if (null == pageSettingLayoutChild.getMChildren() || pageSettingLayoutChild.getMChildren().isEmpty()) continue;
            String mBizKey = pageSettingLayoutChild.getMBizKey();
            CustomTab customTab = (CustomTab)customTabs.get(i);
            customTab.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)customTab.getName()));
            if (null != pageSettingLayoutChild.getMScrollMode()) {
                customTab.setScrollMode(pageSettingLayoutChild.getMScrollMode());
            }
            List subTabChildrenLayout = pageSettingLayoutChild.getMChildren();
            for (UiBotLayout subTabChildLayout : subTabChildrenLayout) {
                CustomTabContentContainer container;
                List pccProjectTaskInfoList;
                String type = subTabChildLayout.getType();
                String mContentType = subTabChildLayout.getMContentType();
                Boolean mMajor = subTabChildLayout.getMMajor();
                Integer mPosition = subTabChildLayout.getMPosition();
                String finalProjectNo = projectNo;
                Boolean isPccPlan = PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_DETAIL.toString().equals(pageSetting.getPageId());
                if ("PHASE_LIST".equalsIgnoreCase(type) && "PHASE_ITEM".equalsIgnoreCase(mContentType)) {
                    Assert.notNull((Object)args[1], (String)"args[1] must not null!");
                    Assert.isInstanceOf(List.class, (Object)args[1], (String)"args[1] must be instance of List.class!");
                    pccProjectTaskInfoList = (List)args[1];
                    if (CollectionUtils.isEmpty((Collection)pccProjectTaskInfoList)) {
                        container = new CustomTabContentContainer();
                        Empty empty = Empty.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9\u6a21\u677f\uff0c\u6dfb\u52a0\u4efb\u52a1"));
                        container.setData((Object)empty);
                        container.setContentCmptType("EMPTY");
                        container.setMajor(mMajor);
                        container.setPosition(mPosition);
                        customTab.addCustomTabContentContainer(container);
                        continue;
                    }
                    List processedTaskList = pccProjectTaskInfoList.stream().filter(projectTaskInfo -> projectTaskInfo.getUpperLevelTaskNo().equalsIgnoreCase(projectTaskInfo.getTaskNo())).sorted(Comparator.comparingInt(PccProjectTaskInfo::getSequence)).collect(Collectors.toList());
                    if (!Objects.equals(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString(), pageSetting.getPageId())) {
                        String content = "\u8bf4\u660e\uff1a1.\u84dd\u8272:\u8868\u793a\u9996\u9636\u4efb\u52a1\uff0c\u4e0d\u4f1a\u4e0b\u53d1\u4efb\u52a1\u5361\u6267\u884c\u7684\u4efb\u52a1\n2.\u6d45\u7d2b\u8272:\u8868\u793a\u5c3e\u9636\u4efb\u52a1\uff0c\u4f1a\u4e0b\u53d1\u4efb\u52a1\u5361\u6267\u884c\u7684\u4efb\u52a1\n3.\u4eae\u84dd\u8272:\u8868\u793a\u4e2d\u9636\u4efb\u52a1\uff0c\u65e2\u4e0d\u662f\u9996\u9636\u4e5f\u4e0d\u662f\u5c3e\u9636\uff0c\u4e0d\u4f1a\u4e0b\u53d1\u4efb\u52a1\u5361\u6267\u884c\u7684\u4efb\u52a1";
                        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
                        MessageBar messageBar = MessageBar.create((String)localeService.getLanguageValue(locale, content), (Integer)MessageBarStyleTypeEnum.BLACK_WORD_GREEN_BACKGROUDCOLOR.getType(), (Integer)59027);
                        CustomTabContentContainer messageBarContainer = new CustomTabContentContainer();
                        messageBarContainer.setData((Object)messageBar);
                        messageBarContainer.setContentCmptType("MESSAGE_BAR");
                        customTab.addCustomTabContentContainer(messageBarContainer);
                    }
                    ZtbViewList stageZtbViewList = new ZtbViewList();
                    stageZtbViewList.setData(processedTaskList.stream().map(projectTaskInfo -> ProjectCCTaskItem.createProjectCard((ApiRequest)apiRequest, (PccProjectTaskInfo)projectTaskInfo, (List)pccProjectTaskInfoList, (String)finalProjectNo, (String)pageSetting.getPageId(), (boolean)isPcc, (boolean)isPccPlan, (boolean)false, (Boolean)false)).collect(Collectors.toList()));
                    CustomTabContentContainer stageContainer = new CustomTabContentContainer();
                    stageContainer.setData((Object)stageZtbViewList);
                    stageContainer.setContentCmptType("ZTB_VIEW_LIST");
                    customTab.addCustomTabContentContainer(stageContainer);
                    continue;
                }
                if ("TASK_LIST".equalsIgnoreCase(type) && "TASK_ITEM".equalsIgnoreCase(mContentType) && "CRITICAL_PATH".equalsIgnoreCase(mBizKey)) {
                    CustomTabContentContainer container2;
                    if (!isPcc.booleanValue()) continue;
                    Assert.notNull((Object)args[1], (String)"args[1] must not null!");
                    Assert.isInstanceOf(List.class, (Object)args[1], (String)"args[1] must be instance of List.class!");
                    pccProjectTaskInfoList = (List)args[1];
                    List taskNoList = this.digiwinEspProxyService.getNewProjectCriticalPath(apiRequest.getIamUserToken(), projectNo, tenantId, locale);
                    if (!taskNoList.isEmpty()) {
                        container2 = new CustomTabContentContainer();
                        List criticalPathTaskInfoList = taskNoList.stream().map(taskNo -> pccProjectTaskInfoList.stream().filter(digiwinAtdmProjectTaskInfo -> taskNo.equalsIgnoreCase(digiwinAtdmProjectTaskInfo.getTaskNo())).findFirst().orElse(null)).collect(Collectors.toList());
                        criticalPathTaskInfoList.removeAll(Collections.singleton(null));
                        ZtbViewList criticalPathZtbViewList = new ZtbViewList();
                        criticalPathZtbViewList.setData(criticalPathTaskInfoList.stream().map(projectCriticalPathTaskInfo -> ProjectCCTaskItem.createProjectCard((ApiRequest)apiRequest, (PccProjectTaskInfo)projectCriticalPathTaskInfo, (List)pccProjectTaskInfoList, (String)finalProjectNo, (String)pageSetting.getPageId(), (boolean)true, (boolean)isPccPlan, (boolean)true, (Boolean)false)).collect(Collectors.toList()));
                        container2.setData((Object)criticalPathZtbViewList);
                        container2.setContentCmptType("ZTB_VIEW_LIST");
                        customTab.setScrollMode(CustomTabScrollModeEnum.TAB_SCROLL.getMode());
                        if (null != mMajor) {
                            container2.setMajor(mMajor);
                        }
                        if (null != mPosition) {
                            container2.setPosition(mPosition);
                        }
                        customTab.addCustomTabContentContainer(container2);
                        continue;
                    }
                    container2 = new CustomTabContentContainer();
                    Empty empty = Empty.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6682\u65e0\u5173\u952e\u8def\u5f84"));
                    container2.setData((Object)empty);
                    container2.setContentCmptType("EMPTY");
                    if (null != mMajor) {
                        container2.setMajor(mMajor);
                    }
                    if (null != mPosition) {
                        container2.setPosition(mPosition);
                    }
                    customTab.addCustomTabContentContainer(container2);
                    continue;
                }
                if ("TASK_LIST".equalsIgnoreCase(type) && "TASK_ITEM".equalsIgnoreCase(mContentType) && "TASK".equalsIgnoreCase(mBizKey)) {
                    DataItemInTaskList dataItemInTaskList;
                    Assert.notNull((Object)args[1], (String)"args[1] must not null!");
                    Assert.isInstanceOf(List.class, (Object)args[1], (String)"args[1] must be instance of List.class!");
                    pccProjectTaskInfoList = (List)args[1];
                    List allLeafTaskInfoList = this.getLeafTaskInfoList(null, pccProjectTaskInfoList);
                    List overdueTaskInfoList = allLeafTaskInfoList.stream().filter(PccProjectTaskInfo::isOverdue).sorted(Comparator.comparingLong(PccProjectTaskInfo::getOverduePeriodInDay).reversed()).collect(Collectors.toList());
                    List normalDoingTaskInfoList = allLeafTaskInfoList.stream().filter(taskInfo -> !taskInfo.isOverdue()).filter(PccProjectTaskInfo::isDoing).sorted(Comparator.comparingLong(PccProjectTaskInfo::getPlanStartDateEpochDay)).collect(Collectors.toList());
                    List normalTodoTaskInfoList = allLeafTaskInfoList.stream().filter(taskInfo -> !taskInfo.isOverdue()).filter(PccProjectTaskInfo::isTodo).sorted(Comparator.comparingLong(PccProjectTaskInfo::getPlanStartDateEpochDay)).collect(Collectors.toList());
                    List normalFinishedTaskInfoList = allLeafTaskInfoList.stream().filter(taskInfo -> !taskInfo.isOverdue()).filter(PccProjectTaskInfo::isDone).sorted(Comparator.comparingLong(PccProjectTaskInfo::getPlanStartDateEpochDay)).collect(Collectors.toList());
                    ArrayList<Retractable> retractableList = new ArrayList<Retractable>();
                    TaskList taskList = new TaskList();
                    if (!overdueTaskInfoList.isEmpty()) {
                        dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f"));
                        if (isPcc.booleanValue()) {
                            retractableList.add(this.buildRetractable(overdueTaskInfoList, pccProjectTaskInfoList, apiRequest, finalProjectNo, pageSetting, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "\u903e\u671f"));
                        } else {
                            dataItemInTaskList.setData(overdueTaskInfoList.stream().map(taskInfo -> ProjectCCTaskItem.createKsc((String)locale, (PccProjectTaskInfo)taskInfo, (List)pccProjectTaskInfoList, (boolean)false, (String)apiRequest.getIamUserToken(), (String)finalProjectNo)).collect(Collectors.toList()));
                        }
                        taskList.add((Object)dataItemInTaskList);
                    }
                    if (!normalDoingTaskInfoList.isEmpty()) {
                        dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8fdb\u884c\u4e2d"));
                        if (isPcc.booleanValue()) {
                            retractableList.add(this.buildRetractable(normalDoingTaskInfoList, pccProjectTaskInfoList, apiRequest, finalProjectNo, pageSetting, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "\u8fdb\u884c\u4e2d"));
                        } else {
                            dataItemInTaskList.setData(normalDoingTaskInfoList.stream().map(taskInfo -> ProjectCCTaskItem.createKsc((String)locale, (PccProjectTaskInfo)taskInfo, (List)pccProjectTaskInfoList, (boolean)false, (String)apiRequest.getIamUserToken(), (String)finalProjectNo)).collect(Collectors.toList()));
                        }
                        taskList.add((Object)dataItemInTaskList);
                    }
                    if (!normalTodoTaskInfoList.isEmpty()) {
                        dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u672a\u5f00\u59cb"));
                        if (isPcc.booleanValue()) {
                            retractableList.add(this.buildRetractable(normalTodoTaskInfoList, pccProjectTaskInfoList, apiRequest, finalProjectNo, pageSetting, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "\u672a\u5f00\u59cb"));
                        } else {
                            dataItemInTaskList.setData(normalTodoTaskInfoList.stream().map(taskInfo -> ProjectCCTaskItem.createKsc((String)locale, (PccProjectTaskInfo)taskInfo, (List)pccProjectTaskInfoList, (boolean)false, (String)apiRequest.getIamUserToken(), (String)finalProjectNo)).collect(Collectors.toList()));
                        }
                        taskList.add((Object)dataItemInTaskList);
                    }
                    if (!normalFinishedTaskInfoList.isEmpty()) {
                        dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u5b8c\u6210"));
                        if (isPcc.booleanValue()) {
                            retractableList.add(this.buildRetractable(normalFinishedTaskInfoList, pccProjectTaskInfoList, apiRequest, finalProjectNo, pageSetting, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "\u5df2\u5b8c\u6210"));
                        } else {
                            dataItemInTaskList.setData(normalFinishedTaskInfoList.stream().map(taskInfo -> ProjectCCTaskItem.createKsc((String)locale, (PccProjectTaskInfo)taskInfo, (List)pccProjectTaskInfoList, (boolean)false, (String)apiRequest.getIamUserToken(), (String)finalProjectNo)).collect(Collectors.toList()));
                        }
                        taskList.add((Object)dataItemInTaskList);
                    }
                    CustomTabContentContainer container3 = new CustomTabContentContainer();
                    if (isPcc.booleanValue()) {
                        List customTabContentContainerList = retractableList.stream().map(retractable -> {
                            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
                            customTabContentContainer.setContentCmptType("RETRACYABLE");
                            customTabContentContainer.setData(retractable);
                            return customTabContentContainer;
                        }).collect(Collectors.toList());
                        customTab.setContent(customTabContentContainerList);
                        customTab.setScrollMode(CustomTabScrollModeEnum.TAB_SCROLL.getMode());
                    } else {
                        container3.setData((Object)taskList);
                        container3.setContentCmptType(type);
                        customTab.addCustomTabContentContainer(container3);
                    }
                    if (null != mMajor) {
                        container3.setMajor(mMajor);
                    }
                    if (null == mPosition) continue;
                    container3.setPosition(mPosition);
                    continue;
                }
                if ("MULTI_LEVEL_SUBMITTABLE_LIST".equalsIgnoreCase(type) && "MULTI_LEVEL_SUBMITTABLE_ITEM".equalsIgnoreCase(mContentType)) {
                    BizProcessDataList bizProcessDataList = this.bizProcessDataListBuilder.build(apiRequest, pageSetting, pcUiBotModel, BizProcessDataList.class, new Object[]{subTabChildLayout});
                    selectable = Optional.ofNullable(bizProcessDataList.getSelectable()).orElse(false);
                    customTab.setName(customTab.getName() + " " + bizProcessDataList.bizDataSize());
                    container = new CustomTabContentContainer();
                    container.setData((Object)bizProcessDataList);
                    container.setContentCmptType(type);
                    if (null != mMajor) {
                        container.setMajor(mMajor);
                    }
                    if (null != mPosition) {
                        container.setPosition(mPosition);
                    }
                    customTab.addCustomTabContentContainer(container);
                    continue;
                }
                if (!"SUBMIT_BUTTON".equalsIgnoreCase(type)) continue;
                List submitButtonList = this.submitButtonBuilder.build(apiRequest, pageSetting, pcUiBotModel, SubmitButton.class, new Object[]{subTabChildLayout, selectable});
                container = new CustomTabContentContainer();
                container.setData((Object)submitButtonList);
                container.setContentCmptType(type);
                if (null != mMajor) {
                    container.setMajor(mMajor);
                }
                if (null != mPosition) {
                    container.setPosition(mPosition);
                }
                customTab.addCustomTabContentContainer(container);
            }
        }
        return customTabs;
    }

    private Retractable buildRetractable(List<PccProjectTaskInfo> taskInfoList, List<PccProjectTaskInfo> pccProjectTaskInfoList, ApiRequest apiRequest, String finalProjectNo, PageSetting pageSetting, Boolean isPcc, Boolean isPccPlan, Boolean isCriticalPath, String title) {
        ZtbViewList stageZtbViewList = new ZtbViewList();
        stageZtbViewList.setData(taskInfoList.stream().map(projectTaskInfo -> ProjectCCTaskItem.createProjectCard((ApiRequest)apiRequest, (PccProjectTaskInfo)projectTaskInfo, (List)pccProjectTaskInfoList, (String)finalProjectNo, (String)pageSetting.getPageId(), (boolean)isPcc, (boolean)isPccPlan, (boolean)isCriticalPath, (Boolean)true)).collect(Collectors.toList()));
        Retractable retractable = new Retractable();
        retractable.setStyle(Integer.valueOf(2));
        retractable.setIsExpand(Boolean.valueOf(true));
        retractable.setTitle(ModuleUtils.localeService.getLanguageValue(apiRequest.getLocale(), title + "(" + taskInfoList.size() + ")"));
        retractable.setContent(Collections.singletonList(new BaseMobileComponentWrapper((BaseMobileComponent)stageZtbViewList, "ZTB_VIEW_LIST")));
        return retractable;
    }

    private List<PccProjectTaskInfo> getLeafTaskInfoList(List<PccProjectTaskInfo> rootTaskInfoList, List<PccProjectTaskInfo> allTaskInfoList) {
        ArrayList<PccProjectTaskInfo> resultTaskInfoList = new ArrayList<PccProjectTaskInfo>();
        List tempRootTaskInfoList = rootTaskInfoList;
        if (rootTaskInfoList == null) {
            tempRootTaskInfoList = this.getRootTaskInfoList(allTaskInfoList);
        }
        for (PccProjectTaskInfo taskInfo : tempRootTaskInfoList) {
            List childrenTaskList = taskInfo.filterNextLevelProjectTaskInfo(allTaskInfoList);
            if (childrenTaskList.isEmpty()) {
                resultTaskInfoList.add(taskInfo);
                continue;
            }
            resultTaskInfoList.addAll(this.getLeafTaskInfoList(childrenTaskList, allTaskInfoList));
        }
        return resultTaskInfoList;
    }

    private List<PccProjectTaskInfo> getRootTaskInfoList(List<PccProjectTaskInfo> allTaskInfoList) {
        return allTaskInfoList.stream().filter(taskInfo -> taskInfo.getUpperLevelTaskNo().equals(taskInfo.getTaskNo())).collect(Collectors.toList());
    }
}

