/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller;

import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public class CustomTabContentArea
implements Serializable {
    private static final long serialVersionUID = -2689889804986579630L;
    private List<CustomTabContentContainer> bodyArea = new ArrayList();
    private List<CustomTabContentContainer> bottomArea = new ArrayList();
    private Integer size;

    public void resetSize() {
        this.size = 0;
        if (CollectionUtils.isEmpty((Collection)this.bodyArea)) {
            return;
        }
        boolean existCustomGroup = this.bodyArea.stream().anyMatch(content -> "DW_CUSTOM_GROUP".equals(content.getContentCmptType()));
        if (existCustomGroup) {
            this.size = 1;
            return;
        }
        Optional<CustomTabContentContainer> optional = this.bodyArea.stream().filter(content -> "DW_ZTB_VIEW_LIST".equals(content.getContentCmptType())).findFirst();
        if (optional.isPresent()) {
            ZtbViewList ztbViewList = (ZtbViewList)optional.get().getData();
            if (ztbViewList != null) {
                List cardList = ztbViewList.getData();
                this.size = CollectionUtils.isEmpty((Collection)cardList) ? 0 : cardList.size();
                Optional.ofNullable(ztbViewList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(arg_0 -> this.setSize(arg_0));
            }
            return;
        }
        Optional<CustomTabContentContainer> editOptional = this.bodyArea.stream().filter(content -> "DW_EDIT_CARD_LIST".equals(content.getContentCmptType())).findFirst();
        if (editOptional.isPresent()) {
            EditCardList editCardList = (EditCardList)editOptional.get().getData();
            if (editCardList != null) {
                List contentGroup = editCardList.getContentGroup();
                this.size = CollectionUtils.isEmpty((Collection)contentGroup) ? 0 : contentGroup.size();
                Optional.ofNullable(editCardList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(arg_0 -> this.setSize(arg_0));
            }
            return;
        }
        boolean existEmpty = this.bodyArea.stream().anyMatch(content -> "DW_EMPTY".equals(content.getContentCmptType()));
        if (existEmpty) {
            return;
        }
        this.size = 1;
    }

    public List<CustomTabContentContainer> getBodyArea() {
        return this.bodyArea;
    }

    public List<CustomTabContentContainer> getBottomArea() {
        return this.bottomArea;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setBodyArea(List<CustomTabContentContainer> bodyArea) {
        this.bodyArea = bodyArea;
    }

    public void setBottomArea(List<CustomTabContentContainer> bottomArea) {
        this.bottomArea = bottomArea;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomTabContentArea)) {
            return false;
        }
        CustomTabContentArea other = (CustomTabContentArea)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        List this$bodyArea = this.getBodyArea();
        List other$bodyArea = other.getBodyArea();
        if (this$bodyArea == null ? other$bodyArea != null : !((Object)this$bodyArea).equals(other$bodyArea)) {
            return false;
        }
        List this$bottomArea = this.getBottomArea();
        List other$bottomArea = other.getBottomArea();
        return !(this$bottomArea == null ? other$bottomArea != null : !((Object)this$bottomArea).equals(other$bottomArea));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomTabContentArea;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        List $bodyArea = this.getBodyArea();
        result = result * 59 + ($bodyArea == null ? 43 : ((Object)$bodyArea).hashCode());
        List $bottomArea = this.getBottomArea();
        result = result * 59 + ($bottomArea == null ? 43 : ((Object)$bottomArea).hashCode());
        return result;
    }

    public String toString() {
        return "CustomTabContentArea(bodyArea=" + this.getBodyArea() + ", bottomArea=" + this.getBottomArea() + ", size=" + this.getSize() + ")";
    }

    public CustomTabContentArea() {
    }

    public CustomTabContentArea(List<CustomTabContentContainer> bodyArea, List<CustomTabContentContainer> bottomArea, Integer size) {
        this.bodyArea = bodyArea;
        this.bottomArea = bottomArea;
        this.size = size;
    }
}

