/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.index.TripartiteTodoList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemAsyncConfig;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.LabelSystemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class CustomTabController
extends BaseMobileComponent {
    private static final long serialVersionUID = 6349823522671953392L;
    public static final String COMPONENT_TYPE = "CUSTOM_TAB_CONTROLLER";
    private Boolean swipeable;
    private Integer tabAlign;
    private List<CustomTabControllerItem> tabItems;
    private Integer tabLayoutType;
    private Integer defaultSelected = 0;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void updateAsyncConfigParam(String iamUserToken, String locale, String clientId, String tenantId) {
        for (CustomTabControllerItem item : this.getTabItems()) {
            if (!item.getAsyncForData().booleanValue()) continue;
            CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();
            asyncConfig.setIamUserToken(iamUserToken);
            asyncConfig.setLocale(locale);
            asyncConfig.setClientId(clientId);
            asyncConfig.setTenantId(tenantId);
            String configuredUrl = asyncConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl + "?clientId=" + clientId + "&tenantId=" + tenantId;
            asyncConfig.setRequestUrl(newUrl);
        }
    }

    public void updateAsyncTripartiteToDoConfigParam(String iamUserToken, String locale, String clientId, String tenantId, List<LabelSystemData> labelSystemDataList) {
        HashMap map = new HashMap();
        ArrayList<CustomTabContentContainer> content = new ArrayList<CustomTabContentContainer>();
        CustomTabContentContainer taskContent = new CustomTabContentContainer();
        ArrayList tripartiteTodoLists = new ArrayList();
        for (CustomTabControllerItem item : this.getTabItems()) {
            if (!item.getAsyncForData().booleanValue()) continue;
            CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();
            asyncConfig.setIamUserToken(iamUserToken);
            asyncConfig.setLocale(locale);
            asyncConfig.setClientId(clientId);
            asyncConfig.setTenantId(tenantId);
            String configuredUrl = asyncConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl + "?clientId=" + clientId + "&tenantId=" + tenantId;
            asyncConfig.setRequestUrl(newUrl);
            if (!ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId())) continue;
            if (CollectionUtils.isEmpty(labelSystemDataList)) {
                taskContent.setContentCmptType("TRIPARTITE_TODO_LIST");
                taskContent.setData(map);
                content.add(taskContent);
                item.setContent(content);
                item.setAsyncConfig(null);
                continue;
            }
            labelSystemDataList.forEach(labelSystemData -> {
                TripartiteTodoList tripartite = new TripartiteTodoList();
                tripartite.setNodeName(labelSystemData.getAppName());
                tripartite.setNodeId(String.valueOf(labelSystemData.getId()));
                tripartite.setIsExpand(Boolean.valueOf(true));
                tripartite.setAsyncConfig(asyncConfig);
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                rowData.put("id", labelSystemData.getId());
                rowData.put("appCode", labelSystemData.getAppId());
                rowData.put("appName", labelSystemData.getAppName());
                rowData.put("callBackUrl", labelSystemData.getCallBackUrl());
                rowData.put("protocolType", labelSystemData.getProtocolType());
                rowData.put("isNeedSsoUrl", labelSystemData.getIsNeedSsoUrl());
                rowData.put("isFixedRefresh", labelSystemData.getIsFixedRefresh());
                tripartite.setRawData(rowData);
                tripartiteTodoLists.add(tripartite);
            });
            taskContent.setContentCmptType("TRIPARTITE_TODO_LIST");
            map.put("data", tripartiteTodoLists);
            taskContent.setData(map);
            content.add(taskContent);
            item.setContent(content);
            item.setAsyncConfig(null);
        }
    }

    public Boolean getSwipeable() {
        return this.swipeable;
    }

    public Integer getTabAlign() {
        return this.tabAlign;
    }

    public List<CustomTabControllerItem> getTabItems() {
        return this.tabItems;
    }

    public Integer getTabLayoutType() {
        return this.tabLayoutType;
    }

    public Integer getDefaultSelected() {
        return this.defaultSelected;
    }

    public void setSwipeable(Boolean swipeable) {
        this.swipeable = swipeable;
    }

    public void setTabAlign(Integer tabAlign) {
        this.tabAlign = tabAlign;
    }

    public void setTabItems(List<CustomTabControllerItem> tabItems) {
        this.tabItems = tabItems;
    }

    public void setTabLayoutType(Integer tabLayoutType) {
        this.tabLayoutType = tabLayoutType;
    }

    public void setDefaultSelected(Integer defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomTabController)) {
            return false;
        }
        CustomTabController other = (CustomTabController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$swipeable = this.getSwipeable();
        Boolean other$swipeable = other.getSwipeable();
        if (this$swipeable == null ? other$swipeable != null : !((Object)this$swipeable).equals(other$swipeable)) {
            return false;
        }
        Integer this$tabAlign = this.getTabAlign();
        Integer other$tabAlign = other.getTabAlign();
        if (this$tabAlign == null ? other$tabAlign != null : !((Object)this$tabAlign).equals(other$tabAlign)) {
            return false;
        }
        Integer this$tabLayoutType = this.getTabLayoutType();
        Integer other$tabLayoutType = other.getTabLayoutType();
        if (this$tabLayoutType == null ? other$tabLayoutType != null : !((Object)this$tabLayoutType).equals(other$tabLayoutType)) {
            return false;
        }
        Integer this$defaultSelected = this.getDefaultSelected();
        Integer other$defaultSelected = other.getDefaultSelected();
        if (this$defaultSelected == null ? other$defaultSelected != null : !((Object)this$defaultSelected).equals(other$defaultSelected)) {
            return false;
        }
        List this$tabItems = this.getTabItems();
        List other$tabItems = other.getTabItems();
        return !(this$tabItems == null ? other$tabItems != null : !((Object)this$tabItems).equals(other$tabItems));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomTabController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $swipeable = this.getSwipeable();
        result = result * 59 + ($swipeable == null ? 43 : ((Object)$swipeable).hashCode());
        Integer $tabAlign = this.getTabAlign();
        result = result * 59 + ($tabAlign == null ? 43 : ((Object)$tabAlign).hashCode());
        Integer $tabLayoutType = this.getTabLayoutType();
        result = result * 59 + ($tabLayoutType == null ? 43 : ((Object)$tabLayoutType).hashCode());
        Integer $defaultSelected = this.getDefaultSelected();
        result = result * 59 + ($defaultSelected == null ? 43 : ((Object)$defaultSelected).hashCode());
        List $tabItems = this.getTabItems();
        result = result * 59 + ($tabItems == null ? 43 : ((Object)$tabItems).hashCode());
        return result;
    }

    public String toString() {
        return "CustomTabController(swipeable=" + this.getSwipeable() + ", tabAlign=" + this.getTabAlign() + ", tabItems=" + this.getTabItems() + ", tabLayoutType=" + this.getTabLayoutType() + ", defaultSelected=" + this.getDefaultSelected() + ")";
    }
}

