/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.standardtab;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

public class StandardTabsContentArea
implements Serializable {
    private static final long serialVersionUID = 5720598812507992970L;
    private Boolean filterFlag;
    private Integer size;
    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyArea;

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getBodyArea() {
        this.bodyArea = this.bodyArea == null ? new ArrayList() : this.bodyArea;
        return this.bodyArea;
    }

    public void resetSize() {
        this.size = 0;
        if (CollectionUtils.isEmpty((Collection)this.bodyArea)) {
            return;
        }
        Optional<BaseMobileComponentWrapper> optional = this.bodyArea.stream().filter(content -> "DW_ZTB_VIEW_LIST".equals(content.getComponentType())).findFirst();
        if (optional.isPresent()) {
            ZtbViewList ztbViewList = (ZtbViewList)optional.get().getData();
            if (ztbViewList != null) {
                List cardList = ztbViewList.getData();
                this.size = CollectionUtils.isEmpty((Collection)cardList) ? 0 : cardList.size();
                Optional.ofNullable(ztbViewList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(arg_0 -> this.setSize(arg_0));
            }
            return;
        }
        Optional<BaseMobileComponentWrapper> editOptional = this.bodyArea.stream().filter(content -> "DW_EDIT_CARD_LIST".equals(content.getComponentType())).findFirst();
        if (editOptional.isPresent()) {
            EditCardList editCardList = (EditCardList)editOptional.get().getData();
            if (editCardList != null) {
                List contentGroup = editCardList.getContentGroup();
                this.size = CollectionUtils.isEmpty((Collection)contentGroup) ? 0 : contentGroup.size();
                Optional.ofNullable(editCardList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(arg_0 -> this.setSize(arg_0));
            }
            return;
        }
        boolean existEmpty = this.bodyArea.stream().anyMatch(content -> "DW_EMPTY".equals(content.getComponentType()));
        if (existEmpty) {
            return;
        }
        this.size = 1;
    }

    public void resetFilterFlag() {
        this.filterFlag = false;
        if (CollectionUtils.isEmpty((Collection)this.bodyArea)) {
            return;
        }
        this.bodyArea.stream().filter(content -> "DW_ZTB_VIEW_LIST".equals(content.getComponentType()) || "DW_EDIT_CARD_LIST".equals(content.getComponentType())).findFirst().ifPresent(wapper -> {
            if (wapper.getData() instanceof ZtbViewList) {
                this.filterFlag = BooleanUtils.isTrue((Boolean)((ZtbViewList)wapper.getData()).getFilterFlag());
            } else if (wapper.getData() instanceof EditCardList) {
                this.filterFlag = BooleanUtils.isTrue((Boolean)((EditCardList)wapper.getData()).getFilterFlag());
            }
        });
    }

    public Boolean getFilterFlag() {
        return this.filterFlag;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setFilterFlag(Boolean filterFlag) {
        this.filterFlag = filterFlag;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    public void setBodyArea(List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyArea) {
        this.bodyArea = bodyArea;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardTabsContentArea)) {
            return false;
        }
        StandardTabsContentArea other = (StandardTabsContentArea)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$filterFlag = this.getFilterFlag();
        Boolean other$filterFlag = other.getFilterFlag();
        if (this$filterFlag == null ? other$filterFlag != null : !((Object)this$filterFlag).equals(other$filterFlag)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        List this$bodyArea = this.getBodyArea();
        List other$bodyArea = other.getBodyArea();
        return !(this$bodyArea == null ? other$bodyArea != null : !((Object)this$bodyArea).equals(other$bodyArea));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StandardTabsContentArea;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $filterFlag = this.getFilterFlag();
        result = result * 59 + ($filterFlag == null ? 43 : ((Object)$filterFlag).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        List $bodyArea = this.getBodyArea();
        result = result * 59 + ($bodyArea == null ? 43 : ((Object)$bodyArea).hashCode());
        return result;
    }

    public String toString() {
        return "StandardTabsContentArea(filterFlag=" + this.getFilterFlag() + ", size=" + this.getSize() + ", bodyArea=" + this.getBodyArea() + ")";
    }
}

