/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.table.TableColumnColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.table.TableColumnConfig;
import com.digiwin.mobile.mobileuibot.core.component.table.TableCompoundColumnColorPalette;
import com.digiwin.mobile.mobileuibot.core.component.table.TableHeaderHAlignTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.AgileDataTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.TableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableCompoundColumn
implements Serializable {
    private static final long serialVersionUID = 5398682004974673467L;
    private String columnId;
    private String fontColor;
    @JsonProperty(value="hAlignType")
    @JSONField(name="hAlignType")
    private String hAlignType = TableHeaderHAlignTypeEnum.LEFT.getValue();

    public void buildFontColor(TableColumnConfig tableColumnConfig, JSONArray operations) {
        if (AgileDataTableColumn.canDrillDown((JSONArray)operations).booleanValue()) {
            tableColumnConfig.setCanDrillDown(Boolean.valueOf(true));
            tableColumnConfig.setFontColor(TableColumnColorEnum.CAN_DRILL_DOWN.getColor());
        } else if (AgileDataTableColumn.isHighlight((JSONArray)operations).booleanValue()) {
            tableColumnConfig.setFontColor(TableColumnColorEnum.HIGHLIGHT.getColor());
        } else {
            tableColumnConfig.setCanDrillDown(Boolean.valueOf(false));
        }
    }

    public static List<TableCompoundColumn> getCompoundColumns(TableColumnDefinition columnDefinition) {
        if (!columnDefinition.preferCompoundMode()) {
            return Collections.emptyList();
        }
        List decomposedColumns = TableColumnDefinition.decomposeTableColumn((List)columnDefinition.getColumns());
        ArrayList<TableCompoundColumn> compoundColumns = new ArrayList<TableCompoundColumn>(decomposedColumns.size());
        for (int i = 0; i < decomposedColumns.size(); ++i) {
            UiBotTableColumn tableColumn = (UiBotTableColumn)decomposedColumns.get(i);
            TableCompoundColumn compoundColumn = new TableCompoundColumn();
            compoundColumn.setColumnId(tableColumn.getSchema());
            compoundColumn.setFontColor(TableCompoundColumnColorPalette.getColorFromColumnPalette((int)i));
            compoundColumns.add(compoundColumn);
        }
        return compoundColumns;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public String getHAlignType() {
        return this.hAlignType;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    @JsonProperty(value="hAlignType")
    public void setHAlignType(String hAlignType) {
        this.hAlignType = hAlignType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableCompoundColumn)) {
            return false;
        }
        TableCompoundColumn other = (TableCompoundColumn)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$columnId = this.getColumnId();
        String other$columnId = other.getColumnId();
        if (this$columnId == null ? other$columnId != null : !this$columnId.equals(other$columnId)) {
            return false;
        }
        String this$fontColor = this.getFontColor();
        String other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !this$fontColor.equals(other$fontColor)) {
            return false;
        }
        String this$hAlignType = this.getHAlignType();
        String other$hAlignType = other.getHAlignType();
        return !(this$hAlignType == null ? other$hAlignType != null : !this$hAlignType.equals(other$hAlignType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableCompoundColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnId = this.getColumnId();
        result = result * 59 + ($columnId == null ? 43 : $columnId.hashCode());
        String $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : $fontColor.hashCode());
        String $hAlignType = this.getHAlignType();
        result = result * 59 + ($hAlignType == null ? 43 : $hAlignType.hashCode());
        return result;
    }

    public String toString() {
        return "TableCompoundColumn(columnId=" + this.getColumnId() + ", fontColor=" + this.getFontColor() + ", hAlignType=" + this.getHAlignType() + ")";
    }

    public TableCompoundColumn() {
    }

    public TableCompoundColumn(String columnId, String fontColor, String hAlignType) {
        this.columnId = columnId;
        this.fontColor = fontColor;
        this.hAlignType = hAlignType;
    }
}

