/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.customtaskconfig;

import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskUrlConfig;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Document(collection="customTaskConfig")
public class CustomTaskConfig
implements Serializable {
    private static final long serialVersionUID = -7984118157325999337L;
    @Field(value="_id")
    private String id;
    private String tmTaskId;
    private String tmActivityId;
    private CustomTaskUrlConfig customTaskUrlConfig;

    public String getCustomTaskUrl(String locale, String iamUserToken, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        Assert.notNull((Object)this.getCustomTaskUrlConfig(), (String)"CustomTaskUrlConfig MUST NOT NULL");
        CustomTaskUrlConfig customTaskUrlConfig = this.getCustomTaskUrlConfig();
        String requestUrl = customTaskUrlConfig.getScheme() + "://" + customTaskUrlConfig.getHost() + ":" + customTaskUrlConfig.getPort() + this.getQueryString(locale, iamUserToken, digiwinAtmcBacklog);
        return requestUrl;
    }

    private String getQueryString(String locale, String iamUserToken, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        String uriStr;
        LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>();
        String tmTaskId = digiwinAtmcBacklog.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklog.getTmActivityId();
        String tmPattern = digiwinAtmcBacklog.getTmPattern();
        String tmCategory = digiwinAtmcBacklog.getTmCategory();
        String backlogId = String.valueOf(digiwinAtmcBacklog.getBacklogId());
        String tenantId = digiwinAtmcBacklog.getTenantId();
        queryMap.put("locale", locale.trim());
        queryMap.put("mobile_user_token", iamUserToken.trim());
        queryMap.put("tmTaskId", tmTaskId.trim());
        queryMap.put("tmActivityId", tmActivityId.trim());
        queryMap.put("tmPattern", tmPattern.trim());
        queryMap.put("tmCategory", tmCategory.trim());
        queryMap.put("backlogId", backlogId.trim());
        queryMap.put("tenantId", tenantId.trim());
        if (StringUtils.hasLength((String)digiwinAtmcBacklog.getProxyToken())) {
            queryMap.put("digiProxyToken", digiwinAtmcBacklog.getProxyToken().trim());
        }
        String queryString = uriStr = Optional.of(this.getCustomTaskUrlConfig()).map(CustomTaskUrlConfig::getUri).orElse("");
        if (null != queryMap) {
            if (uriStr.indexOf("?") < 0) {
                queryString = queryString + "?locale=" + queryMap.get("locale") + "&mobile_user_token=" + queryMap.get("mobile_user_token") + "&tmTaskId=" + queryMap.get("tmTaskId") + "&tmActivityId=" + queryMap.get("tmActivityId") + "&tmPattern=" + queryMap.get("tmPattern") + "&tmCategory=" + queryMap.get("tmCategory") + "&backlogId=" + queryMap.get("backlogId") + "&tenantId=" + queryMap.get("tenantId");
                if (queryMap.containsKey("digiProxyToken")) {
                    queryString = queryString + "&digiProxyToken=" + queryMap.get("digiProxyToken");
                }
            } else {
                for (Map.Entry entry : queryMap.entrySet()) {
                    if (uriStr.indexOf("${" + entry.getKey() + "}") < 0) {
                        queryString = queryString + "&" + entry.getKey() + "=" + entry.getValue();
                        continue;
                    }
                    queryString = queryString.replace("${" + entry.getKey() + "}", (String)entry.getValue());
                }
            }
        }
        return queryString;
    }

    public String getId() {
        return this.id;
    }

    public String getTmTaskId() {
        return this.tmTaskId;
    }

    public String getTmActivityId() {
        return this.tmActivityId;
    }

    public CustomTaskUrlConfig getCustomTaskUrlConfig() {
        return this.customTaskUrlConfig;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTmTaskId(String tmTaskId) {
        this.tmTaskId = tmTaskId;
    }

    public void setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
    }

    public void setCustomTaskUrlConfig(CustomTaskUrlConfig customTaskUrlConfig) {
        this.customTaskUrlConfig = customTaskUrlConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomTaskConfig)) {
            return false;
        }
        CustomTaskConfig other = (CustomTaskConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tmTaskId = this.getTmTaskId();
        String other$tmTaskId = other.getTmTaskId();
        if (this$tmTaskId == null ? other$tmTaskId != null : !this$tmTaskId.equals(other$tmTaskId)) {
            return false;
        }
        String this$tmActivityId = this.getTmActivityId();
        String other$tmActivityId = other.getTmActivityId();
        if (this$tmActivityId == null ? other$tmActivityId != null : !this$tmActivityId.equals(other$tmActivityId)) {
            return false;
        }
        CustomTaskUrlConfig this$customTaskUrlConfig = this.getCustomTaskUrlConfig();
        CustomTaskUrlConfig other$customTaskUrlConfig = other.getCustomTaskUrlConfig();
        return !(this$customTaskUrlConfig == null ? other$customTaskUrlConfig != null : !this$customTaskUrlConfig.equals(other$customTaskUrlConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomTaskConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tmTaskId = this.getTmTaskId();
        result = result * 59 + ($tmTaskId == null ? 43 : $tmTaskId.hashCode());
        String $tmActivityId = this.getTmActivityId();
        result = result * 59 + ($tmActivityId == null ? 43 : $tmActivityId.hashCode());
        CustomTaskUrlConfig $customTaskUrlConfig = this.getCustomTaskUrlConfig();
        result = result * 59 + ($customTaskUrlConfig == null ? 43 : $customTaskUrlConfig.hashCode());
        return result;
    }

    public String toString() {
        return "CustomTaskConfig(id=" + this.getId() + ", tmTaskId=" + this.getTmTaskId() + ", tmActivityId=" + this.getTmActivityId() + ", customTaskUrlConfig=" + this.getCustomTaskUrlConfig() + ")";
    }

    public CustomTaskConfig() {
    }

    public CustomTaskConfig(String id, String tmTaskId, String tmActivityId, CustomTaskUrlConfig customTaskUrlConfig) {
        this.id = id;
        this.tmTaskId = tmTaskId;
        this.tmActivityId = tmActivityId;
        this.customTaskUrlConfig = customTaskUrlConfig;
    }
}

