/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.rule;

import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import java.util.List;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service(value="ruleService")
public class RuleServiceImpl
implements RuleService {
    private static final Logger logger = LoggerFactory.getLogger(RuleServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<Rule> findByRulePath(String path) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"path").is((Object)path));
        return this.mongoTemplate.find(query, Rule.class);
    }

    public List<Rule> findByRulePathAndPageId(String path, String pageId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"path").is((Object)path).and("pageId").is((Object)pageId));
        return this.mongoTemplate.find(query, Rule.class);
    }

    public List<Rule> findByRuleCategory(String category) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").is((Object)category));
        return this.mongoTemplate.find(query, Rule.class);
    }

    public List<Rule> findByRuleTenantId(String tenantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        return this.mongoTemplate.find(query, Rule.class);
    }

    public void insertRuleList(List<Rule> ruleList) {
        this.mongoTemplate.insert(ruleList);
    }

    public void insertRule(Rule oneRule) {
        this.mongoTemplate.insert((Object)oneRule);
    }

    public void updateRule(Rule oneRule) {
        ObjectId _id = new ObjectId(oneRule.getId());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)_id));
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)Update.update((String)"valid", (Object)false), Rule.class);
    }
}

