/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestAgileDataInAiChat;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoConvertChartResultData;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoFilterData;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service.DigiwinAgileDataEchoProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataConstStringEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="UiBotCompDataBuildAgileDataContentForAiAssistantStrategy")
public class UiBotCompDataBuildAgileDataContentForAiAssistantStrategy
implements UiBotCompDataBuildStrategy<MobileComponent> {
    private static final Logger log = LoggerFactory.getLogger(UiBotCompDataBuildAgileDataContentForAiAssistantStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAdtProxyService digiwinAdtProxyService;
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAgileDataEchoProxyService echoProxyService;

    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.AGILE_DATA_FOR_AI_ASSISTANT.getReuqestId();
    }

    public MobileComponent buildComponentData(ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildAgileDataForAiAssistant");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        MobileComponent mobileComponent = useMockData == false && modelTypeShow == false ? this.doActually(apiRequest, stopWatch) : this.doMockData(apiRequest);
        log.debug(stopWatch.prettyPrint());
        return mobileComponent;
    }

    private MobileComponent doActually(ApiRequest apiRequest, StopWatch stopWatch) {
        MobileComponent mobileComponent;
        AgileDataIntermediateDsl intermediateDsl;
        String locale = apiRequest.getLocale();
        stopWatch.start("GetData From Echo AgileReport API");
        AgileDataApiRequest agileData = AgileDataApiRequest.builder().dataId(apiRequest.getDataId()).iamUserToken(apiRequest.getIamUserToken()).locale(locale).tenantId(apiRequest.getTenantId()).build();
        if (ObjectUtils.isNotEmpty((Object)apiRequest.getFilterParams())) {
            EchoFilterData extFilterData = (EchoFilterData)JsonUtil.jsonStringToObject((String)JsonUtil.javaObjectToJsonString((Object)apiRequest.getFilterParams()), EchoFilterData.class);
            intermediateDsl = (AgileDataIntermediateDsl)JsonUtil.jsonStringToObject((String)JsonUtil.javaObjectToJsonString((Object)extFilterData.getDsl()), AgileDataIntermediateDsl.class);
            intermediateDsl.setDataTipMessage(extFilterData.getDataTipMessage());
        } else if (apiRequest.getIfChartConvertIf().booleanValue()) {
            agileData.setTransId(apiRequest.getTransId());
            EchoConvertChartResultData echoConvertChartResultData = this.echoProxyService.convertChartDataset(agileData);
            intermediateDsl = echoConvertChartResultData.getDsl();
            intermediateDsl.setDataTipMessage(echoConvertChartResultData.getDataTipMessage());
        } else {
            intermediateDsl = this.echoProxyService.getAgileDataDsl(agileData);
        }
        stopWatch.stop();
        if (StringUtils.hasLength((String)intermediateDsl.getErrorMessage())) {
            String emptyText = intermediateDsl.getErrorMessage();
            return Empty.create((String)emptyText, (boolean)true, (Integer)80, (Integer)74, (String)"IMAGE_EMPTY_WIDGET");
        }
        stopWatch.start("Start Generate Agile Data Detail...");
        List agileDataMobileComponents = ModuleUtils.generateComponentFromAgileDataIntermediateDsl((ApiRequest)apiRequest, (AgileDataIntermediateDsl)intermediateDsl, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)agileDataMobileComponents)) {
            String emptyText = this.localeService.getLanguageValue(locale, AgileDataConstStringEnum.AI_ASSISTANT_NO_DATA_REPLY.getValue());
            mobileComponent = Empty.create((String)emptyText, (boolean)true, (Integer)80, (Integer)74, (String)"IMAGE_EMPTY_WIDGET");
        } else {
            mobileComponent = (MobileComponent)agileDataMobileComponents.get(0);
        }
        stopWatch.stop();
        return mobileComponent;
    }

    private MobileComponent doMockData(ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String dslString = FileUtil.readText((String)"./static/agiledata/aiassistant-dsl-response.json");
        DigiwinAthenaApiResponse response = (DigiwinAthenaApiResponse)JsonUtil.jsonStringToObject((String)dslString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        AgileDataIntermediateDsl intermediateDsl = (AgileDataIntermediateDsl)response.getResponse();
        String emptyText = this.localeService.getLanguageValue(locale, "\u6682\u65e0\u6570\u636e");
        Empty emptyMobileComponent = Empty.create((String)emptyText, (boolean)true, (Integer)80, (Integer)74, (String)"IMAGE_EMPTY_WIDGET");
        if (intermediateDsl == null || intermediateDsl.isEmpty()) {
            return emptyMobileComponent;
        }
        List agileDataMobileComponents = ModuleUtils.generateComponentFromAgileDataIntermediateDsl((ApiRequest)apiRequest, (AgileDataIntermediateDsl)intermediateDsl, (boolean)true);
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.getSecond() % 2 == 0 ? (MobileComponent)agileDataMobileComponents.get(0) : (MobileComponent)agileDataMobileComponents.get(1);
    }

    private void saveAbnormalResponseToAdtService(ApiRequest apiRequest, String errorMsg) {
        this.threadPoolTaskExecutor.execute(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            if (apiRequest instanceof ApiRequestAgileDataInAiChat) {
                params.put("generateSerialNo", ((ApiRequestAgileDataInAiChat)apiRequest).getGenerateSerialNo());
                params.put("question", ((ApiRequestAgileDataInAiChat)apiRequest).getQu());
            } else {
                params.put("generateSerialNo", null);
                params.put("question", "");
            }
            params.put("snapshotId", apiRequest.getDataId());
            params.put("errorMsg", errorMsg);
            this.digiwinAdtProxyService.saveAbnormal(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        });
    }
}

