/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.itemdetail;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildDetailItemDetailStrategy")
public class UiBotModelBuildDetailItemDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildDetailItemDetailStrategy.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private TaskDetailBuildStrategyFactory taskDetailBuildStrategyFactory;
    @Autowired
    private HttpService httpService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDetailItemDetail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        stopWatch.start("GetData From Athena API");
        ArrayList<Future> futureList = new ArrayList<Future>();
        Future futureReadCount = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId()));
        futureList.add(futureReadCount);
        Future futureBacklogDetail = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId()));
        futureList.add(futureBacklogDetail);
        String tmTaskId = "";
        String tmActivityId = "";
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            JSONObject executeCtxJsonObj = apiRequest.getRawData().getJSONObject("executeContext");
            tmTaskId = executeCtxJsonObj.getString("tmProjectId");
            tmActivityId = executeCtxJsonObj.getString("tmActivityId");
        }
        String finalTmTaskId = tmTaskId;
        String finalTmActivityId = tmActivityId;
        Future futureUiBotModel = this.threadPoolTaskExecutor.submit(() -> this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId(), finalTmTaskId, finalTmActivityId, apiRequest.getRawData()));
        futureList.add(futureUiBotModel);
        DigiwinAtmcBacklogDetail backlogDetail = null;
        UiBotModel pcUiBotModel = null;
        try {
            block6: for (Future future : futureList) {
                while (true) {
                    if (future.isDone() && !future.isCancelled()) {
                        Object obj = future.get();
                        if (obj instanceof UiBotModel) {
                            pcUiBotModel = (UiBotModel)obj;
                        }
                        if (!(obj instanceof DigiwinAtmcBacklogDetail)) continue block6;
                        backlogDetail = (DigiwinAtmcBacklogDetail)obj;
                        continue block6;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        stopWatch.stop();
        Assert.notNull(backlogDetail, (String)"task detail must have detail!");
        Assert.notNull((Object)backlogDetail.getId(), (String)"task detail must have detail!");
        Assert.notNull(pcUiBotModel, (String)"task detail must have uibotmodel data!");
        stopWatch.start("Build Detail-Item-Detail Page Data");
        TaskDetail taskDetailItemDetail = null;
        taskDetailItemDetail = this.taskDetailBuildStrategyFactory.get(apiRequest.getPageId()).build(apiRequest, pageSetting, pcUiBotModel, new Object[]{backlogDetail});
        stopWatch.stop();
        stopWatch.start("Build Common Page Model");
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetailItemDetail, Boolean.valueOf(true));
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = PageSettingIdPresetEnum.MOBILE_ATHENA_DETAIL_ITEM_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? FileUtil.readText((String)("static/appstore-use/detail-item-detail-" + apiRequest.getDataId() + ".json")) : "";
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

