/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.itemdetail;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.Container;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContent;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContentGroupLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainer;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerBody;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerBuilder;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerHead;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.itemdetail.ItemDetail;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotPageDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelSearchItemDetailStrategy")
public class UiBotModelSearchItemDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelSearchItemDetailStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private HeadBodyContainerBuilder headBodyContainerBuilder;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildSearchItemDetail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = null;
        String tmActivityId = Optional.ofNullable(apiRequest.getRawData()).map(apiRawData -> apiRawData.getString("tmActivityId")).orElse("");
        if (apiRequest.getRawData().get((Object)"params") instanceof List) {
            List paramsList = Optional.ofNullable(apiRequest.getRawData()).map(apiRawData -> (List)apiRawData.getObject("params", List.class)).orElse(Collections.emptyList());
            Map data = new HashMap();
            if (paramsList != null && paramsList.size() > 0) {
                String dataKey = (String)apiRequest.getRawData().get((Object)"dataKey");
                for (Map params : paramsList) {
                    if (!dataKey.equals(params.get("graph_no"))) continue;
                    data = params;
                    break;
                }
            }
            List columnTagList = this.columnTagService.listColumnTagsByPathAndPageId("cad_info", apiRequest.getPageId());
            stopWatch.start("Build Common Page Model");
            uiBotModel = this.buildUibotModel(pageSetting, apiRequest, columnTagList, data);
        } else {
            Map params = Optional.ofNullable(apiRequest.getRawData()).map(apiRawData -> (Map)apiRawData.getObject("params", Map.class)).orElse(Collections.emptyMap());
            HashMap map = new HashMap(1);
            map.put("params", params);
            UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.simpleShow(tmActivityId, map, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
            UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();
            ItemDetail itemDetail = null;
            if (pcDataLayout.isTypeOfTable()) {
                itemDetail = this.processWithPcTable(pageSetting, apiRequest, pcUiBotModel, pcDataLayout);
            }
            stopWatch.start("Build Common Page Model");
            uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, (Object)itemDetail, Boolean.valueOf(true));
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel buildUibotModel(PageSetting pageSetting, ApiRequest apiRequest, List<ColumnTag> columnTagList, Map<String, Object> data) {
        ItemDetail itemDetail = new ItemDetail(this.localeService);
        String locale = apiRequest.getLocale();
        List layouts = pageSetting.getPageModel().getLayout();
        UiBotPageData pageData = pageSetting.getPageModel().getPageData();
        HeadBodyContainer headBodyContainer = new HeadBodyContainer();
        HeadBodyContainerHead headBodyContainerHead = new HeadBodyContainerHead();
        for (UiBotLayout uiBotLayout : layouts) {
            List bodyMaps;
            Map headMap;
            Map map = (Map)pageData.get((Object)uiBotLayout.getSchema());
            if (map.get("head") != null && (headMap = (Map)map.get("head")) != null && headMap.size() > 0) {
                List headLayOut = (List)headMap.get("layout");
                String schema = "";
                if (headLayOut != null && headLayOut.size() > 0) {
                    for (Map lay1 : headLayOut) {
                        if (!"CONTAINER".equals(lay1.get("type"))) continue;
                        schema = (String)lay1.get("schema");
                        break;
                    }
                    if (schema != null && !schema.trim().equals("")) {
                        Map pageDataOut = (Map)headMap.get("pageData");
                        Container container = null;
                        if (pageDataOut != null && pageDataOut.size() > 0) {
                            container = (Container)JsonUtil.objectToJavaObject(pageDataOut.get(schema), Container.class);
                            container.setShowLessText(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)container.getShowLessText()) + "\u2227");
                            container.setShowMoreText(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)container.getShowMoreText()) + "\u2228");
                            container.setContentList(this.buildContentList(data, columnTagList, locale));
                            pageDataOut.put(schema, JsonUtil.objectToJavaObject((Object)container, Map.class));
                        }
                        headBodyContainerHead.setPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)pageDataOut, UiBotPageData.class));
                        UiBotLayout uiBotLayout1 = (UiBotLayout)JsonUtil.objectToJavaObject(headLayOut.get(0), UiBotLayout.class);
                        ArrayList<UiBotLayout> uiBotLayouts = new ArrayList<UiBotLayout>(1);
                        uiBotLayouts.add(uiBotLayout1);
                        headBodyContainerHead.setLayout(uiBotLayouts);
                        headBodyContainer.setHead(headBodyContainerHead);
                    }
                }
            }
            if (map.get("body") != null && (bodyMaps = (List)map.get("body")) != null && bodyMaps.size() > 0) {
                ArrayList<HeadBodyContainerBody> headBodyContainerBodies = new ArrayList<HeadBodyContainerBody>(bodyMaps.size());
                for (Map bodyMap : bodyMaps) {
                    HeadBodyContainerBody headBodyContainerBody;
                    List bodyLayOuts = (List)bodyMap.get("layout");
                    if (bodyLayOuts == null || bodyLayOuts.size() == 0) continue;
                    Map bodyLayout = (Map)bodyLayOuts.get(0);
                    Map bodyPageData = (Map)bodyMap.get("pageData");
                    String schema = (String)bodyLayout.get("schema");
                    ArrayList<Object> uiBotLayouts = new ArrayList<Object>(1);
                    uiBotLayouts.add(JsonUtil.objectToJavaObject((Object)bodyLayout, UiBotLayout.class));
                    if ("WEBVIEW".equals(bodyLayout.get("type"))) {
                        headBodyContainerBody = new HeadBodyContainerBody();
                        headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)((String)bodyMap.get("title"))));
                        Webview webview = (Webview)Optional.ofNullable(JsonUtil.objectToJavaObject(bodyPageData.get(schema), Webview.class)).orElse(new Webview());
                        String resultUrl = "";
                        String prefixUrl = AppContext.getApiUrlSetting().getMuiUrl() + "/graph-viewer?online_drawing_format=2&cad_url=";
                        if ("url2D".equals(schema)) {
                            resultUrl = (String)data.get("cad_url_2d");
                        } else if ("url3D".equals(schema)) {
                            resultUrl = (String)data.get("cad_url_3d");
                        }
                        if (StringUtils.hasLength((String)resultUrl) && !resultUrl.toLowerCase().contains("null")) {
                            webview.initSetting(locale);
                            webview.setUrl(prefixUrl + resultUrl);
                            headBodyContainerBody.setLayout(uiBotLayouts);
                            bodyPageData.put(schema, JsonUtil.objectToJavaObject((Object)webview, Map.class));
                            headBodyContainerBody.setPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)bodyPageData, UiBotPageData.class));
                        } else {
                            headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "\u6682\u65e0\u6570\u636e");
                        }
                        headBodyContainerBodies.add(headBodyContainerBody);
                        continue;
                    }
                    if (!"SMART_PRECISE_SEARCH_ITEM_LIST".equals(bodyLayout.get("type"))) continue;
                    headBodyContainerBody = new HeadBodyContainerBody();
                    headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)((String)bodyMap.get("title"))));
                    headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "\u6682\u65e0\u6570\u636e");
                    headBodyContainerBodies.add(headBodyContainerBody);
                }
                headBodyContainer.setBody(headBodyContainerBodies);
            }
            itemDetail.put((Object)uiBotLayout.getSchema(), (Object)headBodyContainer);
        }
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)itemDetail, Boolean.valueOf(true));
    }

    private List<ContainerContent> buildContentList(Map<String, Object> data, List<ColumnTag> columnTagList, String locale) {
        ArrayList<ContainerContent> containerContents = new ArrayList<ContainerContent>();
        HashMap<Integer, ArrayList<ColumnTag>> groupNos = new HashMap<Integer, ArrayList<ColumnTag>>();
        List groupTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase("cad_info") && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode())).sorted(Comparator.comparingInt(ColumnTag::getGroupNo)).collect(Collectors.toList());
        for (ColumnTag columnTag : columnTagList) {
            ArrayList<ColumnTag> columnTags = (ArrayList<ColumnTag>)groupNos.get(columnTag.getGroupNo());
            if (columnTags != null && columnTags.size() > 0) {
                columnTags.add(columnTag);
                continue;
            }
            columnTags = new ArrayList<ColumnTag>();
            columnTags.add(columnTag);
            groupNos.put(columnTag.getGroupNo(), columnTags);
        }
        for (Integer groupNo : groupNos.keySet()) {
            List uiBotModels;
            ContainerContent containerContent = new ContainerContent();
            List sameGroupNoColumnTags = (List)groupNos.get(groupNo);
            if (sameGroupNoColumnTags.size() == 1) {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.EXCLUSIVE_ONE_LINE.getValue());
            } else {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.SHARE_ONE_LINE_AND_OVERFLOW_WITH_NEW_LINE.getValue());
            }
            if ((uiBotModels = this.buildGroupList(data, sameGroupNoColumnTags, locale)) == null || uiBotModels.size() < 1) continue;
            containerContent.setGroupList(uiBotModels);
            containerContents.add(containerContent);
        }
        return containerContents;
    }

    private List<UiBotModel> buildGroupList(Map<String, Object> data, List<ColumnTag> sameGroupNoColumnTags, String locale) {
        ArrayList<UiBotModel> uiBotModels = new ArrayList<UiBotModel>(sameGroupNoColumnTags.size());
        for (ColumnTag columnTag : sameGroupNoColumnTags) {
            ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
            UiBotLayout layout = new UiBotLayout();
            UiBotModel uiBotModel = new UiBotModel(layoutList);
            String param = (String)data.get(columnTag.getSchema());
            if (param == null) continue;
            Field field = Field.create((String)((String)columnTag.getmLabelText().get(locale)), (String)"1", (String)param, (String)columnTag.getSchema(), (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_CENTER.getValue());
            uiBotModel.addPageData(columnTag.getSchema(), (Object)field);
            layout.setSchema(columnTag.getSchema());
            layout.setType("FIELD");
            layoutList.add(layout);
            uiBotModels.add(uiBotModel);
        }
        return uiBotModels;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/appstore-use/smartsearch-itemdetail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }

    private ItemDetail processWithPcTable(PageSetting pageSetting, ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotLayout pcDataLayout) {
        String mobileRequestRawDataDataKey = Optional.ofNullable(apiRequest.getRawData()).map(apiRawData -> apiRawData.getString("dataKey")).orElse("");
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        List columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        ItemDetail itemDetail = new ItemDetail(this.localeService);
        for (UiBotLayout pageSettingLayout : pageSetting.getPageModel().getLayout()) {
            if (!"HEAD_BODY_CONTAINER".equals(pageSettingLayout.getType()) || pageSetting.getPageModel().getPageData().get((Object)pageSettingLayout.getSchema()) == null) continue;
            HeadBodyContainer headBodyContainer = new HeadBodyContainer();
            for (Map dataKeyMatchedBizData : bizDataList) {
                String dataKey = PcUiBotPageDataUtil.getBizDataKey((UiBotModel)pcUiBotModel, (String)schema, (Map)dataKeyMatchedBizData);
                if (!dataKey.equals(mobileRequestRawDataDataKey)) continue;
                headBodyContainer = this.headBodyContainerBuilder.build(apiRequest, pageSetting, pcUiBotModel, HeadBodyContainer.class, new Object[]{dataKeyMatchedBizData, columnTagList, pageSettingLayout});
                break;
            }
            itemDetail.put((Object)pageSettingLayout.getSchema(), (Object)headBodyContainer);
        }
        return itemDetail;
    }
}

