/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildApprovalTaskProgressStrategy")
public class UiBotModelBuildApprovalTaskProgressStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApprovalTaskProgressStrategy.class);
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private TaskService taskService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        List taskProgressList = useMockData == false && modelTypeShow == false ? this.doActually(apiRequest) : this.doMockData();
        UiBotPageData pageData = new UiBotPageData();
        ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
        bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton((String)apiRequest.getLocale()));
        pageSetting.getPageModel().getLayout().forEach(uiBotLayout -> {
            String schema = uiBotLayout.getSchema();
            if (schema.trim().toLowerCase().contains("task")) {
                pageData.put((Object)schema, (Object)taskProgressList);
            } else {
                pageData.put((Object)schema, (Object)bottomButtonList);
            }
        });
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, pageData);
        if (StringUtils.hasLength((String)apiRequest.getDataId())) {
            uiBotModel.setDataId(apiRequest.getDataId());
        }
        return uiBotModel;
    }

    private List<TaskProgress> doActually(ApiRequest apiRequest) {
        return this.taskService.getTaskProgressList(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), (Map)apiRequest.getRawData(), null);
    }

    private List<TaskProgress> doMockData() {
        String data = FileUtil.readText((String)"static/task-progress.json");
        return JSONArray.parseArray((String)data, TaskProgress.class);
    }
}

