/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputGroupSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildManualTaskDetailActionStrategy")
public class UiBotModelBuildManualTaskDetailActionStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildManualTaskDetailActionStrategy.class);
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildManualTaskDetailAction");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        uiBotModel.setCustomGroup();
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        stopWatch.start("GetData From Athena API");
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotModel pcUibotModel = this.digiwinPcUiBotProxyService.simpleShow("uibotManualTask", Collections.emptyMap(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List digiwinAtmcCalendars = this.digiwinAtmcProxyService.queryAllTeamMember(apiRequest.getIamUserToken(), locale);
        List uiBotLayouts = uiBotModel.getLayout();
        if (uiBotLayouts != null && uiBotLayouts.size() > 0) {
            List mobileRuleList = this.ruleService.findByRulePath(((UiBotLayout)pcUibotModel.getLayout().get(0)).getSchema());
            Map data = (Map)pcUibotModel.getPageData().get((Object)((UiBotLayout)pcUibotModel.getLayout().get(0)).getSchema());
            for (UiBotLayout uiBotLayout : uiBotLayouts) {
                switch (uiBotLayout.getType()) {
                    case "FIELD": {
                        Field field = Field.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)((String)data.get(uiBotLayout.getSchema())), (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, (Boolean)false);
                        if (field == null) break;
                        if ("executorUserId".equals(uiBotLayout.getSchema()) && !StringUtils.hasLength((String)field.getValue())) {
                            field.setValue(apiRequest.getUserId());
                            field.setHidden(Boolean.valueOf(true));
                        }
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)field);
                        break;
                    }
                    case "INPUT_SWITCH": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)InputSwitch.create((String)((String)uiBotLayout.getmLabelText().get(locale)), (String)apiRequest.getSelectDate()));
                        break;
                    }
                    case "DIVIDER": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)Divider.create((DividerTypeEnum)DividerTypeEnum.ELEMENT_DIVIDER));
                        break;
                    }
                    case "BUTTON_SINGLE_SELECT": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)ButtonSingleSelect.create((UiBotLayout)uiBotLayout, (Map)data, (String)pageSetting.getPageId(), (String)locale, (Boolean)false));
                        break;
                    }
                    case "INPUT_DATETIME_PICKER": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)InputDateTimePicker.create((UiBotLayout)uiBotLayout, (Map)data, (String)locale, (String)apiRequest.getSelectDate(), (Boolean)false));
                        break;
                    }
                    case "INPUT_MULTI": {
                        InputMultiText inputMultiText = InputMultiText.create((UiBotLayout)uiBotLayout, (List)mobileRuleList, (Map)data, (String)locale, (boolean)false, (Boolean)false);
                        if ("description".equalsIgnoreCase(uiBotLayout.getSchema())) {
                            inputMultiText.setRequired(Boolean.valueOf(false));
                        }
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)inputMultiText);
                        break;
                    }
                    case "INPUT_SINGLE": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)InputSingleText.create((UiBotLayout)uiBotLayout, (String)"", (Map)data, (String)locale, (Boolean)false));
                        break;
                    }
                    case "ATTACHMENT": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)Attachment.create((UiBotLayout)uiBotLayout, (Map)data, (String)locale, null, (Boolean)false));
                        break;
                    }
                    case "WINDOW_MULTI_SELECT": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)InputWindowMultiSelect.create((UiBotLayout)uiBotLayout, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/getTeamMembers"), (String)locale, (Integer)1));
                        break;
                    }
                    case "GROUP_SINGLE_SELECT": {
                        pageData.put((Object)uiBotLayout.getSchema(), (Object)InputGroupSingleSelect.create((UiBotLayout)uiBotLayout, (List)digiwinAtmcCalendars, (String)locale));
                        break;
                    }
                    case "BOTTOM_BUTTON": {
                        List bottomButtons = (List)pageData.get((Object)"bottomButtons");
                        Map submit = (Map)bottomButtons.get(0);
                        BottomButtonDigiwinAthena bottomButtonDigiwinAthena = BottomButtonDigiwinAthena.create((Integer)BottomButtonStyleEnum.STRESS.getValue(), (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4"));
                        Map action = (Map)submit.get("action");
                        Map rawData = (Map)action.get("rawData");
                        rawData.put("actions", ((UiBotLayout)pcUibotModel.getLayout().get(0)).getActions());
                        rawData.put("data", data);
                        Action action1 = new Action();
                        action1.setJumpPageId((String)submit.get("jumpPageId"));
                        if (StringUtils.hasLength((String)apiRequest.getPreviousPageId())) {
                            action1.setType(ActionTypeEnum.BACK_WITH_DEFAULT_DATA.getValue());
                        } else {
                            action1.setType(ActionTypeEnum.CALL_API.getValue());
                        }
                        action1.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4"));
                        action1.setRawData((Object)rawData);
                        action1.setScreenShotSwitch(Boolean.valueOf(false));
                        bottomButtonDigiwinAthena.setAction(action1);
                        bottomButtonDigiwinAthena.setId((String)submit.get("id"));
                        ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButtonDigiwinAthena, (String)"");
                        ArrayList<BottomButtonDigiwinAthena> buttonDigiwinAthenas = new ArrayList<BottomButtonDigiwinAthena>(1);
                        buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                        pageData.put((Object)uiBotLayout.getSchema(), buttonDigiwinAthenas);
                        break;
                    }
                }
            }
        }
        uiBotModel.setFinished(pcUibotModel.getFinished());
        uiBotModel.setFinishedTitle(pcUibotModel.getFinishedTitle());
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = null;
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE.toString().equalsIgnoreCase(pageSetting.getPageId())) {
            data = FileUtil.readText((String)"static/appstore-use/manual-task-create.json");
        }
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        LocalDateTime now = LocalDateTime.now();
        InputDateTime inputDateTime = new InputDateTime(now.getYear() + "", DateTimeUtil.getFullMonth((Integer)now.getMonthValue()), DateTimeUtil.getFullDate((Integer)now.getDayOfMonth()), DateTimeUtil.getFullHour((Integer)now.getHour()), DateTimeUtil.getFullMinute((Integer)now.getMinute()));
        String key = "";
        InputDateTimePicker timePicker = null;
        if (uiBotModel.getPageData().containsKey((Object)"startTime")) {
            key = "startTime";
            Object rawStartTime = uiBotModel.getPageData().get((Object)key);
            timePicker = (InputDateTimePicker)JsonUtil.objectToJavaObject((Object)rawStartTime, InputDateTimePicker.class);
            timePicker.setDatetimeValue(inputDateTime);
            uiBotModel.getPageData().put((Object)key, (Object)timePicker);
        }
        if (uiBotModel.getPageData().containsKey((Object)"endTime")) {
            key = "endTime";
            Object rawEndTime = uiBotModel.getPageData().get((Object)key);
            timePicker = (InputDateTimePicker)JsonUtil.objectToJavaObject((Object)rawEndTime, InputDateTimePicker.class);
            timePicker.setDatetimeValue(inputDateTime);
            uiBotModel.getPageData().put((Object)key, (Object)timePicker);
        }
        return uiBotModel;
    }
}

