/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service.UniversalParsingService;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskDetailV2Strategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.CustomPatternTaskTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.PatternTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.UiBotModelBuildCustomPatternTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.designer.DesignerService;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildMyTaskDetailStrategy")
public class UiBotModelBuildMyTaskDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildMyTaskDetailStrategy.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private TaskDetailBuildStrategyFactory taskDetailBuildStrategyFactory;
    @Autowired
    private UniversalParsingService universalParsingService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DesignerService designerService;
    @Autowired
    private UiBotModelBuildCustomPatternTaskDetailStrategy uiBotModelBuildCustomPatternTaskDetailStrategy;
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private UiBotModelBuildMyTaskDetailV2Strategy uiBotModelBuildMyTaskDetailV2Strategy;
    @Autowired
    private JsRuleService jsRuleService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        apiRequest.getPatternTaskInfo().setPatternType(PatternTypeEnum.STANDARD);
        StopWatch stopWatch = new StopWatch("BuildMyTaskDetail");
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doBefore(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doBefore(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        if (apiRequest.getExtraParameter() == null) {
            ApiExtraParameter apiExtraParameter = new ApiExtraParameter();
            apiExtraParameter.setAppCode(apiRequest.getRawData().getString("appCode"));
            apiExtraParameter.setTmTaskId(apiRequest.getRawData().getString("tmTaskId"));
            apiExtraParameter.setTmActivityId(apiRequest.getRawData().getString("tmActivityId"));
            if (!StringUtils.hasLength((String)apiExtraParameter.getTmTaskId()) || !StringUtils.hasLength((String)apiExtraParameter.getTmActivityId())) {
                DigiwinAtmcBacklogDetail backlogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId());
                apiExtraParameter.setAppCode(backlogDetail.getAppCode());
                apiExtraParameter.setTmTaskId(backlogDetail.getTmTaskId());
                apiExtraParameter.setTmActivityId(backlogDetail.getTmActivityId());
            }
            apiRequest.setExtraParameter(apiExtraParameter);
        }
        UiBotDesignerConfig uiBotDesignerConfig = this.designerService.initPatternTaskInfoWithUiBotDesigner(apiRequest, apiRequest.getExtraParameter().getTmTaskId(), apiRequest.getExtraParameter().getTmActivityId(), pageSetting.getSystemDefault(), apiRequest.getExtraParameter().getAppCode());
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$strategy$modelbuild$pattern$CustomPatternTaskTypeEnum[apiRequest.getPatternTaskInfo().getCustomPatternTaskType().ordinal()]) {
            case 1: {
                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_CUSTOM_PATTERN_TASK_DETAIL.name());
                pageSetting = this.pageSettingService.findById(apiRequest.getPageId());
                return this.uiBotModelBuildCustomPatternTaskDetailStrategy.buildJumpH5Page(pageSetting, apiRequest, uiBotDesignerConfig.getRawTaskActivityDefinition());
            }
            case 2: {
                return this.uiBotModelBuildMyTaskDetailV2Strategy.doActually(pageSetting, apiRequest);
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
        return this.doActually(pageSetting, apiRequest, stopWatch);
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String athenaTaskName;
        List<Object> tags;
        TitleBody titleBody;
        String tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
        String tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        stopWatch.start("GetData From Athena API");
        DigiwinAtmcBacklogDetail backlogDetail = null;
        UiBotModel pcUiBotModel = null;
        List reassignReportList = null;
        ArrayList<Future> futureList = new ArrayList<Future>();
        Future futureReadCount = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId()));
        futureList.add(futureReadCount);
        Future futureBacklogDetail = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId()));
        futureList.add(futureBacklogDetail);
        Future futureReassignReport = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.getTaskReassignReport(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId()));
        futureList.add(futureReassignReport);
        try {
            block14: for (Future future : futureList) {
                while (true) {
                    if (future.isDone() && !future.isCancelled()) {
                        Object obj = future.get();
                        if (obj instanceof DigiwinAtmcBacklogDetail && (backlogDetail = (DigiwinAtmcBacklogDetail)obj) != null && !StringUtils.hasLength((String)tmActivityId) && !StringUtils.hasLength((String)tmTaskId)) {
                            tmActivityId = backlogDetail.getTmActivityId();
                            tmTaskId = backlogDetail.getTmTaskId();
                        }
                        if (!(obj instanceof List)) continue block14;
                        reassignReportList = (List)obj;
                        continue block14;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        stopWatch.stop();
        pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId(), tmTaskId, tmActivityId, apiRequest.getRawData());
        Assert.notNull((Object)backlogDetail, (String)"task detail must have detail!");
        Assert.notNull((Object)backlogDetail.getId(), (String)"task detail must have detail!");
        Assert.notNull((Object)pcUiBotModel, (String)"task detail must have uibotmodel data!");
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue() && !TaskStringUtil.isBizApproval((String)StringUtil.valueOf((Object)backlogDetail.getTmPattern()), (String)StringUtil.valueOf((Object)backlogDetail.getTmCategory())) && !TaskStringUtil.isBizDataEntryDriven((String)StringUtil.valueOf((Object)backlogDetail.getTmPattern()), (String)StringUtil.valueOf((Object)backlogDetail.getTmCategory())) && !TaskStringUtil.isBizSmartAdjust((String)backlogDetail.getTmActivityId())) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        this.designerService.integrateTaskDetailWithUiBotDesigner(apiRequest, pcUiBotModel);
        List digiwinAtmcTaskProgressList = Collections.emptyList();
        if (StringUtils.hasLength((String)backlogDetail.getApprovalState())) {
            Map taskSignoffProgressData = TaskDataExtractUtil.getSignoffProgressData((UiBotPageData)pcUiBotModel.getPageData());
            digiwinAtmcTaskProgressList = this.digiwinAtmcProxyService.getApprovalTaskSignoffProgress(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), taskSignoffProgressData);
        }
        stopWatch.start("Build Task-Detail Page Data");
        TaskDetailBuildStrategy taskDetailBuildStrategy = this.taskDetailBuildStrategyFactory.get(TaskStringUtil.getTaskBuildTypeByDetailPatternCategory((DigiwinAtmcBacklogDetail)backlogDetail));
        if (taskDetailBuildStrategy == null || PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.toString().equals(pageSetting.getPageId()) && !TaskStringUtil.isBizSmartAdjust((String)backlogDetail.getTmActivityId())) {
            UiBotModel taskModel = this.universalParsingService.buildPatternModel(apiRequest, pageSetting, pcUiBotModel, backlogDetail, digiwinAtmcTaskProgressList, reassignReportList);
            stopWatch.stop();
            if (CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE == apiRequest.getPatternTaskInfo().getCustomPatternTaskType()) {
                taskModel.buildShowTitleAndEmpty(this.localeService, apiRequest.getLocale());
            }
            if (taskModel.hasAppliedDesignerConfig()) {
                int bodyContainerType;
                switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$component$MobileLayoutTypeEnum[taskModel.getLayoutGeneratorServiceResult().getLayoutTypeEnum().ordinal()]) {
                    case 1: {
                        bodyContainerType = 1;
                        break;
                    }
                    case 2: {
                        bodyContainerType = 2;
                        break;
                    }
                    default: {
                        bodyContainerType = 0;
                    }
                }
                taskModel = MobileRenderDataUtil.upgradeToV2RenderData((UiBotModel)taskModel, (int)bodyContainerType);
            }
            ModuleUtils.addRefreshPageId((UiBotModel)taskModel, null);
            List jsRuleList = this.jsRuleService.findByTmActivityId(tmActivityId);
            if (!CollectionUtils.isEmpty((Collection)jsRuleList)) {
                ArrayList uiBotRuleList = new ArrayList(2);
                jsRuleList.forEach(jsRule -> {
                    UiBotRule uiBotRule = new UiBotRule();
                    BeanUtils.copyProperties((Object)jsRule, (Object)uiBotRule);
                    uiBotRuleList.add(uiBotRule);
                });
                taskModel.setRules(uiBotRuleList);
            }
            return taskModel;
        }
        UiBotModel uiBotModel = taskDetailBuildStrategy.buildUibotModel(apiRequest, pageSetting, pcUiBotModel, new Object[]{backlogDetail, digiwinAtmcTaskProgressList});
        stopWatch.stop();
        if (CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE == apiRequest.getPatternTaskInfo().getCustomPatternTaskType()) {
            uiBotModel.buildShowTitleAndEmpty(this.localeService, apiRequest.getLocale());
        }
        stopWatch.start("Build Common Page Model");
        if (!PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_LIST.toString().equals(pageSetting.getPageId()) && backlogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            Iterator backlogId = String.valueOf(backlogDetail.getId());
            if (!buttons.stream().filter(button -> button.getId().equalsIgnoreCase((String)((Object)backlogId))).findFirst().isPresent()) {
                HashMap<String, String> buttonActionRawData = new HashMap<String, String>(backlogDetail.getReassign());
                buttonActionRawData.put("appCode", backlogDetail.getAppCode());
                buttonActionRawData.put("backlogDetail", (String)backlogDetail);
                buttons.add(Button.createApprovalReassign((String)(backlogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
            }
        }
        List layouts = uiBotModel.getLayout();
        if (reassignReportList != null && reassignReportList.size() > 0) {
            for (UiBotLayout layout : layouts) {
                if ("TITLE_BODY".equals(layout.getType())) {
                    titleBody = (TitleBody)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleBody.class);
                    tags = titleBody.getTags();
                    if (tags == null) {
                        tags = new ArrayList<Tag>();
                    } else {
                        for (Tag tag : tags) {
                            if (!LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e").equals(tag.getText())) continue;
                            tags.remove(tag);
                            break;
                        }
                    }
                    Tag tag = Tag.createOnlyTextStateTag((String)String.format(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7531\u8f6c\u6d3e"), ((DigiwinReassignReport)reassignReportList.get(0)).getOldPerformerName()), (Action)Action.createReassignReportAction((String)apiRequest.getLocale(), (List)reassignReportList));
                    tags.add(tag);
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleBody);
                    break;
                }
                if ("PAGE_DESC".equals(layout.getType())) {
                    PageDesc pageDesc = (PageDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), PageDesc.class);
                    List pageDescContents = pageDesc.getContent();
                    pageDescContents.add(PageDescContent.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)pageDesc);
                }
                if (!"TITLE_DESC".equals(layout.getType())) continue;
                TitleDesc titleDesc = (TitleDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleDesc.class);
                List labels = titleDesc.getLabelList();
                labels.add(Label.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleDesc);
            }
        } else {
            for (UiBotLayout layout : layouts) {
                if (!"TITLE_BODY".equals(layout.getType())) continue;
                titleBody = (TitleBody)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleBody.class);
                tags = titleBody.getTags();
                if (tags != null) {
                    for (Tag tag : tags) {
                        if (!LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e").equals(tag.getText())) continue;
                        tags.remove(tag);
                        tags.add(Tag.createBlueBgdWriteTextStateTag((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e")));
                        break;
                    }
                }
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleBody);
                break;
            }
        }
        if (uiBotModel.hasAppliedDesignerConfig()) {
            int bodyContainerType;
            switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$component$MobileLayoutTypeEnum[uiBotModel.getLayoutGeneratorServiceResult().getLayoutTypeEnum().ordinal()]) {
                case 1: {
                    bodyContainerType = 1;
                    break;
                }
                case 2: {
                    bodyContainerType = 2;
                    break;
                }
                default: {
                    bodyContainerType = 0;
                }
            }
            uiBotModel = MobileRenderDataUtil.upgradeToV2RenderData((UiBotModel)uiBotModel, (int)bodyContainerType);
        }
        if (null != backlogDetail.getBpmActivityId()) {
            uiBotModel.setDataId(backlogDetail.getBpmActivityId());
        }
        if (!StringUtils.hasLength((String)(athenaTaskName = Optional.ofNullable(backlogDetail).map(DigiwinAtmcBacklogDetail::getName).orElse("")))) {
            athenaTaskName = String.valueOf(pcUiBotModel.getPageData().getUiBotActivity().get("name"));
        }
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getLeft() != null) {
            SlipTitle slipTitle = uiBotModel.getSlip().getSlipConfig().getLeft().getSubTitle();
            slipTitle.setContent(athenaTaskName + " " + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5f53\u524d\u6c9f\u901a"));
            SlipConfigLeft left = uiBotModel.getSlip().getSlipConfig().getLeft();
            List projectPerformers = this.digiwinAtmcProxyService.getPerformerListByBackLogId(backlogDetail.getBacklogId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
            EocPersonResponse eocPersonResponse = this.digiwinEocProxyService.getSimplePersonList(apiRequest.getIamUserToken(), 9999, 1, "");
            SlipConfigLeft.setPersonList((SlipConfigLeft)left, (List)projectPerformers, (EocPersonResponse)eocPersonResponse);
        }
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getRight() != null) {
            LeftHeader header = uiBotModel.getSlip().getSlipConfig().getRight().getHeader();
            header.getSubTitle().setContent(athenaTaskName);
            if (uiBotModel.getSlip().getSlipConfig().getRight().getBody() != null) {
                String mobileTransactionId;
                Map bpmData;
                List pageData = new ArrayList();
                if (pcUiBotModel.getPageData().get((Object)pcUiBotModel.searchBizDataSchema()) instanceof List) {
                    pageData = (List)pcUiBotModel.getPageData().get((Object)pcUiBotModel.searchBizDataSchema());
                } else if (pcUiBotModel.getPageData().get((Object)pcUiBotModel.searchBizDataSchema()) instanceof Map) {
                    Map params = (Map)pcUiBotModel.getPageData().get((Object)pcUiBotModel.searchBizDataSchema());
                    pageData = (List)params.get("purchase_temp_detail");
                }
                ArrayList cardInfoList = new ArrayList();
                if (pageData != null) {
                    for (Map param : pageData) {
                        List graphInfoParamList = (List)param.get("graph_info");
                        if (graphInfoParamList == null || graphInfoParamList.size() <= 0) continue;
                        ArrayList graphInfoList = new ArrayList(graphInfoParamList.size());
                        for (Map objectMap : graphInfoParamList) {
                            HashMap graphInfo = new HashMap(2);
                            graphInfo.put("graph_no", objectMap.get("graph_no"));
                            graphInfo.put("graph_no_version", objectMap.get("graph_no_version"));
                            graphInfoList.add(graphInfo);
                        }
                        cardInfoList.addAll(graphInfoList);
                    }
                }
                Map params = uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().getParams();
                params.put("tenant_id", backlogDetail.getTenantId());
                params.put("user_id", apiRequest.getUserId());
                params.put("transaction_id", backlogDetail.getId());
                params.put("transaction_code", backlogDetail.getTmActivityId());
                params.put("card_info", cardInfoList);
                Object bpmDataObj = pcUiBotModel.getExecuteContext().get((Object)"bpmData");
                if (bpmDataObj != null && (bpmData = (Map)bpmDataObj).get("__mobile_transaction_id") != null && "PURCHASE_ORDER.I01".equalsIgnoreCase(mobileTransactionId = bpmData.get("__mobile_transaction_id").toString())) {
                    List mapList;
                    params.put("dataId", "PURCHASE_ORDER.I01");
                    uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().setDataId("PURCHASE_ORDER.I01");
                    ArrayList<String> topParentLayoutTypeList = new ArrayList<String>();
                    topParentLayoutTypeList.add("SPLIT_LAYOUT");
                    topParentLayoutTypeList.add("FORM_LIST");
                    ArrayList<String> targetLayoutTypeList = new ArrayList<String>();
                    targetLayoutTypeList.add("FORM_UPLOAD");
                    UiBotModel topUiBotModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, topParentLayoutTypeList, true);
                    if (!CollectionUtils.isEmpty((Collection)topUiBotModel.getLayout())) {
                        UiBotLayout layout = (UiBotLayout)topUiBotModel.getLayout().get(0);
                        Map attachmentMap = (Map)topUiBotModel.getPageData().get((Object)layout.getSchema());
                        params.put("attachment", attachmentMap.get("data"));
                        params.put("attribute", layout.getAttribute());
                    }
                    ArrayList<String> formParentLayoutTypeList = new ArrayList<String>();
                    formParentLayoutTypeList.add("SPLIT_LAYOUT");
                    formParentLayoutTypeList.add("FORM_LIST");
                    formParentLayoutTypeList.add("FORMGROUP");
                    ArrayList<String> layoutTypeList = new ArrayList<String>();
                    layoutTypeList.add("TABLE");
                    UiBotModel formUiBotModel = pcUiBotModel.searchPcTargetModel(layoutTypeList, formParentLayoutTypeList, false);
                    if (!CollectionUtils.isEmpty((Collection)formUiBotModel.getLayout()) && !CollectionUtils.isEmpty((Collection)(mapList = (List)formUiBotModel.getPageData().get((Object)((UiBotLayout)formUiBotModel.getLayout().get(0)).getSchema())))) {
                        ArrayList<String> itemCodeList = new ArrayList<String>();
                        for (Map map : mapList) {
                            String priceType;
                            if (map.get("__PRICE") == null || !"1".equals(priceType = map.get("__PRICE").toString())) continue;
                            itemCodeList.add((String)map.get("ITEM_CODE"));
                        }
                        params.put("item_code_list", itemCodeList);
                    }
                }
            }
        }
        stopWatch.stop();
        if (PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) || PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL_QIANYE_UC.toString().equalsIgnoreCase(pageSetting.getPageId())) {
            uiBotModel.setCustomGroup();
        }
        if (Objects.equals("manual_DTD_Assignment", tmActivityId)) {
            uiBotModel.setShowMore(Boolean.valueOf(false));
            uiBotModel.setPageBackgroudColor("F6F7FB");
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = PageSettingIdPresetEnum.MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? FileUtil.readText((String)("static/appstore-use/approval-task-detail-v2-" + apiRequest.getDataId() + ".json")) : (PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? (TaskStringUtil.isSscEmployeeInduction((String)apiRequest.getExtraParameter().getTmTaskId(), (String)apiRequest.getExtraParameter().getTmActivityId()) ? FileUtil.readText((String)"static/appstore-use/taskInductionFirstDay-employeeInduction-task-detail-123456789012345.json") : FileUtil.readText((String)("static/appstore-use/report-task-detail-" + apiRequest.getDataId() + ".json"))) : (PageSettingIdPresetEnum.MOBILE_MY_BIZ_PROCESS_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? FileUtil.readText((String)"static/appstore-use/process-task-detail.json") : (PageSettingIdPresetEnum.MOBILE_ATHENA_SSC_EMPLOYEE_ATTEN_CONFIRM_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? FileUtil.readText((String)("static/appstore-use/attendanceConfirmation-employeeAttendanceConfirmation-task-detail-" + apiRequest.getDataId() + ".json")) : (PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_BARCODEMAN_PRINT_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? "" : (PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_BARCODEMAN_PASTE_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? "" : (PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_BARCODEMAN_CHECKOUT_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId()) ? "" : ""))))));
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

