/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListBaseOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListCommonFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListCommonFilterDefaultOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilterSwitch;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListGroupFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListGroupOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSeniorFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSeniorFilterDefaultOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSort;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSortItem;
import com.digiwin.mobile.mobileuibot.core.component.list.card.DataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.FilterTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.OrderOptionEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.ReadStateOrderOptionEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.SourceTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.SpliceTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.SystemFilterEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.PersonalConfiguration;
import com.digiwin.mobile.mobileuibot.model.UserTaskFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.PersonalConfigurationService;
import com.digiwin.mobile.mobileuibot.mysql.service.UserTaskFilterService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCalendar;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCardConfigItemSetInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcFilterSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcOrderSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildMyTaskListStrategy")
public class UiBotModelBuildMyTaskListStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildMyTaskListStrategy.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private TaskFilterService taskFilterService;
    @Autowired
    private CustomTaskConfigService customTaskConfigService;
    @Autowired
    private PersonalConfigurationService personalConfigurationService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private UserTaskFilterService userTaskFilterService;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ActivityFilterService activityFilterService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel;
        List uiBotLayouts;
        TodoList todoList = new TodoList();
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData.booleanValue() && !AppRequestContext.requestNeedShowMockData()) {
            todoList = this.doActually(apiRequest);
        }
        if (!CollectionUtils.isEmpty((Collection)(uiBotLayouts = (uiBotModel = pageSetting.getPageModel()).getLayout()))) {
            Button addTask;
            UiBotLayout uiBotLayout = (UiBotLayout)uiBotLayouts.get(0);
            UiBotPageData uiBotPageData = uiBotModel.getPageData();
            TodoList newTodoList = (TodoList)JsonUtil.objectToJavaObject((Object)uiBotPageData.get((Object)uiBotLayout.getSchema()), TodoList.class);
            newTodoList.putAll(todoList);
            try {
                HashMap<String, String> params = new HashMap<String, String>(2);
                params.put("userId", apiRequest.getUserId());
                params.put("tenantId", apiRequest.getTenantId());
                PersonalConfiguration personalConfiguration = this.personalConfigurationService.getByMap(params);
                if (personalConfiguration == null) {
                    personalConfiguration = new PersonalConfiguration();
                    personalConfiguration.setShowCompleted(Boolean.valueOf(true));
                    personalConfiguration.setShowFactory(Boolean.valueOf(false));
                    personalConfiguration.setUserId(apiRequest.getUserId());
                }
                newTodoList.setPersonalConfiguration(personalConfiguration);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!CollectionUtils.isEmpty((Collection)newTodoList.getTodoList())) {
                newTodoList.getTodoList().forEach(taskSummary -> {
                    if (taskSummary.getAction() != null) {
                        taskSummary.getAction().setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
                    }
                });
            }
            if (null != (addTask = newTodoList.getAddTask()) && null != addTask.getAction()) {
                Action action = addTask.getAction();
                action.setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)action.getJumpPageTitle()));
            }
            newTodoList.setCalenderType(apiRequest.getCalenderType());
            uiBotPageData.put((Object)uiBotLayout.getSchema(), (Object)newTodoList);
        }
        return uiBotModel;
    }

    /*
     * WARNING - void declaration
     */
    public TodoList doActually(ApiRequest apiRequest) {
        CountDownLatch countDownLatch;
        TodoList todoList = new TodoList();
        boolean needRequestMyCalendar = apiRequest.getCalenderType() != 1 && (apiRequest.getRequestId() == null || !apiRequest.getRequestId().equals(ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId()));
        List<Object> myBacklogs = new ArrayList<DigiwinAtmcBacklog>();
        List digiwinAtmcCalendars = Collections.emptyList();
        List teamMemberWorkitems = Collections.emptyList();
        ArrayList<Object> futureList = new ArrayList<Object>();
        if (needRequestMyCalendar) {
            countDownLatch = new CountDownLatch(2);
            digiwinAtmcCalendars = this.digiwinAtmcProxyService.queryAllTeamMember(apiRequest.getIamUserToken(), apiRequest.getLocale());
            DigiwinAtmcCalendar myDigiwinAtmcCalendar = digiwinAtmcCalendars.stream().filter(digiwinAtmcCalendar -> digiwinAtmcCalendar.getType() == 0).findFirst().orElse(new DigiwinAtmcCalendar());
            todoList.setTeamMember(myDigiwinAtmcCalendar);
            Future futureTeamMemberWorkitems = this.threadPoolTaskExecutor.submit(() -> {
                try {
                    HashMap<String, List> resultMap = new HashMap<String, List>(1);
                    resultMap.put("teamMemberWorkitems", this.digiwinAtmcProxyService.getTeamMemberWorkItemList(apiRequest.getClientId(), apiRequest.getIamUserToken(), String.valueOf(myDigiwinAtmcCalendar.getId()), apiRequest.getLocale(), apiRequest.getStartDate(), apiRequest.getEndDate()));
                    logger.debug("CountDown for \u67e5\u8be2\u6211\u56e2\u961f\u6210\u5458\u884c\u4e8b\u5386\u4efb\u52a1\u5217\u8868");
                    HashMap<String, List> hashMap = resultMap;
                    return hashMap;
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            futureList.add(futureTeamMemberWorkitems);
        } else {
            countDownLatch = new CountDownLatch(1);
        }
        Future futureDigiwinAtmcBacklogs = this.threadPoolTaskExecutor.submit(() -> {
            try {
                HashMap<String, List> resultMap = new HashMap<String, List>(1);
                resultMap.put("myBacklogs", this.digiwinAtmcProxyService.listMyBacklog(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()));
                logger.debug("CountDown for \u67e5\u8be2\u6211\u7684\u4efb\u52a1\u5217\u8868");
                HashMap<String, List> hashMap = resultMap;
                return hashMap;
            }
            finally {
                countDownLatch.countDown();
            }
        });
        futureList.add(futureDigiwinAtmcBacklogs);
        try {
            countDownLatch.await();
            Thread.sleep(1L);
            for (Future future : futureList) {
                Map result;
                Object obj;
                if (!future.isDone() || future.isCancelled() || !((obj = future.get()) instanceof Map) || null == (result = (Map)obj) || result.size() != 1) continue;
                if (result.containsKey("teamMemberWorkitems")) {
                    teamMemberWorkitems = (List)result.get("teamMemberWorkitems");
                    continue;
                }
                myBacklogs = (List)result.get("myBacklogs");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            void var11_15;
            e.printStackTrace();
            String string = e.getMessage();
            if (null != e.getCause()) {
                String string2 = e.getCause().getMessage();
            }
            throw new ServiceException((String)var11_15);
        }
        if (needRequestMyCalendar) {
            for (DigiwinAtmcBacklog digiwinAtmcBacklog2 : teamMemberWorkitems) {
                if (digiwinAtmcBacklog2.getExtendData() == null || !digiwinAtmcBacklog2.getExtendData().getFinished().booleanValue()) continue;
                if (!StringUtils.hasLength((String)digiwinAtmcBacklog2.getTmActivityName())) {
                    digiwinAtmcBacklog2.setTmActivityName(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u884c\u4e8b\u5386"));
                }
                myBacklogs.add(digiwinAtmcBacklog2);
            }
        }
        if (StringUtil.isNotEmpty((CharSequence)apiRequest.getSourceType()) && SsoSourceTypeEnum.ENTERPRISE_WECHAT.getSource().equalsIgnoreCase(apiRequest.getSourceType())) {
            myBacklogs = myBacklogs.stream().filter(digiwinAtmcBacklog -> TaskStringUtil.isBizApproval((String)digiwinAtmcBacklog.getTmPattern(), (String)digiwinAtmcBacklog.getTmCategory())).collect(Collectors.toList());
        }
        myBacklogs.removeIf(digiwinAtmcBacklog -> "budgetProjectApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) || "projectMaterialApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) || "projectBudgetConfirmationApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) || "projectCostApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) || "projectBudgetConfirmation".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) || "ApproveForProjectSet".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()));
        return this.paddingMobileTaskListForm(apiRequest, myBacklogs, todoList);
    }

    public TodoList paddingMobileTaskListForm(ApiRequest apiRequest, List<DigiwinAtmcBacklog> myBacklogs, TodoList todoList) {
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List filterList = this.activityFilterService.listValidInAthenaOfTaskFilter(apiRequest.getTenantId(), tenantVersion);
        myBacklogs = myBacklogs.stream().filter(backlog -> this.taskFilterService.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList)).collect(Collectors.toList());
        UserTaskFilter selectFilter = new UserTaskFilter(apiRequest.getUserId(), apiRequest.getTenantId());
        UserTaskFilter taskFilter = this.userTaskFilterService.getUserTaskFilterByParams(selectFilter);
        Set taskIds = new HashSet();
        if (taskFilter != null && StringUtils.hasLength((String)taskFilter.getQueryParam())) {
            taskIds = this.digiwinAtmcProxyService.taskSearch(taskFilter.getQueryParam(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), apiRequest.getClientId());
        }
        List filterIds = new ArrayList(16);
        if (taskFilter != null && StringUtils.hasLength((String)taskFilter.getFilterIds())) {
            filterIds = CollectionUtils.arrayToList((Object)taskFilter.getFilterIds().split(";"));
        }
        List pageTaskRelationList = this.activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);
        List customTaskConfigList = this.customTaskConfigService.listCustomTaskConfig();
        HashMap<String, String> taskTypeMap = new HashMap<String, String>(16);
        HashMap taskTypeData = new HashMap(16);
        HashMap taskFlowData = new HashMap(16);
        HashMap taskReadStatusData = new HashMap(16);
        HashMap taskStatusData = new HashMap(16);
        HashMap customFilter = new HashMap();
        HashMap customSelectOptionMap = new HashMap();
        HashSet orderCodeSetFromBacklogs = new HashSet();
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>(myBacklogs.size());
        for (DigiwinAtmcBacklog digiwinAtmcBacklog : myBacklogs) {
            taskTypeMap.put(digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmActivityName());
            Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId())).findFirst();
            Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory())).findFirst();
            String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ? optPageTaskRelationTaskIdAndActivityId.get().getPageId() : (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
            String url = "";
            taskSummaries.add(TaskSummary.create((String)apiRequest.getLocale(), (String)apiRequest.getIamUserToken(), (DigiwinAtmcBacklog)digiwinAtmcBacklog, (String)jumpPageId, (List)customTaskConfigList, (boolean)true, (String)apiRequest.getUserId(), (boolean)false, (String)url, taskTypeData, taskFlowData, taskReadStatusData, taskStatusData, customFilter, customSelectOptionMap, orderCodeSetFromBacklogs, (LocaleService)this.localeService));
        }
        todoList.setTodoList(TaskSummary.sortTeamList(taskSummaries));
        todoList.setSearchUrl("/mobile/v1/task/search");
        todoList.setSearchIdList(new ArrayList(taskIds));
        todoList.setQueryParam(taskFilter == null ? "" : taskFilter.getQueryParam());
        todoList.setFilterIdList(filterIds);
        todoList.setFilterList(this.buildFilterList(taskTypeMap, apiRequest.getLocale(), taskTypeData, taskFlowData, taskReadStatusData, taskStatusData, filterIds));
        List filterTaskSettingList = this.digiwinAtmcProxyService.getFilterTaskSetting(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        this.buildCommonFilter(apiRequest, todoList, taskFilter, taskTypeMap, customFilter, filterTaskSettingList, customSelectOptionMap);
        this.buildSeniorFilter(apiRequest, todoList, taskFilter, taskTypeMap, customFilter, filterTaskSettingList, customSelectOptionMap);
        todoList.setIsUseSeniorFilter(Boolean.valueOf(Objects.isNull(taskFilter) || Objects.isNull(taskFilter.getIsUseSeniorFilter()) ? false : taskFilter.getIsUseSeniorFilter()));
        this.buildGroupFilterInfo(apiRequest, todoList, taskFilter, true);
        this.buildSortFilterList(apiRequest, todoList, taskFilter, orderCodeSetFromBacklogs, true);
        this.buildFilterSwitch(apiRequest, todoList);
        return todoList;
    }

    private void buildCommonFilter(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter, Map<String, String> taskTypeMap, Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter, List<DigiwinAtmcFilterSetting> filterTaskSettingList, Map<String, Set<String>> customSelectOptionMap) {
        String locale = apiRequest.getLocale();
        ArrayList defaultOptionList = new ArrayList(5);
        Arrays.stream(SystemFilterEnum.values()).forEach(item -> {
            Map options = "type".equalsIgnoreCase(item.getType()) ? taskTypeMap : item.getOptions(locale);
            defaultOptionList.add(this.buildCardListCommonFilterDefaultOption(item.getType(), this.localeService.getLanguageValue(locale, item.getName()), item.getDataType(), SourceTypeEnum.SYSTEM.getType(), options));
        });
        List customFilterTaskSettingCodeList = filterTaskSettingList.stream().filter(item -> "customer".equalsIgnoreCase(item.getSourceType()) && BooleanUtils.isTrue((Boolean)item.getNormal())).map(item -> item.getCode()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customFilterTaskSettingCodeList)) {
            customFilter.entrySet().forEach(item -> {
                if (customFilterTaskSettingCodeList.contains(item.getKey())) {
                    DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter cardConfigFilter = (DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter)item.getValue();
                    Map<Object, Object> valueOptionMap = Collections.emptyMap();
                    if (DataTypeEnum.SELECT.getName().equalsIgnoreCase(cardConfigFilter.getDataType())) {
                        Set customSelectOptionList = (Set)MapUtil.getOrDefault((Map)customSelectOptionMap, (String)((String)item.getKey()), Collections.emptySet());
                        valueOptionMap = customSelectOptionList.stream().collect(Collectors.toMap(e -> e, e -> e));
                    }
                    defaultOptionList.add(this.buildCardListCommonFilterDefaultOption((String)item.getKey(), cardConfigFilter.getAliasName(), cardConfigFilter.getDataType(), SourceTypeEnum.CUSTOM.getType(), valueOptionMap));
                }
            });
        }
        CardListCommonFilter cardListCommonFilter = new CardListCommonFilter();
        cardListCommonFilter.setDefaultOptionList(defaultOptionList);
        if (Objects.nonNull(taskFilter) && StringUtils.hasLength((String)taskFilter.getCommonFilter())) {
            List cardListCommonFilterSelectedOptionList = (List)JsonUtil.jsonStringToObject((String)taskFilter.getCommonFilter(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            cardListCommonFilter.setSelectedOptionList(cardListCommonFilterSelectedOptionList);
        }
        todoList.setCommonFilter(cardListCommonFilter);
    }

    private CardListCommonFilterDefaultOption buildCardListCommonFilterDefaultOption(String filterOptionId, String filterOptionName, String dataType, String sourceType, Map<String, String> valueOptionMap) {
        CardListSeniorFilterDefaultOption cardListCommonFilterDefaultOption = new CardListSeniorFilterDefaultOption();
        cardListCommonFilterDefaultOption.setFilterOptionId(filterOptionId);
        cardListCommonFilterDefaultOption.setFilterOptionName(filterOptionName);
        List valueOptionList = valueOptionMap.entrySet().stream().map(item -> {
            CardListBaseOption cardListBaseOption = new CardListBaseOption();
            cardListBaseOption.setFilterOptionId((String)item.getKey());
            cardListBaseOption.setFilterOptionName((String)item.getValue());
            return cardListBaseOption;
        }).collect(Collectors.toList());
        cardListCommonFilterDefaultOption.setValueOptionList(valueOptionList);
        cardListCommonFilterDefaultOption.setDataType(dataType);
        cardListCommonFilterDefaultOption.setSourceType(sourceType);
        return cardListCommonFilterDefaultOption;
    }

    private void buildSeniorFilter(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter, Map<String, String> taskTypeMap, Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter, List<DigiwinAtmcFilterSetting> filterTaskSettingList, Map<String, Set<String>> customSelectOptionMap) {
        String locale = apiRequest.getLocale();
        ArrayList defaultOptionList = new ArrayList(5);
        Arrays.stream(SystemFilterEnum.values()).forEach(item -> {
            Map options = "type".equalsIgnoreCase(item.getType()) ? taskTypeMap : item.getOptions(locale);
            defaultOptionList.add(this.buildCardListSeniorFilterDefaultOption(item.getType(), this.localeService.getLanguageValue(locale, item.getName()), item.getDataType(), SourceTypeEnum.SYSTEM.getType(), options, locale));
        });
        List customFilterTaskSettingCodeList = filterTaskSettingList.stream().filter(item -> "customer".equalsIgnoreCase(item.getSourceType())).map(item -> item.getCode()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customFilterTaskSettingCodeList)) {
            customFilter.entrySet().forEach(item -> {
                if (customFilterTaskSettingCodeList.contains(item.getKey())) {
                    DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter cardConfigFilter = (DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter)item.getValue();
                    Map<Object, Object> valueOptionMap = Collections.emptyMap();
                    if (DataTypeEnum.SELECT.getName().equalsIgnoreCase(cardConfigFilter.getDataType())) {
                        Set customSelectOptionList = (Set)MapUtil.getOrDefault((Map)customSelectOptionMap, (String)((String)item.getKey()), Collections.emptySet());
                        valueOptionMap = customSelectOptionList.stream().collect(Collectors.toMap(e -> e, e -> e));
                    }
                    defaultOptionList.add(this.buildCardListSeniorFilterDefaultOption((String)item.getKey(), cardConfigFilter.getAliasName(), cardConfigFilter.getDataType(), SourceTypeEnum.CUSTOM.getType(), valueOptionMap, locale));
                }
            });
        }
        CardListSeniorFilter cardListSeniorFilter = new CardListSeniorFilter();
        cardListSeniorFilter.setDefaultOptionList(defaultOptionList);
        if (Objects.nonNull(taskFilter) && StringUtils.hasLength((String)taskFilter.getSeniorFilter())) {
            List cardListSeniorFilterSelectedOptionList = (List)JsonUtil.jsonStringToObject((String)taskFilter.getSeniorFilter(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            cardListSeniorFilter.setSelectedOptionList(cardListSeniorFilterSelectedOptionList);
        }
        todoList.setSeniorFilter(cardListSeniorFilter);
    }

    private CardListSeniorFilterDefaultOption buildCardListSeniorFilterDefaultOption(String filterOptionId, String filterOptionName, String dataType, String sourceType, Map<String, String> valueOptionMap, String locale) {
        CardListSeniorFilterDefaultOption cardListSeniorFilterDefaultOption = new CardListSeniorFilterDefaultOption();
        cardListSeniorFilterDefaultOption.setFilterOptionId(filterOptionId);
        cardListSeniorFilterDefaultOption.setFilterOptionName(filterOptionName);
        List valueOptionList = valueOptionMap.entrySet().stream().map(item -> {
            CardListBaseOption cardListBaseOption = new CardListBaseOption();
            cardListBaseOption.setFilterOptionId((String)item.getKey());
            cardListBaseOption.setFilterOptionName((String)item.getValue());
            return cardListBaseOption;
        }).collect(Collectors.toList());
        cardListSeniorFilterDefaultOption.setValueOptionList(valueOptionList);
        cardListSeniorFilterDefaultOption.setFilterConditionList(this.buildFilterConditionList(dataType, locale));
        cardListSeniorFilterDefaultOption.setSpliceConditionList(this.buildSpliceConditionList(locale));
        cardListSeniorFilterDefaultOption.setDataType(dataType);
        cardListSeniorFilterDefaultOption.setSourceType(sourceType);
        return cardListSeniorFilterDefaultOption;
    }

    private List<CardListBaseOption> buildFilterConditionList(String dataType, String locale) {
        return Arrays.stream(FilterTypeEnum.values()).filter(e -> e.getSupportDataType().contains(dataType)).map(item -> {
            CardListBaseOption cardListBaseOption = new CardListBaseOption();
            cardListBaseOption.setFilterOptionId(item.getType());
            cardListBaseOption.setFilterOptionName(this.localeService.getLanguageValue(locale, item.getName()));
            return cardListBaseOption;
        }).collect(Collectors.toList());
    }

    private List<CardListBaseOption> buildSpliceConditionList(String locale) {
        return Arrays.stream(SpliceTypeEnum.values()).map(item -> {
            CardListBaseOption cardListBaseOption = new CardListBaseOption();
            cardListBaseOption.setFilterOptionId(item.getType());
            cardListBaseOption.setFilterOptionName(this.localeService.getLanguageValue(locale, item.getName()));
            return cardListBaseOption;
        }).collect(Collectors.toList());
    }

    public TodoList paddingMobileTaskListFormWithOutFilterList(ApiRequest apiRequest, List<DigiwinAtmcBacklog> myBacklogs, TodoList todoList, boolean isNeedShowFilter, String tenantVersion) {
        List pageTaskRelationList = this.activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);
        List customTaskConfigList = this.customTaskConfigService.listCustomTaskConfig();
        HashMap<String, String> taskTypeMap = new HashMap<String, String>(16);
        HashMap taskTypeData = new HashMap(16);
        HashMap taskFlowData = new HashMap(16);
        HashMap taskReadStatusData = new HashMap(16);
        HashMap taskStatusData = new HashMap(16);
        HashMap customFilter = new HashMap(16);
        HashMap customSelectOptionMap = new HashMap();
        HashSet orderCodeSetFromBacklogs = new HashSet();
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>(myBacklogs.size());
        for (DigiwinAtmcBacklog digiwinAtmcBacklog : myBacklogs) {
            TaskSummary taskSummary;
            String jumpPageId;
            Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId())).findFirst();
            Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory())).findFirst();
            String string = optPageTaskRelationTaskIdAndActivityId.isPresent() ? optPageTaskRelationTaskIdAndActivityId.get().getPageId() : (jumpPageId = optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
            if (isNeedShowFilter) {
                taskTypeMap.put(digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmActivityName());
                taskSummary = TaskSummary.create((String)apiRequest.getLocale(), (String)apiRequest.getIamUserToken(), (DigiwinAtmcBacklog)digiwinAtmcBacklog, (String)jumpPageId, (List)customTaskConfigList, (boolean)true, (String)apiRequest.getUserId(), (boolean)false, (String)"", taskTypeData, taskFlowData, taskReadStatusData, taskStatusData, customFilter, customSelectOptionMap, orderCodeSetFromBacklogs, (LocaleService)this.localeService);
            } else {
                taskSummary = TaskSummary.create((String)apiRequest.getLocale(), (String)apiRequest.getIamUserToken(), (DigiwinAtmcBacklog)digiwinAtmcBacklog, (String)jumpPageId, (List)customTaskConfigList, (boolean)true, (String)apiRequest.getUserId(), (boolean)false, (LocaleService)this.localeService);
            }
            taskSummaries.add(taskSummary);
        }
        todoList.setTodoList(TaskSummary.sortTeamList(taskSummaries));
        if (isNeedShowFilter) {
            todoList.setSearchUrl("/mobile/v1/task/search");
            todoList.setSearchIdList(new ArrayList());
            UserTaskFilter taskFilter = new UserTaskFilter();
            List filterTaskSettingList = this.digiwinAtmcProxyService.getFilterTaskSetting(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
            this.buildCommonFilter(apiRequest, todoList, taskFilter, taskTypeMap, customFilter, filterTaskSettingList, customSelectOptionMap);
            this.buildSeniorFilter(apiRequest, todoList, taskFilter, taskTypeMap, customFilter, filterTaskSettingList, customSelectOptionMap);
            todoList.setIsUseSeniorFilter(Boolean.valueOf(Objects.isNull(taskFilter) || Objects.isNull(taskFilter.getIsUseSeniorFilter()) ? false : taskFilter.getIsUseSeniorFilter()));
            this.buildGroupFilterInfo(apiRequest, todoList, taskFilter, false);
            this.buildSortFilterList(apiRequest, todoList, taskFilter, orderCodeSetFromBacklogs, false);
            this.buildDefaultFilterSwitch(apiRequest, todoList);
        }
        return todoList;
    }

    private List<CardListFilter> buildFilterList(Map<String, String> taskTypeMap, String locale, Map<String, Integer> taskTypeData, Map<String, Integer> taskFlowData, Map<String, Integer> taskReadStatusData, Map<String, Integer> taskStatusData, List<String> filterIds) {
        ArrayList<CardListFilter> filterList = new ArrayList<CardListFilter>(4);
        CardListFilter taskTypeFilter = new CardListFilter();
        taskTypeFilter.setFilterId("type");
        taskTypeFilter.setFilterName(this.localeService.getLanguageValue(locale, "\u4efb\u52a1\u7c7b\u578b"));
        ArrayList<CardListOption> taskTypeFilterOptionSet = new ArrayList<CardListOption>(taskTypeMap.size());
        if (!CollectionUtils.isEmpty(taskTypeMap)) {
            for (String key : taskTypeMap.keySet()) {
                if (filterIds.contains(key)) {
                    taskTypeFilterOptionSet.add(new CardListOption(key, taskTypeMap.get(key), true));
                    continue;
                }
                taskTypeFilterOptionSet.add(new CardListOption(key, taskTypeMap.get(key), false));
            }
        }
        taskTypeFilter.setFilterDataMap(taskTypeData);
        taskTypeFilter.setFilterOptionList(taskTypeFilterOptionSet);
        filterList.add(taskTypeFilter);
        filterList.add(this.buildFilter("otherTaskInfo", locale, "\u4efb\u52a1\u6765\u6e90", DigiwinAtmcBacklog.TASK_FLOW_MAP, taskFlowData, filterIds));
        filterList.add(this.buildFilter("readStatus", locale, "\u9605\u8bfb\u72b6\u6001", DigiwinAtmcBacklog.TASK_READ_STATUS_MAP, taskReadStatusData, filterIds));
        filterList.add(this.buildFilter("status", locale, "\u4efb\u52a1\u72b6\u6001", DigiwinAtmcBacklog.TASK_STATUS_MAP, taskStatusData, filterIds));
        return filterList;
    }

    private CardListFilter buildFilter(String filterId, String locale, String name, Map<String, String> options, Map<String, Integer> dataMap, List<String> filterIds) {
        CardListFilter taskFlowFilter = new CardListFilter();
        taskFlowFilter.setFilterId(filterId);
        taskFlowFilter.setFilterName(this.localeService.getLanguageValue(locale, name));
        ArrayList<CardListOption> taskFlowFilterOptionSet = new ArrayList<CardListOption>(options.size());
        for (String key : options.keySet()) {
            if (filterIds.contains(key)) {
                taskFlowFilterOptionSet.add(new CardListOption(key, this.localeService.getLanguageValue(locale, options.get(key)), true));
                continue;
            }
            taskFlowFilterOptionSet.add(new CardListOption(key, this.localeService.getLanguageValue(locale, options.get(key)), false));
        }
        taskFlowFilter.setFilterDataMap(dataMap);
        taskFlowFilter.setFilterOptionList(taskFlowFilterOptionSet);
        return taskFlowFilter;
    }

    private void buildGroupFilterInfo(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter, boolean isShowSelected) {
        List digiwinAtmcGroupRecordList = this.digiwinAudcProxyService.getGroupRecord(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty((Collection)digiwinAtmcGroupRecordList)) {
            List cardListGroupFilterOptionList = digiwinAtmcGroupRecordList.stream().filter(e -> BooleanUtils.isTrue((Boolean)e.getEnabled()) && !"groupByMember".equalsIgnoreCase(e.getCode()) && !"groupByDepartment".equalsIgnoreCase(e.getCode())).map(item -> {
                CardListGroupOption cardListGroupFilterOption = new CardListGroupOption();
                cardListGroupFilterOption.setFilterOptionId(item.getCode());
                String filterOptionName = item.getName() + (StringUtil.isNotEmpty((CharSequence)item.getAppName()) ? "(" + item.getAppName() + ")" : "");
                cardListGroupFilterOption.setFilterOptionName(filterOptionName);
                if (Objects.nonNull(taskFilter) && isShowSelected) {
                    cardListGroupFilterOption.setIsSelect(Boolean.valueOf(Objects.equals(item.getCode(), taskFilter.getGroupFilterIds())));
                } else {
                    cardListGroupFilterOption.setIsSelect(Boolean.valueOf("noGrouping".equalsIgnoreCase(item.getCode())));
                }
                cardListGroupFilterOption.setType(item.getType());
                return cardListGroupFilterOption;
            }).collect(Collectors.toList());
            CardListGroupFilter cardListGroupFilter = new CardListGroupFilter();
            cardListGroupFilter.setFilterOptionList(cardListGroupFilterOptionList);
            List selectCodeList = cardListGroupFilterOptionList.stream().filter(e -> BooleanUtils.isTrue((Boolean)e.getIsSelect())).map(e -> e.getFilterOptionId()).collect(Collectors.toList());
            todoList.setGroupFilterIdList(selectCodeList);
            todoList.setGroupFilterList(Collections.singletonList(cardListGroupFilter));
        }
    }

    private void buildSortFilterList(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter, Set<String> orderCodeSetFromBacklogs, boolean isShowSelected) {
        List sortItemList;
        List atmcOrderSettingList = this.digiwinAtmcProxyService.getOrderTaskSetting(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (CollectionUtils.isEmpty((Collection)atmcOrderSettingList)) {
            return;
        }
        if (CollectionUtils.isEmpty(atmcOrderSettingList = atmcOrderSettingList.stream().filter(item -> {
            if ("customer".equalsIgnoreCase(item.getSourceType())) {
                return orderCodeSetFromBacklogs.contains(item.getCode());
            }
            return true;
        }).collect(Collectors.toList()))) {
            return;
        }
        List defaultSortList = atmcOrderSettingList.stream().filter(item -> BooleanUtils.isTrue((Boolean)item.getEnable())).map(item -> this.buildDefaultSort(apiRequest, item)).collect(Collectors.toList());
        if (Objects.isNull(taskFilter) || StringUtil.isEmpty((CharSequence)taskFilter.getSortFilter())) {
            sortItemList = atmcOrderSettingList.stream().map(item -> this.buildDefaultSort(apiRequest, item)).collect(Collectors.toList());
        } else {
            List cardListSortrSelectedOption = (List)JsonUtil.jsonStringToObject((String)taskFilter.getSortFilter(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map<String, DigiwinAtmcOrderSetting> digiwinAtmcOrderSettingMapByCode = atmcOrderSettingList.stream().collect(Collectors.toMap(DigiwinAtmcOrderSetting::getCode, e -> e, (key1, key2) -> key2));
            sortItemList = cardListSortrSelectedOption.stream().filter(item -> digiwinAtmcOrderSettingMapByCode.containsKey(item.getCode())).map(item -> {
                DigiwinAtmcOrderSetting digiwinAtmcOrderSetting = (DigiwinAtmcOrderSetting)digiwinAtmcOrderSettingMapByCode.get(item.getCode());
                List orderOptionEnumList = OrderOptionEnum.getCommonSort((Boolean)digiwinAtmcOrderSetting.getEnableDefaultSort());
                List cardListOptionList = orderOptionEnumList.stream().map(orderOption -> {
                    CardListOption cardListOption = new CardListOption();
                    cardListOption.setFilterOptionId(orderOption.getType());
                    String orderOptionName = orderOption.getName();
                    if ("READ_STATUS".equalsIgnoreCase(digiwinAtmcOrderSetting.getCode())) {
                        orderOptionName = ReadStateOrderOptionEnum.getReadStateOrderOptionNameByType((String)orderOption.getType());
                    }
                    cardListOption.setFilterOptionName(this.localeService.getLanguageValue(apiRequest.getLocale(), orderOptionName));
                    List valueOptionList = item.getValueOptionList();
                    if (!CollectionUtils.isEmpty((Collection)valueOptionList)) {
                        cardListOption.setIsSelect(Boolean.valueOf(isShowSelected && valueOptionList.contains(orderOption.getType())));
                    }
                    return cardListOption;
                }).collect(Collectors.toList());
                CardListSortItem cardListSortItem = new CardListSortItem();
                cardListSortItem.setFilterId(digiwinAtmcOrderSetting.getCode());
                cardListSortItem.setFilterName(digiwinAtmcOrderSetting.getName());
                cardListSortItem.setSourceType(digiwinAtmcOrderSetting.getSourceType());
                cardListSortItem.setFilterOptionList(cardListOptionList);
                return cardListSortItem;
            }).collect(Collectors.toList());
        }
        CardListSort cardListSort = new CardListSort();
        cardListSort.setDefaultSortList(defaultSortList);
        cardListSort.setSortFilterList(sortItemList);
        todoList.setSortFilter(cardListSort);
    }

    private CardListSortItem buildDefaultSort(ApiRequest apiRequest, DigiwinAtmcOrderSetting digiwinAtmcOrderSetting) {
        List orderOptionEnumList = OrderOptionEnum.getCommonSort((Boolean)digiwinAtmcOrderSetting.getEnableDefaultSort());
        List cardListOptionList = orderOptionEnumList.stream().map(orderOption -> {
            CardListOption cardListOption = new CardListOption();
            cardListOption.setFilterOptionId(orderOption.getType());
            String orderOptionName = orderOption.getName();
            if ("READ_STATUS".equalsIgnoreCase(digiwinAtmcOrderSetting.getCode())) {
                orderOptionName = ReadStateOrderOptionEnum.getReadStateOrderOptionNameByType((String)orderOption.getType());
            }
            cardListOption.setFilterOptionName(this.localeService.getLanguageValue(apiRequest.getLocale(), orderOptionName));
            return cardListOption;
        }).collect(Collectors.toList());
        CardListSortItem cardListSortItem = new CardListSortItem();
        cardListSortItem.setFilterId(digiwinAtmcOrderSetting.getCode());
        cardListSortItem.setFilterName(digiwinAtmcOrderSetting.getName());
        cardListSortItem.setSourceType(digiwinAtmcOrderSetting.getSourceType());
        cardListSortItem.setFilterOptionList(cardListOptionList);
        return cardListSortItem;
    }

    private void buildFilterSwitch(ApiRequest apiRequest, TodoList todoList) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("userId", apiRequest.getUserId());
        params.put("tenantId", apiRequest.getTenantId());
        PersonalConfiguration personalConfiguration = this.personalConfigurationService.getByMap(params);
        CardListFilterSwitch showEocSwitch = new CardListFilterSwitch();
        showEocSwitch.setId("eocName");
        showEocSwitch.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u8fd0\u8425\u5355\u5143"));
        showEocSwitch.setIsSelect(Boolean.valueOf(Objects.isNull(personalConfiguration) ? false : personalConfiguration.getShowEoc()));
        todoList.setShowEocSwitch(showEocSwitch);
        CardListFilterSwitch showHandledCardSwitch = new CardListFilterSwitch();
        showHandledCardSwitch.setId("engineHasWaittingData");
        showHandledCardSwitch.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u5df2\u5904\u7406\u5361"));
        showHandledCardSwitch.setIsSelect(Boolean.valueOf(Objects.isNull(personalConfiguration) ? true : personalConfiguration.getShowHandledCard()));
        todoList.setShowHandledCardSwitch(showHandledCardSwitch);
    }

    private void buildDefaultFilterSwitch(ApiRequest apiRequest, TodoList todoList) {
        CardListFilterSwitch showEocSwitch = new CardListFilterSwitch();
        showEocSwitch.setId("eocName");
        showEocSwitch.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u8fd0\u8425\u5355\u5143"));
        showEocSwitch.setIsSelect(Boolean.valueOf(false));
        todoList.setShowEocSwitch(showEocSwitch);
        CardListFilterSwitch showHandledCardSwitch = new CardListFilterSwitch();
        showHandledCardSwitch.setId("engineHasWaittingData");
        showHandledCardSwitch.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u5df2\u5904\u7406\u5361"));
        showHandledCardSwitch.setIsSelect(Boolean.valueOf(true));
        todoList.setShowHandledCardSwitch(showHandledCardSwitch);
    }

    private List<Map<String, Object>> getAllList(Map<String, Object> moduleInfo) {
        if (CollectionUtils.isEmpty(moduleInfo)) {
            return this.buildAllList();
        }
        if (Objects.isNull(moduleInfo.get("detail"))) {
            return this.buildAllList();
        }
        Map detail = (Map)JsonUtil.jsonStringToObject((String)MapUtils.getString(moduleInfo, (Object)"detail"), Map.class);
        List allList = (List)MapUtil.getOrDefault((Map)detail, (String)"all", Collections.emptyList());
        if (CollectionUtils.isEmpty((Collection)allList)) {
            return this.buildAllList();
        }
        return allList;
    }

    private List<Map<String, Object>> buildAllList() {
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(4);
        HashMap<String, Object> typeItemMap = new HashMap<String, Object>();
        typeItemMap.put("selectedOption", "setLabelFront");
        typeItemMap.put("type", "label");
        typeItemMap.put("switch", false);
        itemList.add(typeItemMap);
        HashMap<String, Object> readStatusItemMap = new HashMap<String, Object>();
        readStatusItemMap.put("selectedOption", "readStatusUnread");
        readStatusItemMap.put("defaultOption", "readStatusRead");
        readStatusItemMap.put("type", "readStatus");
        readStatusItemMap.put("switch", false);
        itemList.add(readStatusItemMap);
        HashMap<String, Object> timeItemMap = new HashMap<String, Object>();
        timeItemMap.put("selectedOption", "timeEndTimeAsc");
        timeItemMap.put("defaultOption", "timeEndTimeDesc");
        timeItemMap.put("type", "time");
        timeItemMap.put("switch", false);
        itemList.add(timeItemMap);
        HashMap<String, Object> taskTypeItemMap = new HashMap<String, Object>();
        taskTypeItemMap.put("selectedOption", "taskTypeFront");
        taskTypeItemMap.put("type", "taskType");
        taskTypeItemMap.put("switch", false);
        itemList.add(taskTypeItemMap);
        return itemList;
    }

    private List<TaskSummary> doMockData(String locale) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = FileUtil.readText((String)"static/appstore-use/task-list.json");
        List taskSummaries = Collections.emptyList();
        if (null != data && !data.isEmpty()) {
            taskSummaries = JSONArray.parseArray((String)data, TaskSummary.class);
        }
        return taskSummaries;
    }
}

