/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress.ChooseTaskProgress;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildReassignReportStrategy")
public class UiBotModelBuildReassignReportStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildReassignReportStrategy.class);
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        Object reassignReportType = rawData.get("reassignReportType");
        List reassignReportList = new ArrayList();
        if ("PROJECT".equals(reassignReportType)) {
            reassignReportList = this.digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        } else if ("TASK".equals(reassignReportType)) {
            reassignReportList = this.digiwinAtmcProxyService.getTaskReassignReport(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        } else {
            List reassignReportMap = (List)rawData.get("rawData");
            reassignReportList = ModuleUtils.listMapToListObject((List)reassignReportMap, DigiwinReassignReport.class);
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "CHOOSE_TASK_PROGRESS": {
                    pageData.put((Object)uiBotLayout.getSchema(), (Object)ChooseTaskProgress.createReassignReport((String)locale, reassignReportList));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)uiBotLayout.getSchema())), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)bottomButton.getName()));
                    }
                    pageData.put((Object)uiBotLayout.getSchema(), (Object)buttons);
                    break;
                }
            }
        }
        return pageSetting.getPageModel();
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)("static/appstore-use/project-create-" + apiRequest.getDataId() + ".json"));
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

