/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.core.component.index.TripartiteTodoList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.LabelSystemData;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildTripartiteToDoListStrategy")
public class UiBotModelBuildTripartiteToDoListStrategy
implements UiBotModelBuildStrategy {
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            if (!uiBotLayout.getType().equals("TRIPARTITE_TODO_LIST")) continue;
            pageData.put((Object)uiBotLayout.getSchema(), (Object)TripartiteTodoList.createTripartiteToDoList((ApiRequest)apiRequest, (UiBotPageData)pageData, (List)this.handleData(apiRequest), (String)uiBotLayout.getSchema()));
        }
        return uiBotModel;
    }

    private List<LabelSystemData> handleData(ApiRequest apiRequest) {
        try {
            CompletableFuture<List> supplyAsync = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.getTripartiteToDoList(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), (Executor)this.threadPoolTaskExecutor);
            return supplyAsync.get();
        }
        catch (InterruptedException | ExecutionException e) {
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
    }
}

