/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelSmartSearchStrategy")
public class UiBotModelSmartSearchStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelSmartSearchStrategy.class);
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildSmartSearch");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        stopWatch.start("Build Common Page Model");
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, (Object)pageSetting.getPageModel().getPageData(), Boolean.valueOf(true));
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = FileUtil.readText((String)"static/smartsearch.json");
        UiBotModel uiBotModel = null;
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

