/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeData;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotModelBuildApcOnlineReportStrategy")
public class UiBotModelBuildApcOnlineReportStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case "EMPLOYEE_LIST": {
                    pageData.put((Object)schema, (Object)this.buildEmployeeData(apiRequest));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)bottomButton.getName()));
                    }
                    pageData.put((Object)schema, (Object)buttons);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private EmployeeList buildEmployeeData(ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        EmployeeList employeeList = new EmployeeList().setTitle(this.localeService.getLanguageValue(locale, "\u62a5\u5de5\u5728\u7ebf\u4eba\u5458\u6e05\u5355")).setStyle(Integer.valueOf(2));
        List onlineReporterData = this.digiwinEspProxyService.getWoOpOnlineReporterInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), (List)apiRequest.getRawData().get((Object)"wo_op_report_data"));
        Boolean isShowOpName = apiRequest.getRawData().getBoolean("isShowOpName");
        if (CollectionUtils.isEmpty((Collection)onlineReporterData)) {
            return employeeList;
        }
        ArrayList<EmployeeData> employeeDatas = new ArrayList<EmployeeData>();
        for (int i = 0; i < onlineReporterData.size(); ++i) {
            List onlineReporterDetail = (List)((Map)onlineReporterData.get(i)).get("online_reporter_detail");
            if (CollectionUtils.isEmpty((Collection)onlineReporterData)) {
                return employeeList;
            }
            for (Map reporterDetail : onlineReporterDetail) {
                List opDetails = (List)reporterDetail.get("wo_sub_op_detail");
                if (CollectionUtils.isEmpty((Collection)opDetails)) {
                    return employeeList;
                }
                for (Map opDetail : opDetails) {
                    List reporterDetails = (List)opDetail.get("reporter_detail");
                    if (CollectionUtils.isEmpty((Collection)reporterDetails)) {
                        return employeeList;
                    }
                    for (Map detail : reporterDetails) {
                        EmployeeData data = new EmployeeData();
                        data.setEmployeeNo((String)detail.get("reporter_no"));
                        data.setEmployeeName((String)detail.get("reporter_name"));
                        data.setFields(this.buildEmployeFiled(locale, reporterDetail, isShowOpName));
                        employeeDatas.add(data);
                    }
                }
            }
        }
        return employeeList.setTotal(Integer.valueOf(employeeDatas.size())).setEmployeeDatas(employeeDatas);
    }

    private List<Field> buildEmployeFiled(String locale, Map<String, Object> reporterDetail, Boolean isShowOpName) {
        ArrayList<Field> fields = new ArrayList<Field>(1);
        Field field = new Field();
        field.setLabel(this.localeService.getLanguageValue(locale, "\u73ed\u7ec4"));
        field.setValue(ModuleUtils.emptyValueToHyphen((Object)reporterDetail.get("team_name")));
        fields.add(field);
        if (BooleanUtils.isTrue((Boolean)isShowOpName)) {
            Field opNameField = new Field();
            opNameField.setLabel(this.localeService.getLanguageValue(locale, "\u5b50\u5236\u7a0b\u540d\u79f0"));
            opNameField.setValue(ModuleUtils.emptyValueToHyphen((Object)reporterDetail.get("op_name")));
            fields.add(opNameField);
        }
        return fields;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
    }
}

