/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="uiBotModelBuildApcWorkShopOnlineAreaTakeEffectDetailStrategy")
public class UiBotModelBuildApcWorkShopOnlineAreaTakeEffectDetailStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_WHITE.getValue());
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        ApiRawData rawData = apiRequest.getRawData();
        Map params = (Map)JsonUtil.objectToJavaObject(rawData.get("rawData"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isEmpty((Map)params)) {
            return UiBotModel.emptyUibotModelWithCancelButton((String)locale);
        }
        params.put("area_no", rawData.get("area_no"));
        Map returnMap = this.digiwinEspProxyService.getWoOpDispatchAreaSpaceDetailInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        if (ObjectUtil.isEmpty((Object)returnMap)) {
            return UiBotModel.emptyUibotModelWithCancelButton((String)locale);
        }
        String areaSpacePercentage = ObjectUtil.isNotEmpty(returnMap.get("area_space_percentage")) ? returnMap.get("area_space_percentage").toString() : "0";
        List datas = (List)returnMap.get("eff_wo_op_data");
        if (CollUtil.isEmpty((Collection)datas)) {
            return uiBotModel;
        }
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    customGroup.setName(rawData.get(customGroup.getName()) + " " + this.localeService.getLanguageValue(locale, "\u533a\u57df\u5360\u7528\u6bd4\u4f8b") + ": " + Double.valueOf(areaSpacePercentage).intValue());
                    CustomGroupContent content = customGroup.getContent();
                    ArrayList<UiBotLayout> customUiBotLayouts = new ArrayList<UiBotLayout>(datas.size());
                    UiBotPageData customPageData = new UiBotPageData();
                    for (UiBotLayout layout : content.getLayout()) {
                        if (!"CARD".equalsIgnoreCase(layout.getType())) continue;
                        Card card = (Card)JsonUtil.objectToJavaObject((Object)content.getPageData().get((Object)layout.getSchema()), Card.class);
                        for (Map data : datas) {
                            Retractable retractable = new Retractable();
                            List retractableContent = retractable.getContent();
                            String id = UUID.randomUUID().toString();
                            UiBotLayout newLayout = new UiBotLayout(id, "RETRACYABLE");
                            List mapList = (List)data.get("eff_wo_op_detail");
                            if (CollUtil.isNotEmpty((Collection)mapList)) {
                                for (Map map : mapList) {
                                    Card dataCard = new Card();
                                    dataCard.setTitle((String)map.get(card.getTitle()));
                                    dataCard.setBgColor("#f8f8fc");
                                    List cardContents = card.getContent();
                                    for (CardContent cardContent : cardContents) {
                                        CardContent newCardContent = new CardContent();
                                        newCardContent.setLabel(this.localeService.getLanguageValue(locale, cardContent.getLabel()));
                                        switch (cardContent.getSchema()) {
                                            case "occupy_space": {
                                                if (!ObjectUtil.isNotEmpty(map.get(cardContent.getSchema()))) break;
                                                int i = (int)Double.parseDouble(map.get(cardContent.getSchema()).toString());
                                                newCardContent.setValue(String.valueOf(i));
                                                break;
                                            }
                                            case "plan_complete_date": {
                                                if (!ObjectUtil.isNotEmpty(map.get(cardContent.getSchema()))) break;
                                                String date = map.get(cardContent.getSchema()).toString();
                                                newCardContent.setValue(DateUtil.format((Date)DateUtil.parse((CharSequence)date), (String)"yyyy.MM.dd"));
                                                break;
                                            }
                                            default: {
                                                newCardContent.setValue((String)map.get(cardContent.getSchema()));
                                            }
                                        }
                                        newCardContent.setSchema(cardContent.getSchema());
                                        dataCard.getContent().add(newCardContent);
                                    }
                                    retractableContent.add(new BaseMobileComponentWrapper((BaseMobileComponent)dataCard, "CARD"));
                                }
                            }
                            retractable.setTitle(UiBotModelBuildApcWorkShopOnlineAreaTakeEffectDetailStrategy.getStartDate((Map)data, (String)locale) + " (" + this.localeService.getLanguageValue(locale, "\u53ef\u7528\u533a\u57df\uff1a") + Double.valueOf(String.valueOf(data.get("available_space"))).intValue() + ")");
                            retractable.setStyle(Integer.valueOf(2));
                            retractable.setAlignmentType(Integer.valueOf(1));
                            retractable.setContent(retractableContent);
                            retractable.setIconStatus(Integer.valueOf(Integer.parseInt(String.valueOf(data.get("area_show_color")))));
                            customPageData.put((Object)id, (Object)retractable);
                            customUiBotLayouts.add(newLayout);
                        }
                    }
                    content.setLayout(customUiBotLayouts);
                    content.setPageData(customPageData);
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                    }
                    pageData.put((Object)schema, (Object)buttons);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private static String getStartDate(Map<String, Object> data, String local) {
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
        if (ObjectUtils.isEmpty((Object)data.get("start_date"))) {
            return "";
        }
        String date = String.valueOf(data.get("start_date"));
        LocalDate localDate = LocalDate.parse(LocalDate.now().getYear() + "/" + date, DateTimeFormatter.ofPattern("yyyy/MM/dd"));
        return String.format("%s%s", localDate.getMonthValue() + localeService.getLanguageValue(local, "\u6708"), localDate.getDayOfMonth() + localeService.getLanguageValue(local, "\u65e5"));
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
    }
}

