/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.AppBasePageNameEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PersonnelOnlineManage {
    private static final Logger logger = LoggerFactory.getLogger(PersonnelOnlineManage.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private LocaleService localeService;

    public List<WoOpReportInfo> woOpReportPersonnelGet(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        ArrayList<WoOpReportInfo> allReportList = new ArrayList<WoOpReportInfo>();
        ArrayList<Future> futureList = new ArrayList<Future>();
        Future online = this.threadPoolTaskExecutor.submit(() -> this.digiwinEspProxyService.woOpReportPersonnelCheckedInInfoGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(online);
        Future offline = this.threadPoolTaskExecutor.submit(() -> this.digiwinEspProxyService.woOpReportPersonnelNotCheckInInfoGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(offline);
        Future except = this.threadPoolTaskExecutor.submit(() -> this.digiwinEspProxyService.woOpReportPersonnelExceptInfoGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(except);
        Future support = this.threadPoolTaskExecutor.submit(() -> this.digiwinEspProxyService.requestSupportInfoGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(support);
        try {
            PersonnelStateEnum[] keys = new PersonnelStateEnum[]{PersonnelStateEnum.ONLINE, PersonnelStateEnum.OFFLINE, PersonnelStateEnum.EXCEPT, PersonnelStateEnum.SUPPORT};
            for (int i = 0; i < futureList.size(); ++i) {
                List result;
                Future future = (Future)futureList.get(i);
                while (true) {
                    if (future.isDone() && !future.isCancelled()) {
                        result = (List)future.get();
                        for (WoOpReportInfo reportInfo : result) {
                            reportInfo.setStateEnum(keys[i]);
                        }
                        break;
                    }
                    Thread.sleep(1L);
                }
                allReportList.addAll(result);
            }
        }
        catch (InterruptedException | ExecutionException e2) {
            logger.error(e2.getLocalizedMessage());
            e2.printStackTrace();
            String message = e2.getMessage();
            if (null != e2.getCause()) {
                message = e2.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        allReportList.forEach(e -> {
            e.setEocCompanyId(eocCompanyId);
            e.setEocSiteId(eocSiteId);
        });
        return allReportList;
    }

    public void buildRawData(InputCascade.DefaultSelect defaultSelect, Map<String, Object> rawData) {
        List list = this.defaultSelect2List(defaultSelect);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            rawData.put("eoc_company_id", list);
        }
    }

    private List<Map<String, Object>> defaultSelect2List(InputCascade.DefaultSelect defaultSelect) {
        if (null == defaultSelect) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map oneMap = (Map)JsonUtil.objectToJavaObject((Object)defaultSelect, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        oneMap.remove("child");
        list.add(oneMap);
        Map twoMap = (Map)JsonUtil.objectToJavaObject((Object)defaultSelect.getChild(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        twoMap.remove("child");
        list.add(twoMap);
        return list;
    }

    public Button createSearchButton(String locale, InputCascade.DefaultSelect defaultSelect) {
        HashMap<String, String> rawData = new HashMap<String, String>();
        rawData.put("searchCategoryId", "personnel_online_search");
        this.buildRawData(defaultSelect, rawData);
        Button button = new Button();
        button.setName(this.localeService.getLanguageValue(locale, "\u641c\u7d22"));
        button.setId(UUIDUtil.getUuid());
        button.setIconData(Integer.valueOf(59124));
        button.setIconColor("0xFF333333");
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        action.setJumpPageId(AppBasePageNameEnum.APP_SEARCH.getValue());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    public Button createViewModeButton(String locale, InputCascade.DefaultSelect defaultSelect) {
        HashMap rawData = new HashMap();
        this.buildRawData(defaultSelect, rawData);
        Button button = new Button();
        button.setName(this.localeService.getLanguageValue(locale, "\u9009\u62e9\u67e5\u9605\u65b9\u5f0f"));
        button.setId(UUIDUtil.getUuid());
        button.setIconData(Integer.valueOf(58915));
        button.setIconColor("0xFF333333");
        Action action = new Action();
        action.setType(ActionTypeEnum.PERSONNEL_STATE_SWITCH_PAGE.getValue());
        action.setJumpPageId("");
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/choice/view/list");
        action.setJumpPageTitle(this.localeService.getLanguageValue(locale, "\u9009\u62e9\u67e5\u9605\u65b9\u5f0f"));
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }
}

