/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelStateGroup;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelOnlineManage;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.UiBotModelBuildPersonnelOnlineGroupStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotModelBuildPersonnelOnlineGroupDetailStrategy")
public class UiBotModelBuildPersonnelOnlineGroupDetailStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;
    @Autowired
    private UiBotModelBuildPersonnelOnlineGroupStrategy uiBotModelBuildPersonnelOnlineGroupStrategy;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        List selectList;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        InputCascade.DefaultSelect defaultSelect = null;
        if (null != apiRequest.getRawData() && null != apiRequest.getRawData().get((Object)"eoc_company_id") && !CollectionUtils.isEmpty((Collection)(selectList = (List)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)"eoc_company_id"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
            defaultSelect = ((InputCascade.DefaultSelect)selectList.get(0)).setChild((InputCascade.DefaultSelect)selectList.get(1));
        }
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomTabs.class);
                    this.buildCustomTabs(apiRequest, customTabs, defaultSelect);
                    pageData.put((Object)layout.getSchema(), (Object)customTabs);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private void buildCustomTabs(ApiRequest apiRequest, CustomTabs customTabs, InputCascade.DefaultSelect defaultSelect) {
        String eocCompanyId = "";
        String eocSiteId = "";
        if (null != defaultSelect && null != defaultSelect.getChild()) {
            eocCompanyId = Optional.ofNullable(defaultSelect.getId()).orElse("");
            eocSiteId = Optional.ofNullable(defaultSelect.getChild().getId()).orElse("");
        }
        String teamNo = apiRequest.getRawData().getString("teamNo");
        List allReportList = this.personnelOnlineManage.woOpReportPersonnelGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), eocCompanyId, eocSiteId);
        this.uiBotModelBuildPersonnelOnlineGroupStrategy.handleSupportWoOpReportInfo(allReportList);
        Map<PersonnelStateEnum, List<WoOpReportInfo>> reportMap = allReportList.stream().filter(woOpReportInfo -> woOpReportInfo.getTeamNo().equals(teamNo)).collect(Collectors.groupingBy(WoOpReportInfo::getStateEnum));
        for (CustomTab customTab : customTabs) {
            customTab.updateRefreshConfigParam(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId(), apiRequest.getPageId(), (Map)apiRequest.getRawData());
            PersonnelStateEnum stateEnum = PersonnelStateEnum.valueOf((String)customTab.getId());
            List reportList = reportMap.computeIfAbsent(stateEnum, k -> new ArrayList());
            if (CollectionUtils.isEmpty((Collection)reportList)) {
                this.buidlEmptyTab(apiRequest, customTab);
                continue;
            }
            if (PersonnelStateEnum.ONLINE.equals((Object)stateEnum)) {
                this.fillOnlineTab(apiRequest, customTab, reportList);
                continue;
            }
            if (PersonnelStateEnum.SUPPORT.equals((Object)stateEnum)) {
                CustomTab.fillSupportTab((ApiRequest)apiRequest, (CustomTab)customTab, (List)reportList);
                continue;
            }
            this.fillCustomTab(apiRequest, customTab, stateEnum, reportList);
        }
    }

    private void fillCustomTab(ApiRequest apiRequest, CustomTab customTab, PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        CustomTabContentContainer content = new CustomTabContentContainer();
        content.setContentCmptType("PERSONNEL_STATE_GROUP");
        content.setData((Object)this.createContent(apiRequest, stateEnum, reportList));
        customTab.setContent(Collections.singletonList(content));
        customTab.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(" + reportList.size() + ")");
    }

    private void fillOnlineTab(ApiRequest apiRequest, CustomTab customTab, List<WoOpReportInfo> reportList) {
        CustomTabContentContainer content = new CustomTabContentContainer();
        content.setContentCmptType("ZTB_VIEW_LIST");
        content.setData((Object)ZtbViewList.buildZtbViewList((ApiRequest)apiRequest, (LocaleService)this.localeService, reportList));
        customTab.setContent(Collections.singletonList(content));
        customTab.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(" + reportList.size() + ")");
    }

    private CustomTab buidlEmptyTab(ApiRequest apiRequest, CustomTab customTab) {
        customTab.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(0)");
        customTab.setStyle(Integer.valueOf(2));
        customTab.setAlignmentType(Integer.valueOf(1));
        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
        customTabContentContainer.setData((Object)Empty.create((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u6682\u65e0\u6570\u636e")));
        customTabContentContainer.setContentCmptType("EMPTY");
        customTab.setContent(Collections.singletonList(customTabContentContainer));
        return customTab;
    }

    private PersonnelStateGroup createContent(ApiRequest apiRequest, PersonnelStateEnum stateEnum, List<WoOpReportInfo> teamList) {
        return new PersonnelStateGroup().convert(apiRequest, this.localeService, stateEnum, teamList).setTitle("");
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

