/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelGroup;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelOnlineManage;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildPersonnelOnlineGroupStrategy")
public class UiBotModelBuildPersonnelOnlineGroupStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        InputCascade.DefaultSelect defaultSelect = null;
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomGroup.class);
                    defaultSelect = this.buildCustomGroup(apiRequest, customGroup, defaultSelect);
                    pageData.put((Object)layout.getSchema(), (Object)customGroup);
                    break;
                }
                case "BLANK_AREA": {
                    BlankArea blankArea = (BlankArea)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), BlankArea.class);
                    pageData.put((Object)layout.getSchema(), (Object)blankArea);
                    break;
                }
                case "PERSONNEL_GROUP": {
                    PersonnelGroup personnelGroup = (PersonnelGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), PersonnelGroup.class);
                    this.createPersonnelGroup(apiRequest, personnelGroup, defaultSelect);
                    pageData.put((Object)layout.getSchema(), (Object)personnelGroup);
                    break;
                }
            }
        }
        List appbarButtonList = uiBotModel.getAppbarButtonList();
        appbarButtonList.add(this.personnelOnlineManage.createSearchButton(locale, defaultSelect));
        appbarButtonList.add(this.personnelOnlineManage.createViewModeButton(locale, defaultSelect));
        return uiBotModel;
    }

    private InputCascade.DefaultSelect buildCustomGroup(ApiRequest apiRequest, CustomGroup customGroup, InputCascade.DefaultSelect defaultSelect) {
        String locale = apiRequest.getLocale();
        CustomGroupContent content = customGroup.getContent();
        for (UiBotLayout layout : content.getLayout()) {
            switch (layout.getType()) {
                case "INPUT_CASCADE": {
                    List selectList;
                    List companys = this.digiwinEocProxyService.getCompany(apiRequest.getIamUserToken());
                    List factorys = this.digiwinEocProxyService.getFactory(apiRequest.getIamUserToken());
                    InputCascade inputCascade = InputCascade.create((List)companys, (List)factorys, (String)layout.getSchema(), (String)"eoc_site_id", (String)this.localeService.getLanguageValue(locale, "\u4e91\u7aef\u8425\u8fd0\u636e\u70b9"), (int)2, (int)InputCascadeTypeEnum.PARSE.getValue(), (int)InputCascadeSelectStyleEnum.BG_STYLE_WHITE.getValue(), (String)locale);
                    if (null != apiRequest.getRawData() && null != apiRequest.getRawData().get((Object)layout.getSchema()) && !CollectionUtils.isEmpty((Collection)(selectList = (List)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)layout.getSchema()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
                        inputCascade.setDefaultSelect(((InputCascade.DefaultSelect)selectList.get(0)).setChild((InputCascade.DefaultSelect)selectList.get(1)));
                    }
                    defaultSelect = inputCascade.getDefaultSelect();
                    Action submitAction = new Action();
                    submitAction.setJumpPageId(apiRequest.getPageId());
                    submitAction.setJumpPageTitle("");
                    submitAction.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                    inputCascade.setSubmitAction(submitAction);
                    inputCascade.setIsSubmit(Boolean.valueOf(true));
                    content.getPageData().put((Object)layout.getSchema(), (Object)inputCascade);
                    break;
                }
            }
        }
        return defaultSelect;
    }

    private void initButton(String locale, List<BottomButtonDigiwinAthena> customButtonList) {
        if (!CollectionUtils.isEmpty(customButtonList)) {
            for (BottomButtonDigiwinAthena buttonDigiwinAthena : customButtonList) {
                if (StringUtils.hasLength((String)buttonDigiwinAthena.getName())) {
                    buttonDigiwinAthena.setName(this.localeService.getLanguageValue(locale, buttonDigiwinAthena.getName()));
                }
                if (StringUtils.hasLength((String)buttonDigiwinAthena.getSubName())) {
                    buttonDigiwinAthena.setSubName(this.localeService.getLanguageValue(locale, buttonDigiwinAthena.getSubName()));
                }
                this.setRequestUrl(buttonDigiwinAthena);
                List children = buttonDigiwinAthena.getChildren();
                if (CollectionUtils.isEmpty((Collection)children)) continue;
                for (BottomButtonDigiwinAthena button : children) {
                    Action action;
                    if (StringUtils.hasLength((String)button.getName())) {
                        button.setName(this.localeService.getLanguageValue(locale, button.getName()));
                    }
                    if (StringUtils.hasLength((String)button.getSubName())) {
                        button.setSubName(this.localeService.getLanguageValue(locale, button.getSubName()));
                    }
                    if ((action = button.getAction()) != null) {
                        if (StringUtils.hasLength((String)action.getJumpPageTitle())) {
                            action.setJumpPageTitle(this.localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                        }
                        if (StringUtils.hasLength((String)action.getToastMsg())) {
                            action.setToastMsg(this.localeService.getLanguageValue(locale, action.getToastMsg()));
                        }
                    }
                    this.setRequestUrl(button);
                }
            }
        }
    }

    private void setRequestUrl(BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null || !StringUtils.hasLength((String)action.getRequestUrl())) {
            return;
        }
        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
    }

    private void createPersonnelGroup(ApiRequest apiRequest, PersonnelGroup personnelGroup, InputCascade.DefaultSelect defaultSelect) {
        String eocCompanyId = "";
        String eocSiteId = "";
        if (null != defaultSelect && null != defaultSelect.getChild()) {
            eocCompanyId = Optional.ofNullable(defaultSelect.getId()).orElse("");
            eocSiteId = Optional.ofNullable(defaultSelect.getChild().getId()).orElse("");
        }
        List allReportList = this.personnelOnlineManage.woOpReportPersonnelGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), eocCompanyId, eocSiteId);
        this.handleSupportWoOpReportInfo(allReportList);
        HashMap rawData = new HashMap();
        this.personnelOnlineManage.buildRawData(defaultSelect, rawData);
        personnelGroup.convert(apiRequest, allReportList, rawData);
    }

    public void handleSupportWoOpReportInfo(List<WoOpReportInfo> allReportList) {
        List supportReportList = allReportList.stream().filter(allReport -> PersonnelStateEnum.SUPPORT.equals((Object)allReport.getStateEnum())).collect(Collectors.toList());
        allReportList.removeIf(allReport -> PersonnelStateEnum.SUPPORT.equals((Object)allReport.getStateEnum()));
        supportReportList = supportReportList.stream().map(supportReport -> {
            if (CollectionUtils.isEmpty((Collection)supportReport.getTeamList()) || supportReport.getTeamList().size() == 1) {
                return Collections.singletonList(supportReport);
            }
            return supportReport.getTeamList().stream().map(teamNo -> {
                WoOpReportInfo supportWoOpReportInfoByTeamNo = new WoOpReportInfo();
                BeanUtils.copyProperties((Object)supportReport, (Object)supportWoOpReportInfoByTeamNo);
                supportWoOpReportInfoByTeamNo.setTeamNo(teamNo.getTeamNo());
                supportWoOpReportInfoByTeamNo.setTeamName(teamNo.getTeamName());
                supportWoOpReportInfoByTeamNo.setTeamList(null);
                return supportWoOpReportInfoByTeamNo;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        allReportList.addAll(supportReportList);
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

