/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelState;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelOnlineManage;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.UiBotModelBuildPersonnelOnlineGroupStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotModelBuildPersonnelOnlineStateStrategy")
public class UiBotModelBuildPersonnelOnlineStateStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private UiBotModelBuildPersonnelOnlineGroupStrategy uiBotModelBuildPersonnelOnlineGroupStrategy;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData.booleanValue()) {
            String dataId = apiRequest.getDataId();
            if ("GROUP_VIEW".equalsIgnoreCase(dataId)) {
                pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_GROUP.name());
                uiBotModel = this.uiBotModelBuildPersonnelOnlineGroupStrategy.buildModel(pageSetting, apiRequest);
            } else {
                uiBotModel = this.doActuallyByState(pageSetting, apiRequest);
            }
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    public UiBotModel doActuallyByState(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        InputCascade.DefaultSelect defaultSelect = null;
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomGroup.class);
                    defaultSelect = this.buildCustomGroup(apiRequest, customGroup, defaultSelect);
                    pageData.put((Object)layout.getSchema(), (Object)customGroup);
                    break;
                }
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomTabs.class);
                    this.buildCustomTabs(apiRequest, customTabs, defaultSelect);
                    pageData.put((Object)layout.getSchema(), (Object)customTabs);
                    break;
                }
            }
        }
        List appbarButtonList = uiBotModel.getAppbarButtonList();
        appbarButtonList.add(this.personnelOnlineManage.createSearchButton(locale, defaultSelect));
        appbarButtonList.add(this.personnelOnlineManage.createViewModeButton(locale, defaultSelect));
        return uiBotModel;
    }

    private InputCascade.DefaultSelect buildCustomGroup(ApiRequest apiRequest, CustomGroup customGroup, InputCascade.DefaultSelect defaultSelect) {
        String locale = apiRequest.getLocale();
        CustomGroupContent content = customGroup.getContent();
        for (UiBotLayout layout : content.getLayout()) {
            switch (layout.getType()) {
                case "INPUT_CASCADE": {
                    List selectList;
                    List companys = this.digiwinEocProxyService.getCompany(apiRequest.getIamUserToken());
                    List factorys = this.digiwinEocProxyService.getFactory(apiRequest.getIamUserToken());
                    InputCascade inputCascade = InputCascade.create((List)companys, (List)factorys, (String)layout.getSchema(), (String)"eoc_site_id", (String)this.localeService.getLanguageValue(locale, "\u4e91\u7aef\u8425\u8fd0\u636e\u70b9"), (int)2, (int)InputCascadeTypeEnum.PARSE.getValue(), (int)InputCascadeSelectStyleEnum.BG_STYLE_WHITE.getValue(), (String)locale);
                    if (null != apiRequest.getRawData() && null != apiRequest.getRawData().get((Object)layout.getSchema()) && !CollectionUtils.isEmpty((Collection)(selectList = (List)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)layout.getSchema()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
                        inputCascade.setDefaultSelect(((InputCascade.DefaultSelect)selectList.get(0)).setChild((InputCascade.DefaultSelect)selectList.get(1)));
                    }
                    defaultSelect = inputCascade.getDefaultSelect();
                    Action submitAction = new Action();
                    submitAction.setJumpPageId(apiRequest.getPageId());
                    submitAction.setJumpPageTitle("");
                    submitAction.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                    inputCascade.setSubmitAction(submitAction);
                    inputCascade.setIsSubmit(Boolean.valueOf(true));
                    content.getPageData().put((Object)layout.getSchema(), (Object)inputCascade);
                    break;
                }
            }
        }
        return defaultSelect;
    }

    private void buildCustomTabs(ApiRequest apiRequest, CustomTabs customTabs, InputCascade.DefaultSelect defaultSelect) {
        String eocCompanyId = "";
        String eocSiteId = "";
        if (null != defaultSelect && null != defaultSelect.getChild()) {
            eocCompanyId = Optional.ofNullable(defaultSelect.getId()).orElse("");
            eocSiteId = Optional.ofNullable(defaultSelect.getChild().getId()).orElse("");
        }
        List allReportList = this.personnelOnlineManage.woOpReportPersonnelGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), eocCompanyId, eocSiteId);
        Map<PersonnelStateEnum, List<WoOpReportInfo>> reportMap = allReportList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getStateEnum));
        HashMap rawData = new HashMap();
        this.personnelOnlineManage.buildRawData(defaultSelect, rawData);
        for (CustomTab customTab : customTabs) {
            customTab.updateRefreshConfigParam(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId(), apiRequest.getPageId(), rawData);
            PersonnelStateEnum stateEnum = PersonnelStateEnum.valueOf((String)customTab.getId());
            List reportList = reportMap.computeIfAbsent(stateEnum, k -> new ArrayList());
            if (CollectionUtils.isEmpty((Collection)reportList)) {
                this.buidlEmptyTab(apiRequest, customTab);
                continue;
            }
            if (PersonnelStateEnum.ONLINE.equals((Object)stateEnum)) {
                this.fillOnlineTab(apiRequest, customTab, reportList);
                continue;
            }
            if (PersonnelStateEnum.SUPPORT.equals((Object)stateEnum)) {
                CustomTab.fillSupportTab((ApiRequest)apiRequest, (CustomTab)customTab, (List)reportList);
                continue;
            }
            this.fillCustomTab(apiRequest, customTab, stateEnum, reportList);
        }
    }

    private void fillCustomTab(ApiRequest apiRequest, CustomTab customTab, PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        CustomTabContentContainer content = new CustomTabContentContainer();
        content.setContentCmptType("PERSONNEL_STATE");
        content.setData((Object)this.createContent(apiRequest, stateEnum, reportList));
        customTab.setContent(Collections.singletonList(content));
        customTab.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(" + reportList.size() + ")");
    }

    private void fillOnlineTab(ApiRequest apiRequest, CustomTab customTab, List<WoOpReportInfo> woOpReportInfoList) {
        List customTabContentContainerList = woOpReportInfoList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getTeamNo)).values().stream().sorted((o1, o2) -> {
            Collator collator = "zh_CN".equalsIgnoreCase(apiRequest.getLocale()) ? Collator.getInstance(Locale.SIMPLIFIED_CHINESE) : Collator.getInstance(Locale.TRADITIONAL_CHINESE);
            return collator.compare(((WoOpReportInfo)o1.get(0)).getTeamName(), ((WoOpReportInfo)o2.get(0)).getTeamName());
        }).map(item -> {
            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
            customTabContentContainer.setContentCmptType("RETRACYABLE");
            customTabContentContainer.setData((Object)Retractable.buildRetractable((ApiRequest)apiRequest, (LocaleService)this.localeService, (List)item));
            return customTabContentContainer;
        }).collect(Collectors.toList());
        customTab.setContent(customTabContentContainerList);
        customTab.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(" + woOpReportInfoList.size() + ")");
    }

    private CustomTab buidlEmptyTab(ApiRequest apiRequest, CustomTab customTab) {
        customTab.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(0)");
        customTab.setStyle(Integer.valueOf(2));
        customTab.setAlignmentType(Integer.valueOf(1));
        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
        customTabContentContainer.setData((Object)Empty.create((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u6682\u65e0\u6570\u636e")));
        customTabContentContainer.setContentCmptType("EMPTY");
        customTab.setContent(Collections.singletonList(customTabContentContainer));
        return customTab;
    }

    private PersonnelState createContent(ApiRequest apiRequest, PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        return new PersonnelState().convert(apiRequest, this.localeService, stateEnum, reportList);
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

