/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.ksc;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem;
import com.digiwin.mobile.mobileuibot.project.strategy.ProjectDetailBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineActivity;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEnginePanelInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineTaskCode;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanelTask;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskReadCount;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildKscProjectDetailStrategy")
public class UiBotModelBuildKscProjectDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildKscProjectDetailStrategy.class);
    private static final String TASK_STATUS_NOT_STARTED = "10";
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private ProjectDetailBuildStrategyFactory projectDetailBuildStrategyFactory;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private HttpService httpService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildKscDetail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = modelTypeShow != false ? this.doShowData(pageSetting, apiRequest, stopWatch) : (useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest));
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doShowData(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        return null;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        Map<String, String> rawDataInAppbarButton;
        HashMap<String, String> buttonActionRawData;
        List buttons;
        if (pageSetting.getPageId().equalsIgnoreCase(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_NEXT_LEVEL_TASK_LIST.toString())) {
            return this.buildKscProjectNextLevelTaskList(pageSetting, apiRequest);
        }
        ApiRawData rawData = apiRequest.getRawData();
        boolean isShare = rawData.get((Object)"isShare") == null ? false : (Boolean)rawData.get((Object)"isShare");
        stopWatch.start("GetData From Athena API");
        ArrayList<Future> futureList = new ArrayList<Future>();
        Future futureTaskReadCount = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.updateDigiwinAtmcTaskReadCount(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId()));
        futureList.add(futureTaskReadCount);
        Future futureReassignReport = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId()));
        futureList.add(futureReassignReport);
        Future futureAtmcEnginePanelInfo = this.threadPoolTaskExecutor.submit(() -> this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(apiRequest.getDataId() + "", apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale()));
        futureList.add(futureAtmcEnginePanelInfo);
        DigiwinAtmcTaskReadCount atmcTaskReadCount = null;
        Object atmcBacklogReadCount = null;
        List reassignReportList = null;
        DigiwinAtmcPanel atmcPanel = null;
        DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo = null;
        try {
            block6: for (Future future : futureList) {
                while (true) {
                    if (future.isDone() && !future.isCancelled()) {
                        Object obj = future.get();
                        if (obj instanceof DigiwinAtmcTaskReadCount) {
                            atmcTaskReadCount = (DigiwinAtmcTaskReadCount)obj;
                        }
                        if (obj instanceof DigiwinAtmcPanel) {
                            atmcPanel = (DigiwinAtmcPanel)obj;
                        }
                        if (obj instanceof DigiwinAtmcEnginePanelInfo) {
                            atmcEnginePanelInfo = (DigiwinAtmcEnginePanelInfo)obj;
                        }
                        if (!(obj instanceof List)) continue block6;
                        reassignReportList = (List)obj;
                        continue block6;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        stopWatch.stop();
        Assert.notNull(atmcEnginePanelInfo, (String)"atmcEnginePanelInfo must not null!");
        Assert.notNull((Object)atmcEnginePanelInfo.getRoute(), (String)"atmcEnginePanelInfo.route must not null!");
        Assert.notNull((Object)atmcEnginePanelInfo.getTask(), (String)"atmcEnginePanelInfo.task must not null!");
        String tmTaskId = atmcEnginePanelInfo.getTask().getTmTaskId();
        List activityList = atmcEnginePanelInfo.getRoute().getSelectRoute().getActivities();
        ArrayList taskCodes = new ArrayList();
        for (DigiwinAtmcEngineActivity activity : activityList) {
            if (activity == null || activity.getTaskCodes() == null) continue;
            taskCodes.addAll(activity.getTaskCodes());
        }
        Map projectInfoDetail = this.getProjectInfo(apiRequest, atmcEnginePanelInfo);
        String projectStatus = MapUtils.getString((Map)projectInfoDetail, (Object)"project_status");
        Optional<DigiwinAtmcEngineTaskCode> taskCodeOptional = taskCodes.stream().filter(taskCode -> {
            if (Objects.equals(projectStatus, TASK_STATUS_NOT_STARTED)) {
                return "sch_maintenanceProject".equalsIgnoreCase(taskCode.getId());
            }
            return "sch_progressTrack".equalsIgnoreCase(taskCode.getId());
        }).findFirst();
        if (!taskCodeOptional.isPresent()) {
            return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
        }
        String tmActivityId = taskCodeOptional.get().getId();
        atmcPanel = new DigiwinAtmcPanel();
        atmcPanel.setTask(atmcEnginePanelInfo.getTask());
        List projectDetailDataStateList = this.digiwinPcUiBotProxyService.getProjectDetailByProjectId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId(), tmTaskId, tmActivityId);
        if (projectDetailDataStateList == null || projectDetailDataStateList.isEmpty()) {
            return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
        }
        Map projectDetailDataState = (Map)projectDetailDataStateList.get(0);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.actionShow(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)projectDetailDataState));
        Assert.notNull((Object)pcUiBotModel, (String)"project detail must have uibotmodel data!");
        stopWatch.start("Build Project-Detail Page Data");
        if ("systemCloudHouseKeeper_userProject_sch_maintenanceProject".equals(ProjectStringUtil.getProjectBuildTypeByDetailPatternCategory((String)tmTaskId, (String)tmActivityId)) && Objects.equals(projectStatus, TASK_STATUS_NOT_STARTED)) {
            pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.name());
            apiRequest.getRawData().put("projectDetailDataState", (Object)projectDetailDataState);
        }
        Map projectDetail = this.projectDetailBuildStrategyFactory.get(ProjectStringUtil.getProjectBuildTypeByDetailPatternCategory((String)tmTaskId, (String)tmActivityId)).build(apiRequest, apiRequest.getIamUserToken(), pageSetting, pcUiBotModel, atmcPanel, new Object[0]);
        stopWatch.stop();
        PccProjectInfo projectInfo = (PccProjectInfo)projectDetail.get("project_info");
        projectDetail.remove("project_info");
        stopWatch.start("Build Common Page Model");
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, (Object)projectDetail, Boolean.valueOf(true));
        stopWatch.stop();
        String athenaProjectName = Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask).map(DigiwinAtmcPanelTask::getName).orElse("");
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getLeft() != null) {
            SlipTitle slipTitle = uiBotModel.getSlip().getSlipConfig().getLeft().getSubTitle();
            slipTitle.setContent(athenaProjectName + " " + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u5f53\u524d\u6c9f\u901a"));
            SlipConfigLeft left = uiBotModel.getSlip().getSlipConfig().getLeft();
            List backlogPerformers = this.digiwinAtmcProxyService.getPerformerListByProjectId(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
            EocPersonResponse eocPersonResponse = this.digiwinEocProxyService.getSimplePersonList(apiRequest.getIamUserToken(), 9999, 1, "");
            SlipConfigLeft.setPersonListByBacklog((SlipConfigLeft)left, (List)backlogPerformers, (EocPersonResponse)eocPersonResponse);
        }
        if (atmcEnginePanelInfo != null && atmcEnginePanelInfo.getReassign() != null && !isShare) {
            buttons = uiBotModel.getAppbarButtonList();
            buttonActionRawData = new HashMap<String, String>(atmcEnginePanelInfo.getReassign());
            buttonActionRawData.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", (String)atmcEnginePanelInfo.getTask());
            buttonActionRawData.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());
            buttons.add(Button.createApprovalReassign((String)(apiRequest.getDataId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"PROJECT", (Integer)58926));
            rawDataInAppbarButton = new HashMap<String, String>(atmcEnginePanelInfo.getReassign());
            rawDataInAppbarButton.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            rawDataInAppbarButton.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());
            buttons.add(Button.createShareWithOthers((String)apiRequest.getDataId(), (Map)((Map)JsonUtil.objectToJavaObject(rawDataInAppbarButton, Map.class)), (String)apiRequest.getLocale(), (LocaleService)this.localeService));
        }
        if (atmcPanel != null && atmcPanel.getReassign() != null && !isShare) {
            buttons = uiBotModel.getAppbarButtonList();
            if (null == atmcPanel.getReassign().getReassignUsers()) {
                List batchReassignUsers = this.digiwinAtmcProxyService.batchGetProjectReassignUsers(atmcPanel.getTask(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
                atmcPanel.getReassign().setReassignUsers(batchReassignUsers);
            }
            buttonActionRawData = new HashMap((Map)JsonUtil.objectToJavaObject((Object)atmcPanel.getReassign(), Map.class));
            buttonActionRawData.put("appCode", atmcPanel.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", (String)atmcPanel.getTask());
            buttonActionRawData.put("project_type", atmcPanel.getTask().getTmTaskId());
            buttons.add(Button.createApprovalReassign((String)(apiRequest.getDataId() + ""), (Map)((Map)JsonUtil.objectToJavaObject(buttonActionRawData, Map.class)), (String)apiRequest.getLocale(), (String)"PROJECT", (Integer)58926));
            rawDataInAppbarButton = (Map)JsonUtil.objectToJavaObject((Object)atmcPanel.getReassign(), Map.class);
            rawDataInAppbarButton.put("appCode", atmcPanel.getTask().getAppCode());
            rawDataInAppbarButton.put("project_type", atmcPanel.getTask().getTmTaskId());
            buttons.add(Button.createShareWithOthers((String)apiRequest.getDataId(), (Map)((Map)JsonUtil.objectToJavaObject(rawDataInAppbarButton, Map.class)), (String)apiRequest.getLocale(), (LocaleService)this.localeService));
        }
        if (!CollectionUtils.isEmpty((Collection)reassignReportList)) {
            List layouts = uiBotModel.getLayout();
            for (UiBotLayout layout : layouts) {
                if ("TITLE_BODY".equals(layout.getType())) {
                    TitleBody titleBody = (TitleBody)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleBody.class);
                    ArrayList<Tag> tags = titleBody.getTags();
                    if (tags == null) {
                        tags = new ArrayList<Tag>();
                    } else {
                        for (Tag tag : tags) {
                            if (!LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u8f6c\u6d3e").equals(tag.getText())) continue;
                            tags.remove(tag);
                            break;
                        }
                    }
                    Tag tag = Tag.createOnlyTextStateTag((String)String.format(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u7531\u8f6c\u6d3e"), ((DigiwinReassignReport)reassignReportList.get(0)).getOldPerformerName()), (Action)Action.createReassignReportAction((String)apiRequest.getLocale(), (List)reassignReportList));
                    tags.add(tag);
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleBody);
                    break;
                }
                if ("PAGE_DESC".equals(layout.getType())) {
                    PageDesc pageDesc = (PageDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), PageDesc.class);
                    List pageDescContents = pageDesc.getContent();
                    pageDescContents.add(PageDescContent.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                    uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)pageDesc);
                }
                if (!"TITLE_DESC".equals(layout.getType())) continue;
                TitleDesc titleDesc = (TitleDesc)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layout.getSchema()), TitleDesc.class);
                List labels = titleDesc.getLabelList();
                labels.add(Label.buildReassignReport((String)apiRequest.getLocale(), (List)reassignReportList));
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleDesc);
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    private UiBotModel buildKscProjectNextLevelTaskList(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel pageModel = pageSetting.getPageModel();
        String taskNo = apiRequest.getDataId();
        String projectNo = (String)apiRequest.getRawData().get((Object)"projectNo");
        List allProjectTaskInfoList = apiRequest.getRawData().getJSONArray("data").toJavaList(PccProjectTaskInfo.class);
        for (UiBotLayout layout : pageModel.getLayout()) {
            if ("TASK_CRUMBS".equalsIgnoreCase(layout.getType())) {
                List processedTaskList = allProjectTaskInfoList.stream().filter(projectTaskInfo -> !projectTaskInfo.getTaskNo().equalsIgnoreCase(taskNo)).filter(projectTaskInfo -> projectTaskInfo.getUpperLevelTaskNo().equalsIgnoreCase(taskNo)).sorted(Comparator.comparingInt(PccProjectTaskInfo::getSequence)).collect(Collectors.toList());
                List taskItemList = processedTaskList.stream().map(projectTaskInfo -> ProjectCCTaskItem.createKsc((String)apiRequest.getLocale(), (PccProjectTaskInfo)projectTaskInfo, (List)allProjectTaskInfoList, (boolean)true, (String)apiRequest.getIamUserToken(), (String)projectNo)).collect(Collectors.toList());
                HashMap<String, Object> crumbsMap = new HashMap<String, Object>();
                crumbsMap.put("data", taskItemList);
                Optional<PccProjectTaskInfo> pccProjectTaskInfoOptional = allProjectTaskInfoList.stream().filter(projectTaskInfo -> projectTaskInfo.getTaskNo().equalsIgnoreCase(taskNo)).findFirst();
                String taskName = "";
                if (pccProjectTaskInfoOptional.isPresent()) {
                    taskName = pccProjectTaskInfoOptional.get().getTaskName();
                }
                crumbsMap.put("crumbsRoot", taskName);
                pageModel.getPageData().put((Object)layout.getSchema(), crumbsMap);
            }
            if (!"BOTTOM_BUTTON".equals(layout.getType())) continue;
            BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageModel.getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
            bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                String nameKey = bottomButtonDigiwinAthena.getName();
                bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
            });
            pageModel.getPageData().put((Object)layout.getSchema(), (Object)bottomButtonList);
        }
        return this.uiBotModelBuildService.buildModel(pageSetting, pageModel.getPageData());
    }

    private Map<String, Object> getProjectInfo(ApiRequest apiRequest, DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo) {
        String projectNo = Optional.ofNullable(atmcEnginePanelInfo.getTask()).map(DigiwinAtmcPanelTask::getSourceIds).orElse("");
        if (StringUtils.isEmpty((CharSequence)projectNo)) {
            throw new ServiceException("projectNo is empty!");
        }
        HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
        bodyPayloadMap.put("actionId", "bm.pisc.project.get");
        HashMap<String, String> projectInfoMap = new HashMap<String, String>(1);
        projectInfoMap.put("project_no", projectNo);
        HashMap parameter = new HashMap(1);
        parameter.put("project_info", Collections.singletonList(projectInfoMap));
        bodyPayloadMap.put("parameter", parameter);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", bodyPayloadMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"project_info")).map(e -> (Map)e.get(0)).orElse(Collections.emptyMap());
        }
        return Collections.emptyMap();
    }
}

