/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.pcc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccTailTaskProductItemTab;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccTailTaskProductItemTabList;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccTaskDetailSummary;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.ProcessStatusEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildPccTailTaskStrategy")
public class UiBotModelBuildPccTailTaskStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildPccTailTaskStrategy.class);
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        PccProjectTaskInfo taskInfo = (PccProjectTaskInfo)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)"taskInfo"), PccProjectTaskInfo.class);
        Boolean isPccPlan = MapUtils.getBooleanValue((Map)apiRequest.getRawData(), (Object)"isPccPlan");
        String projectNo = taskInfo.getProjectNo();
        String taskNo = taskInfo.getTaskNo();
        String taskCategory = taskInfo.getTaskCategory();
        stopWatch.start("Build PccTailTask Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            if ("PCC_TASK_DETAIL_SUMMARY".equalsIgnoreCase(layout.getType())) {
                PccTaskDetailSummary projectCCTaskItem = isPccPlan != false ? PccTaskDetailSummary.createPccPlan((String)locale, (PccProjectTaskInfo)taskInfo) : PccTaskDetailSummary.create((String)locale, (PccProjectTaskInfo)taskInfo, (boolean)true, (String)userToken, (String)projectNo);
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)projectCCTaskItem);
            }
            if (!"TABS".equalsIgnoreCase(layout.getType())) continue;
            PccTailTaskProductItemTabList pccTailTaskProductItemTabList = null;
            switch (taskCategory.toUpperCase()) {
                case "ORD": {
                    pccTailTaskProductItemTabList = this.getOrdTaskCategoryDetailData(apiRequest, taskInfo);
                    break;
                }
                case "PLM": {
                    pccTailTaskProductItemTabList = this.getPlmTaskCategoryDetailData(apiRequest, taskInfo);
                    break;
                }
                case "PLM_PROJECT": {
                    pccTailTaskProductItemTabList = this.getPlmProjectTaskCategoryDetailData(apiRequest, taskInfo);
                    break;
                }
                case "MES": {
                    pccTailTaskProductItemTabList = this.getMesTaskCategoryDetailData(apiRequest, taskInfo);
                    break;
                }
                case "REVIEW": {
                    pccTailTaskProductItemTabList = this.getReviewTaskCategoryDetailData(apiRequest, taskInfo);
                    break;
                }
                default: {
                    pccTailTaskProductItemTabList = this.getOtherTaskCategoryDetailData(apiRequest, taskInfo);
                }
            }
            uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)pccTailTaskProductItemTabList);
        }
        stopWatch.stop();
        return uiBotModel;
    }

    public List<Map<String, Object>> getDocInfoResponses(List<Map<String, Object>> docInfoResponses) {
        if (docInfoResponses.size() == 0) {
            HashMap<String, Object> docInfoMap = new HashMap<String, Object>();
            docInfoMap.put("accepted_return_qty", 0);
            docInfoMap.put("actual_finish_date", "");
            docInfoMap.put("actual_start_date", "");
            docInfoMap.put("close_status", "N");
            docInfoMap.put("complete_qty", 0);
            docInfoMap.put("complete_rate", 0);
            docInfoMap.put("contract_date", "");
            docInfoMap.put("contract_name", "");
            docInfoMap.put("contract_no", "");
            docInfoMap.put("customer_name", "");
            docInfoMap.put("delivery_qty", 0);
            docInfoMap.put("demand_date", "");
            docInfoMap.put("feed_qty", 0);
            docInfoMap.put("instalment_trans_curr_amount", 0);
            docInfoMap.put("issue_set_qty", 0);
            docInfoMap.put("item_name_spec", "\u8b8a\u58d3\u5668");
            docInfoMap.put("item_no", "2-2-31-0000210");
            docInfoMap.put("op_name", "");
            docInfoMap.put("op_type", "");
            docInfoMap.put("out_plan_time", "Y");
            docInfoMap.put("payment_method", "");
            docInfoMap.put("plan_date_e", "");
            docInfoMap.put("plan_delivery_date", "2022-04-28");
            docInfoMap.put("plan_start_date", "");
            docInfoMap.put("process_no", "");
            docInfoMap.put("process_seq", "");
            docInfoMap.put("production_qty", 0);
            docInfoMap.put("project_leader_code", "igp-13");
            docInfoMap.put("project_leader_name", "ERP\u5c08\u6848\u7d93\u7406");
            docInfoMap.put("project_name", "TY-001");
            docInfoMap.put("project_no", "TY-001");
            docInfoMap.put("purchase_no", "331-110426001");
            docInfoMap.put("purchase_qty", 1);
            docInfoMap.put("purchase_seq", "0001");
            docInfoMap.put("purchase_sub_seq", "");
            docInfoMap.put("purchaser_name", "");
            docInfoMap.put("reference_doc_no", "");
            docInfoMap.put("reference_type_no", "");
            docInfoMap.put("requisitions_no", "");
            docInfoMap.put("requisitions_qty", 0);
            docInfoMap.put("shipping_date", "");
            docInfoMap.put("shipping_qty", 0);
            docInfoMap.put("so_no", "");
            docInfoMap.put("so_qty", 0);
            docInfoMap.put("status", "N");
            docInfoMap.put("stock_in_qty", 0);
            docInfoMap.put("supplier_name", "");
            docInfoMap.put("task_no", "51");
            docInfoMap.put("trans_curr_ar_amount", 0);
            docInfoMap.put("trans_curr_received_amount", 0);
            docInfoMap.put("trans_currency", "");
            docInfoMap.put("trans_currency_name", "");
            docInfoMap.put("wo_no", "331-110426001");
            docInfoResponses.add(docInfoMap);
            HashMap<String, Object> docInfoMap1 = new HashMap<String, Object>();
            docInfoMap1.put("accepted_return_qty", 0);
            docInfoMap1.put("actual_finish_date", "");
            docInfoMap1.put("actual_start_date", "");
            docInfoMap1.put("close_status", "N");
            docInfoMap1.put("complete_qty", 0);
            docInfoMap1.put("complete_rate", 0);
            docInfoMap1.put("contract_date", "");
            docInfoMap1.put("contract_name", "");
            docInfoMap1.put("contract_no", "");
            docInfoMap1.put("customer_name", "");
            docInfoMap1.put("delivery_qty", 0);
            docInfoMap1.put("demand_date", "");
            docInfoMap1.put("feed_qty", 0);
            docInfoMap1.put("instalment_trans_curr_amount", 0);
            docInfoMap1.put("issue_set_qty", 0);
            docInfoMap1.put("item_name_spec", "\u9ad8\u58d3\u96fb\u5bb9(85\u5ea6C)100uf/400V22*30");
            docInfoMap1.put("item_no", "3-1-04-39A3-100");
            docInfoMap1.put("op_name", "");
            docInfoMap1.put("op_type", "");
            docInfoMap1.put("out_plan_time", "Y");
            docInfoMap1.put("payment_method", "");
            docInfoMap1.put("plan_date_e", "");
            docInfoMap1.put("plan_delivery_date", "2022-04-28");
            docInfoMap1.put("plan_start_date", "");
            docInfoMap1.put("process_no", "");
            docInfoMap1.put("process_seq", "");
            docInfoMap1.put("production_qty", 0);
            docInfoMap1.put("project_leader_code", "igp-13");
            docInfoMap1.put("project_leader_name", "ERP\u5c08\u6848\u7d93\u7406");
            docInfoMap1.put("project_name", "TY-001");
            docInfoMap1.put("project_no", "TY-001");
            docInfoMap1.put("purchase_no", "331-110426002");
            docInfoMap1.put("purchase_qty", 2);
            docInfoMap1.put("purchase_seq", "0002");
            docInfoMap1.put("purchase_sub_seq", "");
            docInfoMap1.put("purchaser_name", "");
            docInfoMap1.put("reference_doc_no", "");
            docInfoMap1.put("reference_type_no", "");
            docInfoMap1.put("requisitions_no", "");
            docInfoMap1.put("requisitions_qty", 0);
            docInfoMap1.put("shipping_date", "");
            docInfoMap1.put("shipping_qty", 0);
            docInfoMap1.put("so_no", "");
            docInfoMap1.put("so_qty", 0);
            docInfoMap1.put("status", "N");
            docInfoMap1.put("stock_in_qty", 0);
            docInfoMap1.put("supplier_name", "");
            docInfoMap1.put("task_no", "51");
            docInfoMap1.put("trans_curr_ar_amount", 0);
            docInfoMap1.put("trans_curr_received_amount", 0);
            docInfoMap1.put("trans_currency", "");
            docInfoMap1.put("trans_currency_name", "");
            docInfoMap1.put("wo_no", "331-110426002");
            docInfoResponses.add(docInfoMap1);
        }
        return docInfoResponses;
    }

    private PccTailTaskProductItemTabList getOrdTaskCategoryDetailData(ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();
        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        List projectProjectInfoRequestList = this.digiwinEspProxyService.getTaskInfo(apiRequest.getIamUserToken(), taskInfo.getProjectNo(), taskInfo.getTaskNo(), apiRequest.getTenantId(), apiRequest.getLocale());
        List pendingResponses = this.digiwinEspProxyService.getTaskInfo(eocSiteId, eocCompanyId, projectProjectInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());
        String pendingTabName = "\u5f85\u5904\u7406";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.create((String)pendingTabName, (List)pendingResponses, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)pendingTab);
        List completedResponses = this.digiwinEspProxyService.getTaskInfo(eocSiteId, eocCompanyId, projectProjectInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());
        String completedTabName = "\u5df2\u5b8c\u6210";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.create((String)completedTabName, (List)completedResponses, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)completedTab);
        return pccTailTaskProductItemTabList;
    }

    private PccTailTaskProductItemTabList getPlmTaskCategoryDetailData(ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();
        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        List taskInfoList = this.digiwinEspProxyService.getTaskInfo(apiRequest.getIamUserToken(), taskInfo.getProjectNo(), taskInfo.getTaskNo(), apiRequest.getTenantId(), apiRequest.getLocale());
        List todoWorkItemDataList = this.digiwinEspProxyService.getWorkItemData(eocSiteId, eocCompanyId, taskInfoList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());
        List doneWorkItemDataList = this.digiwinEspProxyService.getWorkItemData(eocSiteId, eocCompanyId, taskInfoList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());
        String pendingTabName = "\u5f85\u5904\u7406";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.create((String)pendingTabName, (List)todoWorkItemDataList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)pendingTab);
        String completedTabName = "\u5df2\u5b8c\u6210";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.create((String)completedTabName, (List)doneWorkItemDataList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)completedTab);
        return pccTailTaskProductItemTabList;
    }

    private PccTailTaskProductItemTabList getPlmProjectTaskCategoryDetailData(ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();
        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        String TASK_STATUS_DOING = "30";
        String TASK_STATUS_COMPLETED = "40";
        String TASK_STATUS_PAUSED = "50";
        String TASK_STATUS_ASSIGNED_COMPLETED = "60";
        List taskInfoList = this.digiwinEspProxyService.getTaskInfo(apiRequest.getIamUserToken(), taskInfo.getProjectNo(), taskInfo.getTaskNo(), apiRequest.getTenantId(), apiRequest.getLocale());
        List itemDataList = this.digiwinEspProxyService.getProjectTaskCompleteRateData(eocSiteId, eocCompanyId, taskInfoList, userToken, tenantId, locale);
        ArrayList todoTaskList = new ArrayList();
        ArrayList doneTaskList = new ArrayList();
        itemDataList.forEach(map -> {
            String taskStatus = map.getOrDefault("task_status", "");
            if (taskStatus.equals("30") || taskStatus.equals("50")) {
                todoTaskList.add(map);
            } else if (taskStatus.equals("40") || taskStatus.equals("60")) {
                doneTaskList.add(map);
            }
        });
        String pendingTabName = "\u5f85\u5904\u7406";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.create((String)pendingTabName, todoTaskList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)pendingTab);
        String completedTabName = "\u5df2\u5b8c\u6210";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.create((String)completedTabName, doneTaskList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)completedTab);
        return pccTailTaskProductItemTabList;
    }

    private PccTailTaskProductItemTabList getMesTaskCategoryDetailData(ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();
        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        List projectWoProductionInfoRequestList = this.digiwinEspProxyService.getTaskInfo(apiRequest.getIamUserToken(), taskInfo.getProjectNo(), taskInfo.getTaskNo(), apiRequest.getTenantId(), apiRequest.getLocale());
        List todoItemDataList = this.digiwinEspProxyService.getProjectWoProductionInfoProcess(eocSiteId, eocCompanyId, projectWoProductionInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());
        List doneItemDataList = this.digiwinEspProxyService.getProjectWoProductionInfoProcess(eocSiteId, eocCompanyId, projectWoProductionInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.create((String)"\u5f85\u5904\u7406", (List)todoItemDataList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)pendingTab);
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.create((String)"\u5df2\u5b8c\u6210", (List)doneItemDataList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)completedTab);
        return pccTailTaskProductItemTabList;
    }

    private PccTailTaskProductItemTabList getReviewTaskCategoryDetailData(ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();
        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        List projectProjectInfoRequestList = this.digiwinEspProxyService.getTaskInfo(apiRequest.getIamUserToken(), taskInfo.getProjectNo(), taskInfo.getTaskNo(), apiRequest.getTenantId(), apiRequest.getLocale());
        List pendingResponses = this.digiwinEspProxyService.getTaskInfo(eocSiteId, eocCompanyId, projectProjectInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());
        String pendingTabName = "\u5f85\u5904\u7406";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.create((String)pendingTabName, (List)pendingResponses, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)pendingTab);
        List completedResponses = this.digiwinEspProxyService.getTaskInfo(eocSiteId, eocCompanyId, projectProjectInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());
        String completedTabName = "\u5df2\u5b8c\u6210";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.create((String)completedTabName, (List)completedResponses, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)completedTab);
        return pccTailTaskProductItemTabList;
    }

    private PccTailTaskProductItemTabList getOtherTaskCategoryDetailData(ApiRequest apiRequest, PccProjectTaskInfo taskInfo) {
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();
        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        List projectDocInfoRequestList = this.digiwinEspProxyService.getTaskInfo(apiRequest.getIamUserToken(), taskInfo.getProjectNo(), taskInfo.getTaskNo(), apiRequest.getTenantId(), apiRequest.getLocale());
        List todoItemList = this.digiwinEspProxyService.getProjectDocInfoProcess(eocSiteId, eocCompanyId, projectDocInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());
        List doneItemList = this.digiwinEspProxyService.getProjectDocInfoProcess(eocSiteId, eocCompanyId, projectDocInfoRequestList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());
        String pendingTabName = "\u5f85\u5904\u7406";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.create((String)pendingTabName, (List)todoItemList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)pendingTab);
        String completedTabName = "\u5df2\u5b8c\u6210";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.create((String)completedTabName, (List)doneItemList, (String)taskCategory, (ApiRequest)apiRequest, (PccProjectTaskInfo)taskInfo);
        pccTailTaskProductItemTabList.add((Object)completedTab);
        return pccTailTaskProductItemTabList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        PccProjectTaskInfo taskInfo = (PccProjectTaskInfo)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)"taskInfo"), PccProjectTaskInfo.class);
        String taskCategory = taskInfo.getTaskCategory();
        String data = "PO".equalsIgnoreCase(taskCategory) ? FileUtil.readText((String)"static/tail_task_detail_with_material.json") : FileUtil.readText((String)"static/tail_task_detail_without_material.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

