/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgressList;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.GeneralPageTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="uiBotModelDesignerMultipleDataSources")
public class UiBotModelDesignerMultipleDataSources {
    public static final String VSS_STOCK_ALERT = "vss_stock_alert";
    public static final String VSS_ORDER_ALERT = "vss_order_alert";
    private static GeneralPageTemplate generalPageTemplate;
    private static DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    public UiBotModelDesignerMultipleDataSources(GeneralPageTemplate generalPageTemplate, DigiwinEspProxyService digiwinEspProxyService) {
        UiBotModelDesignerMultipleDataSources.generalPageTemplate = generalPageTemplate;
        UiBotModelDesignerMultipleDataSources.digiwinEspProxyService = digiwinEspProxyService;
    }

    public static void handleMultipleDataSources(PcUiBotTmActivity tmActivity) {
        if (!StringUtils.isEmpty((CharSequence)AppRequestContext.getContextEntity().getPageId())) {
            String pageId = AppRequestContext.getContextEntity().getPageId();
            if (ObjectUtils.isEmpty((Object)tmActivity) || ObjectUtils.isEmpty((Object)tmActivity.getPages())) {
                return;
            }
            List dataStates = tmActivity.getPages().getDataStates();
            for (PcUiBotTmDataState dataState : dataStates) {
                if (CollectionUtils.isEmpty((Collection)dataState.getPageLayout())) continue;
                for (UiBotPageLayout uiBotPageLayout : dataState.getPageLayout()) {
                    if (CollectionUtils.isEmpty((Collection)uiBotPageLayout.getBody()) || !pageId.equalsIgnoreCase(uiBotPageLayout.getPageId())) continue;
                    for (BaseMobileComponentWrapper componentWrapper : uiBotPageLayout.getBody()) {
                        String componentType;
                        if (ObjectUtils.isEmpty((Object)componentWrapper) || !"DW_TASK_PROGRESS_LIST".equals(componentType = componentWrapper.getComponentType())) continue;
                        TaskProgressList taskProgressList = (TaskProgressList)JsonUtil.objectToJavaObject((Object)componentWrapper.getData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                        if (ObjectUtils.isEmpty((Object)taskProgressList)) {
                            return;
                        }
                        if (CollectionUtils.isEmpty((Collection)taskProgressList.getTaskProgressList())) {
                            return;
                        }
                        for (TaskProgress taskProgress : taskProgressList.getTaskProgressList()) {
                            if (CollectionUtils.isEmpty((Collection)taskProgress.getPersonList())) {
                                return;
                            }
                            tmActivity.getPages().setDataSourceName(taskProgress.getDataSource().getActionName());
                            dataState.getDataFilter().setApiCondition(new ArrayList());
                            AppRequestContext.getContextEntity().setDataSourceName(taskProgress.getDataSource().getActionName());
                        }
                    }
                }
            }
        }
    }

    public static void handleDataSourceParas(PcUiBotDataSourceSetDTO dataSourceSet, ApiRequest apiRequest) {
        if (ObjectUtils.isEmpty((Object)apiRequest.getRawData().get((Object)"data"))) {
            return;
        }
        dataSourceSet.getDataSourceList().forEach(dataSource -> {
            PcUiBotActionParameterMapping mapping;
            if (ObjectUtils.isNotEmpty((Object)dataSource.getAction()) && !CollectionUtils.isEmpty((Collection)dataSource.getAction().getActionParams()) && (mapping = (PcUiBotActionParameterMapping)dataSource.getAction().getActionParams().get(0)).getValue().contains(",")) {
                List stringList = Arrays.stream(mapping.getValue().split(",")).map(String::valueOf).collect(Collectors.toList());
                HashMap map = new HashMap(1);
                ArrayList<Map> list = new ArrayList<Map>(1);
                Map dataMap = (Map)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)"data"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                Map info = stringList.stream().collect(Collectors.toMap(s -> s, dataMap::get, (a, b) -> b, () -> new HashMap(6)));
                list.add(info);
                map.put(mapping.getName(), list);
                dataSource.getAction().getParas().putAll(map);
            }
        });
    }

    public static void queryMetadataMultipleSources(AbstractEntity absEntity, List<PcUiBotTaskPageDefine> pageDefines) {
        PcUiBotActionParameterMapping mapping;
        PcUiBotDataSourceDTO dataSource;
        if (StringUtil.isNotEmpty((CharSequence)AppRequestContext.getContextEntity().getDataSourceName()) && ObjectUtils.isNotEmpty((Object)(dataSource = (PcUiBotDataSourceDTO)pageDefines.get(0).getDataSourceSet().getDataSourceList().get(0)).getAction()) && !CollectionUtils.isEmpty((Collection)dataSource.getAction().getActionParams()) && (mapping = (PcUiBotActionParameterMapping)dataSource.getAction().getActionParams().get(0)).getValue().contains(",")) {
            UiBotModelDesignerMultipleDataSources.handleMultipleDataSources((AbstractEntity)absEntity, (PcUiBotTaskPageDefine)pageDefines.get(0));
        }
    }

    public static void handleMultipleDataSources(AbstractEntity absEntity, PcUiBotTaskPageDefine pageDefines) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        UiBotModel uiBotModel = absEntity.getUiBotModel();
        QueryResultSet queryResultSet = generalPageTemplate.BuildDataSource(executeContext, (PcUiBotPageDefine)pageDefines, uiBotModel, apiRequest);
        HashMap<String, List> rawMap = new HashMap<String, List>();
        rawMap.put(queryResultSet.getDataSourceNameFromApiResp(), queryResultSet.getQueryResultData());
        apiRequest.getRawData().put("rawDataType", (Object)"array");
        apiRequest.getRawData().put("data", rawMap);
        apiRequest.getRawData().put("rawMap", rawMap);
    }

    public static void handleVssTask(ApiRequest apiRequest, PcUiBotExecuteContext executeContext) {
        if ("vss_stock_alert".equalsIgnoreCase(executeContext.getTmActivityId()) || "vss_order_alert".equalsIgnoreCase(executeContext.getTmActivityId())) {
            List params = null;
            if ("vss_stock_alert".equalsIgnoreCase(executeContext.getTmActivityId())) {
                params = (List)JsonUtil.objectToJavaObject(executeContext.getBpmData().get("stockAlertParams"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            if ("vss_order_alert".equalsIgnoreCase(executeContext.getTmActivityId())) {
                params = (List)JsonUtil.objectToJavaObject(executeContext.getBpmData().get("orderAlertParams"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            digiwinEspProxyService.updateTaskWarnInvImsc(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        }
    }
}

