/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.dashboard;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfig;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardContentBuildStrategy;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="reportDashboardContentBuildStrategy")
public class ReportDashboardContentBuildStrategy
implements DashboardContentBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ReportDashboardContentBuildStrategy.class);

    public String getType() {
        return "REPORT";
    }

    public CustomContent buildDashboardContent(String iamUserToken, String locale, String clientId, MobileAppConfig mobileAppConfig, boolean recommend) {
        String companyId = mobileAppConfig.getCompanyId();
        if ("1000".equals(companyId)) {
            return this.getDigiwinReportContent(iamUserToken, locale, clientId, mobileAppConfig, recommend);
        }
        return null;
    }

    @NotNull
    private CustomContent getDigiwinReportContent(String iamUserToken, String locale, String clientId, MobileAppConfig mobileAppConfig, boolean recommend) {
        String goodsCode = mobileAppConfig.getAppCode();
        String serviceUrl = "";
        boolean getReportInOldWay = true;
        if ("PCC".equals(goodsCode) || "PCM".equals(goodsCode)) {
            serviceUrl = AppContext.getApiUrlSetting().getTbbApiUrl() + "/tbb-system/app_guide/panel";
        } else {
            getReportInOldWay = false;
            serviceUrl = AppContext.getApiUrlSetting().getKnowledgeMapsUrl() + "/knowledgegraph" + "/task/tBBReports?mode=mobile&productCode=" + goodsCode;
        }
        CustomContent customContent = null;
        try {
            customContent = CustomContent.create((String)locale, (String)clientId, (String)iamUserToken, (String)goodsCode, (String)(AppContext.getBaseUrl() + "/mobile/v1/uibot/customcontent/outer?locale=" + locale + "&useDap=true&getReportInOldWay=" + getReportInOldWay + "&serviceUrl=" + URLEncoder.encode(serviceUrl, "utf-8")), (boolean)recommend);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UrlEncode Error...Msg is {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return customContent == null ? CustomContent.createEmpty() : customContent;
    }
}

