/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.dashboard.controller;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.dashboard.model.ModuleItemGroupByApp;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleQueryListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.request.DashBoardModuleUpdateListRequest;
import com.digiwin.mobile.mobileuibot.dashboard.service.DashBoardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.machinePreset.service.MachinePresetService;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v2/dashboard"})
public class DashBoardController {
    private static final Logger log = LoggerFactory.getLogger(DashBoardController.class);
    @Autowired
    MachinePresetService machinePresetService;
    @Autowired
    DigiwinSemcProxyService semcProxyService;
    @Autowired
    private DashBoardService dashBoardService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/dataEntry/async"})
    public ApiResponse<UiBotModel> dataEntryAsync(@RequestBody CustomContentRequest customContentRequest) {
        UiBotModel uiBotModel = this.dashBoardService.dataEntryAsync(customContentRequest);
        return ApiResponse.buildOK().setData((Object)uiBotModel);
    }

    @PostMapping(value={"/smartMachine/async"})
    public ApiResponse<UiBotModel> smartMachineAsync(@RequestBody CustomContentRequest customContentRequest) {
        UiBotModel uiBotModel = this.dashBoardService.smartMachineAsync(customContentRequest);
        return ApiResponse.buildOK().setData((Object)uiBotModel);
    }

    @PostMapping(value={"/module/list/get"})
    public ApiResponse<List<ModuleItemGroupByApp>> getModuleList(@RequestBody DashBoardModuleQueryListRequest dashBoardModuleQueryListRequest) {
        List moduleItemGroupByAppList = this.dashBoardService.getModuleList(dashBoardModuleQueryListRequest);
        return ApiResponse.buildOK().setData((Object)moduleItemGroupByAppList);
    }

    @PostMapping(value={"/module/list/update"})
    public ApiResponse getModuleList(@RequestBody DashBoardModuleUpdateListRequest dshBoardModuleUpdateListRequest) {
        boolean isSuccess = this.dashBoardService.updateModuleInfo(dshBoardModuleUpdateListRequest);
        Action action = new Action();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        String toastMsg = "\u4fdd\u5b58" + (BooleanUtils.isTrue((Boolean)isSuccess) ? "\u6210\u529f" : "\u5931\u8d25");
        action.setToastMsg(this.localeService.getLanguageValue(dshBoardModuleUpdateListRequest.getLocale(), toastMsg));
        return ApiResponse.buildOK().setData((Object)action);
    }
}

