/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.CustomPatternTaskTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.DesignerService;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerDataSource;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsRuleQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.test.TestV1ToV2Util;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="designerService")
public class DesignerServiceImpl
implements DesignerService {
    private static final Logger log = LoggerFactory.getLogger(DesignerServiceImpl.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    private final UiBotDesignerService uiBotDesignerService;
    private final ActivityFilterService activityFilterService;

    public DesignerServiceImpl(DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService, UiBotDesignerService uiBotDesignerService, ActivityFilterService activityFilterService) {
        this.digiwinKnowledgeMapsProxyService = digiwinKnowledgeMapsProxyService;
        this.uiBotDesignerService = uiBotDesignerService;
        this.activityFilterService = activityFilterService;
    }

    public UiBotModel integrateTaskDetailWithUiBotDesigner(ApiRequest apiRequest, UiBotModel unprocessedUiBotModel) {
        UiBotModel result = unprocessedUiBotModel;
        UiBotDesignerConfig uiBotDesignerConfig = apiRequest.getPatternTaskInfo().getUiBotDesignerConfig();
        if (uiBotDesignerConfig == null) {
            return result;
        }
        if (!uiBotDesignerConfig.getInitialized().booleanValue()) {
            return result;
        }
        this.uiBotDesignerService.applyFieldAndOrder(result, uiBotDesignerConfig);
        this.uiBotDesignerService.applyFieldTag(result, uiBotDesignerConfig);
        this.uiBotDesignerService.applyFieldRule(result, uiBotDesignerConfig);
        this.uiBotDesignerService.applyFieldOperation(result, uiBotDesignerConfig);
        return result;
    }

    public UiBotDesignerConfig initPatternTaskInfoWithUiBotDesigner(ApiRequest apiRequest, String tmTaskId, String tmActivityId, Boolean systemDefault, String appCode) {
        UiBotDesignerConfig uiBotDesignerConfig = apiRequest.getPatternTaskInfo().getUiBotDesignerConfig();
        if (null != uiBotDesignerConfig) {
            return uiBotDesignerConfig;
        }
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        uiBotDesignerConfig = this.getTaskDetailUiBotDesignerConfig(apiRequest, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), tmTaskId, tmActivityId, tenantVersion, appCode);
        apiRequest.getPatternTaskInfo().setUiBotDesignerConfig(uiBotDesignerConfig);
        if (Boolean.TRUE.equals(systemDefault)) {
            if (uiBotDesignerConfig.getPageInitialized().booleanValue()) {
                if (uiBotDesignerConfig.isCustomize().booleanValue()) {
                    apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_TRUE);
                } else {
                    apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_FALSE);
                }
            } else if (uiBotDesignerConfig.isPcCustomize().booleanValue()) {
                apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE);
            } else {
                apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_FALSE);
            }
        }
        String type = MobileDesignerConfigTypeEnum.TASK.getValue();
        String tempActivityId = apiRequest.getExtraParameter().getTmActivityId();
        String bindFormFormCode = uiBotDesignerConfig.getBindFormFormCode();
        if (StringUtils.hasLength((String)bindFormFormCode)) {
            tempActivityId = bindFormFormCode;
            type = MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue();
        }
        if (StringUtils.hasLength((String)(appCode = uiBotDesignerConfig.getAppCode())) && BooleanUtils.isTrue((Boolean)this.activityFilterService.isExsitTmActivityIdOfMobileDesignerConfig(appCode, tempActivityId, type, apiRequest.getTenantId(), tenantVersion)) || this.checkNaNa(apiRequest).booleanValue()) {
            apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_FALSE);
            if (TaskStringUtil.isBizSmartAdjust((String)tempActivityId) && !uiBotDesignerConfig.isExistMobileLayOut()) {
                apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_FALSE);
            }
        } else if (CustomPatternTaskTypeEnum.EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_FALSE.equals((Object)apiRequest.getPatternTaskInfo().getCustomPatternTaskType())) {
            if (apiRequest.getPatternTaskInfo().getUiBotDesignerConfig().isPcCustomize().booleanValue()) {
                apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE);
            } else {
                apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.DEFAULT);
            }
        }
        TestV1ToV2Util.handleV1ToV2((ApiRequest)apiRequest, (String)tempActivityId);
        return uiBotDesignerConfig;
    }

    private Boolean checkNaNa(ApiRequest apiRequest) {
        return SsoSourceTypeEnum.NANA_MESSAGE.getSource().equals(apiRequest.getSourceType());
    }

    private UiBotDesignerConfig getTaskDetailUiBotDesignerConfig(ApiRequest apiRequest, String locale, String iamUserToken, String tenantId, String tmTaskId, String tmActivityId, String tenantVersion, String appCode) {
        UiBotDesignerConfig result = new UiBotDesignerConfig();
        CountDownLatch countDownLatch = new CountDownLatch(4);
        ArrayList futureList = new ArrayList();
        CompletableFuture<Void> mobileCompletableFuture = CompletableFuture.runAsync(() -> {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("taskId", tmTaskId);
            uriVariables.put("activityId", tmActivityId);
            uriVariables.put("pageCode", "task-detail-mobile");
            DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId)).uriVariables(uriVariables).build();
            KnowledgeMapsActivityDefinition rawActivityDefinition = this.digiwinKnowledgeMapsProxyService.getActivityDefinition(athenaApiRequest);
            if (null != rawActivityDefinition) {
                result.setRawTaskActivityDefinition(rawActivityDefinition);
                result.initPage();
                result.initDataSource();
            }
        }, (Executor)this.threadPoolTaskExecutor);
        if (StringUtils.hasLength((String)appCode) && BooleanUtils.isTrue((Boolean)this.activityFilterService.isExsitTmActivityIdOfMobileDesignerConfig(appCode, tmActivityId, MobileDesignerConfigTypeEnum.TASK.getValue(), tenantId, tenantVersion)) || this.checkNaNa(apiRequest).booleanValue()) {
            mobileCompletableFuture.join();
            return result;
        }
        CompletableFuture<Void> pcCompletableFuture = CompletableFuture.runAsync(() -> {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("taskId", tmTaskId);
            uriVariables.put("activityId", tmActivityId);
            uriVariables.put("pageCode", "task-detail");
            DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId)).uriVariables(uriVariables).build();
            KnowledgeMapsActivityDefinition rawActivityDefinition = this.digiwinKnowledgeMapsProxyService.getActivityDefinition(athenaApiRequest);
            if (null != rawActivityDefinition) {
                result.setPcRawTaskActivityDefinition(rawActivityDefinition);
                result.initPcPage();
            }
        }, (Executor)this.threadPoolTaskExecutor);
        CompletableFuture.allOf(mobileCompletableFuture, pcCompletableFuture).join();
        if (Boolean.FALSE.equals(result.getPageInitialized())) {
            return result;
        }
        String resourceId = Optional.ofNullable(result.getDataSource()).map(UiBotDesignerDataSource::getActionId).orElse("");
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId)).uriVariables("actionId", resourceId).build();
            KnowledgeMapsActionMetadataQueryResult rawMetadataQueryResult = this.digiwinKnowledgeMapsProxyService.actionMetadata(athenaApiRequest);
            if (null != rawMetadataQueryResult) {
                result.setRawActionMetadata(rawMetadataQueryResult);
                result.initActionResponseMetadata();
            }
        }, (Executor)this.threadPoolTaskExecutor).thenRunAsync(() -> {
            DigiwinAthenaApiRequest athenaApiRequest = this.buildRequestForGetTagQueryResult(locale, iamUserToken, tenantId, tmTaskId, tmActivityId, resourceId, "performer");
            List rawTagQueryResults = this.digiwinKnowledgeMapsProxyService.getTagQueryResult(athenaApiRequest);
            if (null != rawTagQueryResults) {
                result.setRawFieldTags(rawTagQueryResults);
                result.initFieldTag();
            }
        }, (Executor)this.threadPoolTaskExecutor)).thenRunAsync(() -> {
            HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
            map.put("include", Lists.newArrayList((Object[])new String[]{"contentMobile"}));
            DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId)).bodyPayloadMap("activityId", (Object)tmActivityId).bodyPayloadMap("count", (Object)-1).bodyPayloadMap("features", map).build();
            KnowledgeMapsRuleQueryResult ruleQueryResult = this.digiwinKnowledgeMapsProxyService.getRuleQueryResult(athenaApiRequest);
            if (null != ruleQueryResult) {
                result.setRawRule(ruleQueryResult);
            }
        }, (Executor)this.threadPoolTaskExecutor)).whenComplete((a, throwable) -> {
            result.initDesignerConfig();
            log.debug("DesignerConfig inited!!!");
        })).join();
        return result;
    }

    private UiBotDesignerConfig getProjectDetailUiBotDesignerConfig(String locale, String iamUserToken, String tenantId, String tmTaskId, String tmActivityId) {
        return null;
    }

    private DigiwinAthenaApiRequest buildRequestForGetTagQueryResult(String locale, String iamUserToken, String tenantId, String tmTaskId, String tmActivityId, String resourceId, String detailType) {
        ArrayList<String> relationIds = new ArrayList<String>(2);
        relationIds.add(detailType);
        relationIds.add(tmActivityId);
        HashMap<String, String> features = new HashMap<String, String>(1);
        features.put("deviceType", "mobile");
        return DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", locale, iamUserToken, tenantId)).bodyPayloadMap("resourceId", (Object)resourceId).bodyPayloadMap("relationIds", relationIds).bodyPayloadMap("features", features).build();
    }
}

