/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.DesignerConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerActionMetadataElement;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerDataSource;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerDataSourceMap;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerFieldTagConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerRuleConfig;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageDataState;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.UiBotDesignerPage;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsRuleContent;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsRuleQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsTagQueryResourceContent;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsTagQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataElement;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.metadata.KnowledgeMapsActionMetadataResponse;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UiBotDesignerConfig
extends DesignerConfig {
    private static final Logger log = LoggerFactory.getLogger(UiBotDesignerConfig.class);
    private static final long serialVersionUID = -8115122632007551011L;
    private Boolean initialized = false;
    private MobileLayoutTypeEnum mobileLayoutType;
    private UiBotDesignerPage page;
    private Boolean pageInitialized = false;
    private UiBotDesignerPage pcPage;
    private Boolean pcPageInitialized = false;
    private UiBotDesignerDataSource dataSource;
    private UiBotDesignerDataSourceMap dataSourceMap;
    private Boolean dataSourceInitialized = false;
    private List<UiBotDesignerFieldTagConfig> tagConfigs;
    private Boolean tagInitialized = false;
    private List<UiBotDesignerRuleConfig> ruleConfigs;
    private Boolean ruleInitialized = false;
    private UiBotDesignerActionMetadataElement actionResponseMetadata;
    private Boolean actionResponseMetadataInitialized = false;
    private KnowledgeMapsActivityDefinition rawTaskActivityDefinition;
    private KnowledgeMapsActivityDefinition pcRawTaskActivityDefinition;
    private List<KnowledgeMapsTagQueryResult> rawFieldTags;
    private KnowledgeMapsRuleQueryResult rawRule;
    private KnowledgeMapsActionMetadataQueryResult rawActionMetadata;
    public static final String DESIGNER_FIELD_SPLITTER = ".";

    public void initDesignerConfig() {
        if (null == this.page) {
            this.initPage();
        }
        if (null == this.pcPage) {
            this.initPcPage();
        }
        if (null == this.dataSource) {
            this.initDataSource();
        }
        if (null == this.tagConfigs) {
            this.initFieldTag();
        }
        if (null == this.ruleConfigs) {
            this.initRule();
        }
        if (null == this.actionResponseMetadata) {
            this.initActionResponseMetadata();
        }
        this.initialized = this.pageInitialized != false && this.dataSourceInitialized != false && this.tagInitialized != false && this.ruleInitialized != false && this.actionResponseMetadataInitialized != false;
    }

    public boolean isExistMobileLayOut() {
        if (Boolean.FALSE.equals(this.pageInitialized)) {
            return false;
        }
        List dataStates = Optional.ofNullable(this.page).map(UiBotDesignerPage::getDataStates).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)dataStates)) {
            return false;
        }
        for (PageDataState dataState : dataStates) {
            if (CollectionUtils.isEmpty((Collection)dataState.getLayout())) continue;
            return true;
        }
        return false;
    }

    public String getBindFormFormCode() {
        if (this.rawTaskActivityDefinition == null) {
            return null;
        }
        String pattern = this.rawTaskActivityDefinition.getString("pattern");
        String category = this.rawTaskActivityDefinition.getString("category");
        if (!StringUtils.hasLength((String)pattern) || !StringUtils.hasLength((String)category)) {
            return null;
        }
        if (!TaskStringUtil.isBizDataEntryDriven((String)pattern, (String)category)) {
            return null;
        }
        JSONObject bindForm = this.rawTaskActivityDefinition.getJSONObject("bindForm");
        if (CollectionUtils.isEmpty((Map)bindForm)) {
            return null;
        }
        return bindForm.getString("formCode");
    }

    public String getAppCode() {
        if (this.rawTaskActivityDefinition == null) {
            return null;
        }
        return this.rawTaskActivityDefinition.getString("application");
    }

    public Boolean isCustomize() {
        if (Boolean.FALSE.equals(this.pageInitialized)) {
            return false;
        }
        return Optional.ofNullable(this.page).map(UiBotDesignerPage::getIsCustomize).orElse(false);
    }

    public Boolean isPcCustomize() {
        if (Boolean.FALSE.equals(this.pcPageInitialized)) {
            return false;
        }
        return Optional.ofNullable(this.pcPage).map(UiBotDesignerPage::getIsCustomize).orElse(false);
    }

    private void selectMobileLayoutType() {
    }

    public void initPage() {
        if (null == this.rawTaskActivityDefinition) {
            return;
        }
        JSONObject rawPage = this.rawTaskActivityDefinition.getJSONObject("pages");
        if (null == rawPage) {
            log.error("Athena-KM returned NULL pages, PLZ CHECK THEM. No-More process will be done !");
            return;
        }
        UiBotDesignerPage uiBotDesignerPage = (UiBotDesignerPage)JsonUtil.objectToJavaObject((Object)rawPage, UiBotDesignerPage.class);
        uiBotDesignerPage.initDesignerPageConfig();
        this.page = uiBotDesignerPage;
        this.pageInitialized = true;
    }

    public void initPcPage() {
        if (null == this.pcRawTaskActivityDefinition) {
            return;
        }
        JSONObject rawPage = this.pcRawTaskActivityDefinition.getJSONObject("pages");
        if (null == rawPage) {
            log.error("Athena-KM returned NULL pages, PLZ CHECK THEM. No-More process will be done !");
            return;
        }
        UiBotDesignerPage uiBotDesignerPage = (UiBotDesignerPage)JsonUtil.objectToJavaObject((Object)rawPage, UiBotDesignerPage.class);
        uiBotDesignerPage.initDesignerPageConfig();
        this.pcPage = uiBotDesignerPage;
        this.pcPageInitialized = true;
    }

    public void initDataSource() {
        UiBotDesignerDataSourceMap uiBotDesignerDataSourceMap;
        if (null == this.rawTaskActivityDefinition) {
            return;
        }
        JSONObject rawDataSourceMap = this.rawTaskActivityDefinition.getJSONObject("dataSources");
        if (null == rawDataSourceMap) {
            log.error("Athena-KM returned NULL/EMPTY dataSources, PLZ CHECK THEM!");
            return;
        }
        this.dataSourceMap = uiBotDesignerDataSourceMap = (UiBotDesignerDataSourceMap)JsonUtil.objectToJavaObject((Object)rawDataSourceMap, UiBotDesignerDataSourceMap.class);
        Set dataSourceEntry = uiBotDesignerDataSourceMap.entrySet();
        UiBotDesignerDataSource targetDataSource = null;
        String dataSourceDesignId = "";
        int i = 0;
        for (Map.Entry entry : dataSourceEntry) {
            if (i == 1) break;
            dataSourceDesignId = (String)entry.getKey();
            targetDataSource = (UiBotDesignerDataSource)entry.getValue();
            ++i;
        }
        if (null != targetDataSource) {
            targetDataSource.setDataSourceKeyInDesigner(dataSourceDesignId);
            this.dataSource = targetDataSource;
            this.dataSourceInitialized = true;
        }
    }

    public void initFieldTag() {
        if (null == this.rawFieldTags) {
            return;
        }
        if (null == this.tagConfigs) {
            this.tagConfigs = new ArrayList(this.rawFieldTags.size());
        }
        String actionId = this.dataSource.getActionId();
        String serviceName = this.dataSource.getServiceName();
        String key = this.dataSource.getDataSourceKeyInDesigner();
        String prefix = actionId + DESIGNER_FIELD_SPLITTER + "response" + DESIGNER_FIELD_SPLITTER + key + DESIGNER_FIELD_SPLITTER;
        for (KnowledgeMapsTagQueryResult rawFieldTag : this.rawFieldTags) {
            String fieldId = Optional.ofNullable(rawFieldTag.getResourceContent()).map(KnowledgeMapsTagQueryResourceContent::getResponse).orElse("").substring(prefix.length());
            UiBotDesignerFieldTagConfig fieldTagConfig = new UiBotDesignerFieldTagConfig();
            fieldTagConfig.setEspFieldId(fieldId);
            fieldTagConfig.setEspServiceName(serviceName);
            fieldTagConfig.setTags(rawFieldTag.getTags());
            this.tagConfigs.add(fieldTagConfig);
        }
        this.tagInitialized = true;
    }

    public void initRule() {
        if (null == this.rawRule) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.rawRule.getRules())) {
            return;
        }
        if (null == this.ruleConfigs) {
            this.ruleConfigs = new ArrayList(this.rawRule.getRules().size());
        }
        for (KnowledgeMapsRuleContent rule : this.rawRule.getRules()) {
            UiBotDesignerRuleConfig ruleConfig = new UiBotDesignerRuleConfig();
            ruleConfig.setContentMobile(rule.getContentMobile());
            this.ruleConfigs.add(ruleConfig);
        }
        this.ruleInitialized = true;
    }

    public void initActionResponseMetadata() {
        if (null == this.rawActionMetadata) {
            return;
        }
        Optional<KnowledgeMapsActionMetadataElement> optResponseData = Optional.ofNullable(this.rawActionMetadata.getResponse()).map(KnowledgeMapsActionMetadataResponse::getData);
        if (optResponseData.isPresent()) {
            this.actionResponseMetadata = (UiBotDesignerActionMetadataElement)JsonUtil.objectToJavaObject((Object)optResponseData.get(), UiBotDesignerActionMetadataElement.class);
            this.actionResponseMetadataInitialized = true;
        }
    }

    public UiBotDesignerActionMetadataElement getFieldInResponseMetadata(String parentFieldId, String targetFieldId) {
        if (Boolean.FALSE.equals(this.actionResponseMetadataInitialized) || Objects.isNull(this.actionResponseMetadata)) {
            log.error("No Field Metadata From Designer Database...");
            return null;
        }
        if (!StringUtils.hasLength((String)parentFieldId) || !StringUtils.hasLength((String)targetFieldId)) {
            log.error("parentFieldId and targetFieldId must has length...");
            return null;
        }
        String newParentFieldId = parentFieldId;
        String newTargetFieldId = targetFieldId;
        if (parentFieldId.contains(DESIGNER_FIELD_SPLITTER)) {
            String[] spiltedParentFieldAry = parentFieldId.split("\\.", 2);
            newParentFieldId = spiltedParentFieldAry[0];
            newTargetFieldId = String.join((CharSequence)DESIGNER_FIELD_SPLITTER, spiltedParentFieldAry[1], targetFieldId);
            log.debug("parentFieldId: {} is not simple, splitting parentFieldId and getField recursively...newParentFieldId is: {}, newTargetFieldId is: {}", new Object[]{parentFieldId, newParentFieldId, newTargetFieldId});
            return this.getFieldInResponseMetadata(newParentFieldId, newTargetFieldId);
        }
        if (Objects.equals(newParentFieldId, this.actionResponseMetadata.getDataName())) {
            UiBotDesignerActionMetadataElement parentFieldElement = this.actionResponseMetadata;
            return this.searchTargetElement(parentFieldElement, newTargetFieldId);
        }
        log.error("parentFieldId: {} is NOT matched with Metadata...", (Object)parentFieldId);
        return null;
    }

    private UiBotDesignerActionMetadataElement searchTargetElement(UiBotDesignerActionMetadataElement parentFieldElement, String targetFieldId) {
        if (Objects.isNull(parentFieldElement)) {
            log.error("parentFieldElement is NULL, searchTargetElement STOPPED...");
            return null;
        }
        if (targetFieldId.contains(DESIGNER_FIELD_SPLITTER)) {
            String[] splitedTargetFieldAry = targetFieldId.split("\\.", 2);
            String newParentFieldId = splitedTargetFieldAry[0];
            String newTargetFieldId = splitedTargetFieldAry[1];
            UiBotDesignerActionMetadataElement newParentFieldElement = parentFieldElement.getField().stream().filter(e -> Objects.equals(e.getDataName(), newParentFieldId)).findFirst().orElse(null);
            return this.searchTargetElement(newParentFieldElement, newTargetFieldId);
        }
        return parentFieldElement.getField().stream().filter(e -> Objects.equals(e.getDataName(), targetFieldId)).findFirst().orElse(null);
    }

    public Boolean getInitialized() {
        return this.initialized;
    }

    public MobileLayoutTypeEnum getMobileLayoutType() {
        return this.mobileLayoutType;
    }

    public UiBotDesignerPage getPage() {
        return this.page;
    }

    public Boolean getPageInitialized() {
        return this.pageInitialized;
    }

    public UiBotDesignerPage getPcPage() {
        return this.pcPage;
    }

    public Boolean getPcPageInitialized() {
        return this.pcPageInitialized;
    }

    public UiBotDesignerDataSource getDataSource() {
        return this.dataSource;
    }

    public UiBotDesignerDataSourceMap getDataSourceMap() {
        return this.dataSourceMap;
    }

    public Boolean getDataSourceInitialized() {
        return this.dataSourceInitialized;
    }

    public List<UiBotDesignerFieldTagConfig> getTagConfigs() {
        return this.tagConfigs;
    }

    public Boolean getTagInitialized() {
        return this.tagInitialized;
    }

    public List<UiBotDesignerRuleConfig> getRuleConfigs() {
        return this.ruleConfigs;
    }

    public Boolean getRuleInitialized() {
        return this.ruleInitialized;
    }

    public UiBotDesignerActionMetadataElement getActionResponseMetadata() {
        return this.actionResponseMetadata;
    }

    public Boolean getActionResponseMetadataInitialized() {
        return this.actionResponseMetadataInitialized;
    }

    public KnowledgeMapsActivityDefinition getRawTaskActivityDefinition() {
        return this.rawTaskActivityDefinition;
    }

    public KnowledgeMapsActivityDefinition getPcRawTaskActivityDefinition() {
        return this.pcRawTaskActivityDefinition;
    }

    public List<KnowledgeMapsTagQueryResult> getRawFieldTags() {
        return this.rawFieldTags;
    }

    public KnowledgeMapsRuleQueryResult getRawRule() {
        return this.rawRule;
    }

    public KnowledgeMapsActionMetadataQueryResult getRawActionMetadata() {
        return this.rawActionMetadata;
    }

    public void setInitialized(Boolean initialized) {
        this.initialized = initialized;
    }

    public void setMobileLayoutType(MobileLayoutTypeEnum mobileLayoutType) {
        this.mobileLayoutType = mobileLayoutType;
    }

    public void setPage(UiBotDesignerPage page) {
        this.page = page;
    }

    public void setPageInitialized(Boolean pageInitialized) {
        this.pageInitialized = pageInitialized;
    }

    public void setPcPage(UiBotDesignerPage pcPage) {
        this.pcPage = pcPage;
    }

    public void setPcPageInitialized(Boolean pcPageInitialized) {
        this.pcPageInitialized = pcPageInitialized;
    }

    public void setDataSource(UiBotDesignerDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSourceMap(UiBotDesignerDataSourceMap dataSourceMap) {
        this.dataSourceMap = dataSourceMap;
    }

    public void setDataSourceInitialized(Boolean dataSourceInitialized) {
        this.dataSourceInitialized = dataSourceInitialized;
    }

    public void setTagConfigs(List<UiBotDesignerFieldTagConfig> tagConfigs) {
        this.tagConfigs = tagConfigs;
    }

    public void setTagInitialized(Boolean tagInitialized) {
        this.tagInitialized = tagInitialized;
    }

    public void setRuleConfigs(List<UiBotDesignerRuleConfig> ruleConfigs) {
        this.ruleConfigs = ruleConfigs;
    }

    public void setRuleInitialized(Boolean ruleInitialized) {
        this.ruleInitialized = ruleInitialized;
    }

    public void setActionResponseMetadata(UiBotDesignerActionMetadataElement actionResponseMetadata) {
        this.actionResponseMetadata = actionResponseMetadata;
    }

    public void setActionResponseMetadataInitialized(Boolean actionResponseMetadataInitialized) {
        this.actionResponseMetadataInitialized = actionResponseMetadataInitialized;
    }

    public void setRawTaskActivityDefinition(KnowledgeMapsActivityDefinition rawTaskActivityDefinition) {
        this.rawTaskActivityDefinition = rawTaskActivityDefinition;
    }

    public void setPcRawTaskActivityDefinition(KnowledgeMapsActivityDefinition pcRawTaskActivityDefinition) {
        this.pcRawTaskActivityDefinition = pcRawTaskActivityDefinition;
    }

    public void setRawFieldTags(List<KnowledgeMapsTagQueryResult> rawFieldTags) {
        this.rawFieldTags = rawFieldTags;
    }

    public void setRawRule(KnowledgeMapsRuleQueryResult rawRule) {
        this.rawRule = rawRule;
    }

    public void setRawActionMetadata(KnowledgeMapsActionMetadataQueryResult rawActionMetadata) {
        this.rawActionMetadata = rawActionMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiBotDesignerConfig)) {
            return false;
        }
        UiBotDesignerConfig other = (UiBotDesignerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$initialized = this.getInitialized();
        Boolean other$initialized = other.getInitialized();
        if (this$initialized == null ? other$initialized != null : !((Object)this$initialized).equals(other$initialized)) {
            return false;
        }
        Boolean this$pageInitialized = this.getPageInitialized();
        Boolean other$pageInitialized = other.getPageInitialized();
        if (this$pageInitialized == null ? other$pageInitialized != null : !((Object)this$pageInitialized).equals(other$pageInitialized)) {
            return false;
        }
        Boolean this$pcPageInitialized = this.getPcPageInitialized();
        Boolean other$pcPageInitialized = other.getPcPageInitialized();
        if (this$pcPageInitialized == null ? other$pcPageInitialized != null : !((Object)this$pcPageInitialized).equals(other$pcPageInitialized)) {
            return false;
        }
        Boolean this$dataSourceInitialized = this.getDataSourceInitialized();
        Boolean other$dataSourceInitialized = other.getDataSourceInitialized();
        if (this$dataSourceInitialized == null ? other$dataSourceInitialized != null : !((Object)this$dataSourceInitialized).equals(other$dataSourceInitialized)) {
            return false;
        }
        Boolean this$tagInitialized = this.getTagInitialized();
        Boolean other$tagInitialized = other.getTagInitialized();
        if (this$tagInitialized == null ? other$tagInitialized != null : !((Object)this$tagInitialized).equals(other$tagInitialized)) {
            return false;
        }
        Boolean this$ruleInitialized = this.getRuleInitialized();
        Boolean other$ruleInitialized = other.getRuleInitialized();
        if (this$ruleInitialized == null ? other$ruleInitialized != null : !((Object)this$ruleInitialized).equals(other$ruleInitialized)) {
            return false;
        }
        Boolean this$actionResponseMetadataInitialized = this.getActionResponseMetadataInitialized();
        Boolean other$actionResponseMetadataInitialized = other.getActionResponseMetadataInitialized();
        if (this$actionResponseMetadataInitialized == null ? other$actionResponseMetadataInitialized != null : !((Object)this$actionResponseMetadataInitialized).equals(other$actionResponseMetadataInitialized)) {
            return false;
        }
        MobileLayoutTypeEnum this$mobileLayoutType = this.getMobileLayoutType();
        MobileLayoutTypeEnum other$mobileLayoutType = other.getMobileLayoutType();
        if (this$mobileLayoutType == null ? other$mobileLayoutType != null : !this$mobileLayoutType.equals(other$mobileLayoutType)) {
            return false;
        }
        UiBotDesignerPage this$page = this.getPage();
        UiBotDesignerPage other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        UiBotDesignerPage this$pcPage = this.getPcPage();
        UiBotDesignerPage other$pcPage = other.getPcPage();
        if (this$pcPage == null ? other$pcPage != null : !this$pcPage.equals(other$pcPage)) {
            return false;
        }
        UiBotDesignerDataSource this$dataSource = this.getDataSource();
        UiBotDesignerDataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        UiBotDesignerDataSourceMap this$dataSourceMap = this.getDataSourceMap();
        UiBotDesignerDataSourceMap other$dataSourceMap = other.getDataSourceMap();
        if (this$dataSourceMap == null ? other$dataSourceMap != null : !this$dataSourceMap.equals(other$dataSourceMap)) {
            return false;
        }
        List this$tagConfigs = this.getTagConfigs();
        List other$tagConfigs = other.getTagConfigs();
        if (this$tagConfigs == null ? other$tagConfigs != null : !((Object)this$tagConfigs).equals(other$tagConfigs)) {
            return false;
        }
        List this$ruleConfigs = this.getRuleConfigs();
        List other$ruleConfigs = other.getRuleConfigs();
        if (this$ruleConfigs == null ? other$ruleConfigs != null : !((Object)this$ruleConfigs).equals(other$ruleConfigs)) {
            return false;
        }
        UiBotDesignerActionMetadataElement this$actionResponseMetadata = this.getActionResponseMetadata();
        UiBotDesignerActionMetadataElement other$actionResponseMetadata = other.getActionResponseMetadata();
        if (this$actionResponseMetadata == null ? other$actionResponseMetadata != null : !this$actionResponseMetadata.equals(other$actionResponseMetadata)) {
            return false;
        }
        KnowledgeMapsActivityDefinition this$rawTaskActivityDefinition = this.getRawTaskActivityDefinition();
        KnowledgeMapsActivityDefinition other$rawTaskActivityDefinition = other.getRawTaskActivityDefinition();
        if (this$rawTaskActivityDefinition == null ? other$rawTaskActivityDefinition != null : !this$rawTaskActivityDefinition.equals(other$rawTaskActivityDefinition)) {
            return false;
        }
        KnowledgeMapsActivityDefinition this$pcRawTaskActivityDefinition = this.getPcRawTaskActivityDefinition();
        KnowledgeMapsActivityDefinition other$pcRawTaskActivityDefinition = other.getPcRawTaskActivityDefinition();
        if (this$pcRawTaskActivityDefinition == null ? other$pcRawTaskActivityDefinition != null : !this$pcRawTaskActivityDefinition.equals(other$pcRawTaskActivityDefinition)) {
            return false;
        }
        List this$rawFieldTags = this.getRawFieldTags();
        List other$rawFieldTags = other.getRawFieldTags();
        if (this$rawFieldTags == null ? other$rawFieldTags != null : !((Object)this$rawFieldTags).equals(other$rawFieldTags)) {
            return false;
        }
        KnowledgeMapsRuleQueryResult this$rawRule = this.getRawRule();
        KnowledgeMapsRuleQueryResult other$rawRule = other.getRawRule();
        if (this$rawRule == null ? other$rawRule != null : !this$rawRule.equals(other$rawRule)) {
            return false;
        }
        KnowledgeMapsActionMetadataQueryResult this$rawActionMetadata = this.getRawActionMetadata();
        KnowledgeMapsActionMetadataQueryResult other$rawActionMetadata = other.getRawActionMetadata();
        return !(this$rawActionMetadata == null ? other$rawActionMetadata != null : !this$rawActionMetadata.equals(other$rawActionMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiBotDesignerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $initialized = this.getInitialized();
        result = result * 59 + ($initialized == null ? 43 : ((Object)$initialized).hashCode());
        Boolean $pageInitialized = this.getPageInitialized();
        result = result * 59 + ($pageInitialized == null ? 43 : ((Object)$pageInitialized).hashCode());
        Boolean $pcPageInitialized = this.getPcPageInitialized();
        result = result * 59 + ($pcPageInitialized == null ? 43 : ((Object)$pcPageInitialized).hashCode());
        Boolean $dataSourceInitialized = this.getDataSourceInitialized();
        result = result * 59 + ($dataSourceInitialized == null ? 43 : ((Object)$dataSourceInitialized).hashCode());
        Boolean $tagInitialized = this.getTagInitialized();
        result = result * 59 + ($tagInitialized == null ? 43 : ((Object)$tagInitialized).hashCode());
        Boolean $ruleInitialized = this.getRuleInitialized();
        result = result * 59 + ($ruleInitialized == null ? 43 : ((Object)$ruleInitialized).hashCode());
        Boolean $actionResponseMetadataInitialized = this.getActionResponseMetadataInitialized();
        result = result * 59 + ($actionResponseMetadataInitialized == null ? 43 : ((Object)$actionResponseMetadataInitialized).hashCode());
        MobileLayoutTypeEnum $mobileLayoutType = this.getMobileLayoutType();
        result = result * 59 + ($mobileLayoutType == null ? 43 : $mobileLayoutType.hashCode());
        UiBotDesignerPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        UiBotDesignerPage $pcPage = this.getPcPage();
        result = result * 59 + ($pcPage == null ? 43 : $pcPage.hashCode());
        UiBotDesignerDataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        UiBotDesignerDataSourceMap $dataSourceMap = this.getDataSourceMap();
        result = result * 59 + ($dataSourceMap == null ? 43 : $dataSourceMap.hashCode());
        List $tagConfigs = this.getTagConfigs();
        result = result * 59 + ($tagConfigs == null ? 43 : ((Object)$tagConfigs).hashCode());
        List $ruleConfigs = this.getRuleConfigs();
        result = result * 59 + ($ruleConfigs == null ? 43 : ((Object)$ruleConfigs).hashCode());
        UiBotDesignerActionMetadataElement $actionResponseMetadata = this.getActionResponseMetadata();
        result = result * 59 + ($actionResponseMetadata == null ? 43 : $actionResponseMetadata.hashCode());
        KnowledgeMapsActivityDefinition $rawTaskActivityDefinition = this.getRawTaskActivityDefinition();
        result = result * 59 + ($rawTaskActivityDefinition == null ? 43 : $rawTaskActivityDefinition.hashCode());
        KnowledgeMapsActivityDefinition $pcRawTaskActivityDefinition = this.getPcRawTaskActivityDefinition();
        result = result * 59 + ($pcRawTaskActivityDefinition == null ? 43 : $pcRawTaskActivityDefinition.hashCode());
        List $rawFieldTags = this.getRawFieldTags();
        result = result * 59 + ($rawFieldTags == null ? 43 : ((Object)$rawFieldTags).hashCode());
        KnowledgeMapsRuleQueryResult $rawRule = this.getRawRule();
        result = result * 59 + ($rawRule == null ? 43 : $rawRule.hashCode());
        KnowledgeMapsActionMetadataQueryResult $rawActionMetadata = this.getRawActionMetadata();
        result = result * 59 + ($rawActionMetadata == null ? 43 : $rawActionMetadata.hashCode());
        return result;
    }

    public String toString() {
        return "UiBotDesignerConfig(initialized=" + this.getInitialized() + ", mobileLayoutType=" + this.getMobileLayoutType() + ", page=" + this.getPage() + ", pageInitialized=" + this.getPageInitialized() + ", pcPage=" + this.getPcPage() + ", pcPageInitialized=" + this.getPcPageInitialized() + ", dataSource=" + this.getDataSource() + ", dataSourceMap=" + this.getDataSourceMap() + ", dataSourceInitialized=" + this.getDataSourceInitialized() + ", tagConfigs=" + this.getTagConfigs() + ", tagInitialized=" + this.getTagInitialized() + ", ruleConfigs=" + this.getRuleConfigs() + ", ruleInitialized=" + this.getRuleInitialized() + ", actionResponseMetadata=" + this.getActionResponseMetadata() + ", actionResponseMetadataInitialized=" + this.getActionResponseMetadataInitialized() + ", rawTaskActivityDefinition=" + this.getRawTaskActivityDefinition() + ", pcRawTaskActivityDefinition=" + this.getPcRawTaskActivityDefinition() + ", rawFieldTags=" + this.getRawFieldTags() + ", rawRule=" + this.getRawRule() + ", rawActionMetadata=" + this.getRawActionMetadata() + ")";
    }
}

