/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.page;

import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageDataState;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageFieldMetaData;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiBotDesignerPage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(UiBotDesignerPage.class);
    private static final long serialVersionUID = 8583741535119313519L;
    private Boolean isCustomize;
    private List<PageDataState> dataStates;
    private Boolean showTaskNameInTab;
    private Map<String, PageFieldMetaData> pageFieldMetadataMap;

    public void initDesignerPageConfig() {
        if (null == this.dataStates) {
            log.error("Athena-KM returned NULL/EMPTY dataStates, PLZ CHECK THEM!");
            return;
        }
        if (null == this.pageFieldMetadataMap) {
            this.pageFieldMetadataMap = new HashMap(this.dataStates.size());
        }
        for (PageDataState dataState : this.getDataStates()) {
            String dataStateCode = dataState.getCode();
            PageFieldMetaData pageFieldMetaData = dataState.getShowMetadatas();
            if (null == dataStateCode || null == pageFieldMetaData) continue;
            this.pageFieldMetadataMap.put(dataStateCode, pageFieldMetaData);
        }
    }

    public Boolean getIsCustomize() {
        return this.isCustomize;
    }

    public List<PageDataState> getDataStates() {
        return this.dataStates;
    }

    public Boolean getShowTaskNameInTab() {
        return this.showTaskNameInTab;
    }

    public Map<String, PageFieldMetaData> getPageFieldMetadataMap() {
        return this.pageFieldMetadataMap;
    }

    public void setIsCustomize(Boolean isCustomize) {
        this.isCustomize = isCustomize;
    }

    public void setDataStates(List<PageDataState> dataStates) {
        this.dataStates = dataStates;
    }

    public void setShowTaskNameInTab(Boolean showTaskNameInTab) {
        this.showTaskNameInTab = showTaskNameInTab;
    }

    public void setPageFieldMetadataMap(Map<String, PageFieldMetaData> pageFieldMetadataMap) {
        this.pageFieldMetadataMap = pageFieldMetadataMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiBotDesignerPage)) {
            return false;
        }
        UiBotDesignerPage other = (UiBotDesignerPage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isCustomize = this.getIsCustomize();
        Boolean other$isCustomize = other.getIsCustomize();
        if (this$isCustomize == null ? other$isCustomize != null : !((Object)this$isCustomize).equals(other$isCustomize)) {
            return false;
        }
        Boolean this$showTaskNameInTab = this.getShowTaskNameInTab();
        Boolean other$showTaskNameInTab = other.getShowTaskNameInTab();
        if (this$showTaskNameInTab == null ? other$showTaskNameInTab != null : !((Object)this$showTaskNameInTab).equals(other$showTaskNameInTab)) {
            return false;
        }
        List this$dataStates = this.getDataStates();
        List other$dataStates = other.getDataStates();
        if (this$dataStates == null ? other$dataStates != null : !((Object)this$dataStates).equals(other$dataStates)) {
            return false;
        }
        Map this$pageFieldMetadataMap = this.getPageFieldMetadataMap();
        Map other$pageFieldMetadataMap = other.getPageFieldMetadataMap();
        return !(this$pageFieldMetadataMap == null ? other$pageFieldMetadataMap != null : !((Object)this$pageFieldMetadataMap).equals(other$pageFieldMetadataMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UiBotDesignerPage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isCustomize = this.getIsCustomize();
        result = result * 59 + ($isCustomize == null ? 43 : ((Object)$isCustomize).hashCode());
        Boolean $showTaskNameInTab = this.getShowTaskNameInTab();
        result = result * 59 + ($showTaskNameInTab == null ? 43 : ((Object)$showTaskNameInTab).hashCode());
        List $dataStates = this.getDataStates();
        result = result * 59 + ($dataStates == null ? 43 : ((Object)$dataStates).hashCode());
        Map $pageFieldMetadataMap = this.getPageFieldMetadataMap();
        result = result * 59 + ($pageFieldMetadataMap == null ? 43 : ((Object)$pageFieldMetadataMap).hashCode());
        return result;
    }

    public String toString() {
        return "UiBotDesignerPage(isCustomize=" + this.getIsCustomize() + ", dataStates=" + this.getDataStates() + ", showTaskNameInTab=" + this.getShowTaskNameInTab() + ", pageFieldMetadataMap=" + this.getPageFieldMetadataMap() + ")";
    }
}

