/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerFieldOperationApplierService;
import com.digiwin.mobile.mobileuibot.designer.uibot.support.PcUiBotOpenWindowDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotFieldOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditor;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditorOption;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="uiBotDesignerFieldOperationApplierService")
public class UiBotDesignerFieldOperationApplierServiceImpl
implements UiBotDesignerFieldOperationApplierService {
    private static final Logger log = LoggerFactory.getLogger(UiBotDesignerFieldOperationApplierServiceImpl.class);
    @Autowired
    private PcUiBotOpenWindowDefineAnalyzer pcUiBotOpenWindowDefineAnalyzer;

    public void applyOpenWindowOperation(UiBotModel uiBotModel, List<PcUiBotTmOperation> openWindowTmOperationList) {
        UiBotTargetLayoutSearchResult layoutSearchResult = uiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return;
        }
        UiBotLayout pcDataLayout = layoutSearchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.processFieldOpenWindowWithPcTable(uiBotModel, pcDataLayout, openWindowTmOperationList);
            uiBotModel.setAppliedDesignerFieldOperation(Boolean.valueOf(true));
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processFieldOpenWindowWithPcFormList(uiBotModel, pcDataLayout, openWindowTmOperationList);
            uiBotModel.setAppliedDesignerFieldOperation(Boolean.valueOf(true));
        } else {
            return;
        }
    }

    public void applySingleSelectOperation(UiBotModel uiBotModel, List<PcUiBotTmOperation> singleSelectTmOperationList) {
        UiBotTargetLayoutSearchResult layoutSearchResult = uiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return;
        }
        UiBotLayout pcDataLayout = layoutSearchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.processFieldSingleSelectWithPcTable(uiBotModel, pcDataLayout, singleSelectTmOperationList);
            uiBotModel.setAppliedDesignerFieldOperation(Boolean.valueOf(true));
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processFieldSingleSelectWithPcFormList(uiBotModel, pcDataLayout, singleSelectTmOperationList);
            uiBotModel.setAppliedDesignerFieldOperation(Boolean.valueOf(true));
        } else {
            return;
        }
    }

    private void processFieldOpenWindowWithPcTable(UiBotModel uiBotModel, UiBotLayout pcDataLayout, List<PcUiBotTmOperation> openWindowPageTmOperationList) {
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)uiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (CollectionUtils.isEmpty((Collection)tableColumnDefinitionList)) {
            return;
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        Map<String, UiBotTableColumn> tableColumnMap = tableColumns.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        for (PcUiBotTmOperation pcUiBotTmOperation : openWindowPageTmOperationList) {
            String targetFieldId = pcUiBotTmOperation.getApplyToField();
            UiBotTableColumn targetColumn = tableColumnMap.get(targetFieldId);
            if (null == targetColumn) continue;
            targetColumn.setType("OPERATION_EDITOR");
            PcUiBotOpenWindowDefineDTO pcUiBotOpenWindowDefineDTO = this.pcUiBotOpenWindowDefineAnalyzer.analysis((PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)uiBotModel.getExecuteContext(), PcUiBotExecuteContext.class), pcUiBotTmOperation, Boolean.valueOf(false));
            JSONArray operationArray = new JSONArray(1);
            operationArray.add((Object)pcUiBotOpenWindowDefineDTO);
            targetColumn.setOperations(operationArray);
        }
    }

    private void processFieldOpenWindowWithPcFormList(UiBotModel uiBotModel, UiBotLayout pcDataLayout, List<PcUiBotTmOperation> openWindowPageTmOperationList) {
        String schema = pcDataLayout.getSchema();
        Map bizData = (Map)uiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizData, (String)("pagedata." + schema + " cannot be null"));
        List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(Collections.emptyList());
        Map<String, UiBotLayout> pcFieldLayoutMap = pcFieldLayoutList.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        for (PcUiBotTmOperation pcUiBotTmOperation : openWindowPageTmOperationList) {
            String targetFieldId = pcUiBotTmOperation.getApplyToField();
            UiBotLayout targetFieldLayout = pcFieldLayoutMap.get(targetFieldId);
            if (null == targetFieldLayout) continue;
            targetFieldLayout.setType("FORM_OPERATION_EDITOR");
            PcUiBotOpenWindowDefineDTO pcUiBotOpenWindowDefineDTO = this.pcUiBotOpenWindowDefineAnalyzer.analysis((PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)uiBotModel.getExecuteContext(), PcUiBotExecuteContext.class), pcUiBotTmOperation, Boolean.valueOf(false));
            PcUiBotOperationDTO pcUiBotOperationDTO = (PcUiBotOperationDTO)JsonUtil.objectToJavaObject((Object)pcUiBotTmOperation, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            pcUiBotOperationDTO.setOpenWindowDefine(pcUiBotOpenWindowDefineDTO);
            JSONArray operationArray = new JSONArray(1);
            operationArray.add((Object)pcUiBotTmOperation);
            targetFieldLayout.setOperations(operationArray);
        }
    }

    private void processFieldSingleSelectWithPcTable(UiBotModel uiBotModel, UiBotLayout pcDataLayout, List<PcUiBotTmOperation> singleSelectTmOperationList) {
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)uiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (CollectionUtils.isEmpty((Collection)tableColumnDefinitionList)) {
            return;
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        Map<String, UiBotTableColumn> tableColumnMap = tableColumns.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        for (PcUiBotTmOperation pcUiBotTmOperation : singleSelectTmOperationList) {
            UiBotTableColumn targetColumn = tableColumnMap.get(pcUiBotTmOperation.getApplyToField());
            if (null == targetColumn) continue;
            targetColumn.setType("SELECT");
            List options = (List)JsonUtil.objectToJavaObject((Object)pcUiBotTmOperation.getEditorDefine().getOptions(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            ArrayList<UiBotTableColumnEditorOption> targetColumnEditorOptionList = new ArrayList<UiBotTableColumnEditorOption>(options.size());
            for (JSONObject option : options) {
                JSONObject languageConfig = option.getJSONObject("language");
                String locale = AppRequestContext.getContextEntity().getLocale();
                targetColumnEditorOptionList.add(new UiBotTableColumnEditorOption().setTitle(languageConfig.getJSONObject("title").getString(locale)).setValue((Object)String.valueOf(option.get((Object)"value"))));
            }
            UiBotTableColumnEditor targetColumnEditor = new UiBotTableColumnEditor().setType("SELECT").setOptions(targetColumnEditorOptionList);
            targetColumn.setEditor(targetColumnEditor);
        }
    }

    private void processFieldSingleSelectWithPcFormList(UiBotModel uiBotModel, UiBotLayout pcDataLayout, List<PcUiBotTmOperation> singleSelectTmOperationList) {
        String schema = pcDataLayout.getSchema();
        Map bizData = (Map)uiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizData, (String)("pagedata." + schema + " cannot be null"));
        List pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(Collections.emptyList());
        Map<String, UiBotLayout> pcFieldLayoutMap = pcFieldLayoutList.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        for (PcUiBotTmOperation pcUiBotTmOperation : singleSelectTmOperationList) {
            UiBotLayout targetFieldLayout = pcFieldLayoutMap.get(pcUiBotTmOperation.getApplyToField());
            if (null == targetFieldLayout) continue;
            targetFieldLayout.setType("SELECT");
            List options = (List)JsonUtil.objectToJavaObject((Object)pcUiBotTmOperation.getEditorDefine().getOptions(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            ArrayList<UiBotFieldOption> targetFieldOptionList = new ArrayList<UiBotFieldOption>(options.size());
            for (JSONObject option : options) {
                JSONObject languageConfig = option.getJSONObject("language");
                String locale = AppRequestContext.getContextEntity().getLocale();
                targetFieldOptionList.add(new UiBotFieldOption().setTitle(languageConfig.getJSONObject("title").getString(locale)).setValue((Object)String.valueOf(option.get((Object)"value"))));
            }
            targetFieldLayout.setOptions(targetFieldOptionList);
        }
    }
}

