/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.espapi;

import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.espapi.EspDigiService;
import com.digiwin.mobile.mobileuibot.proxy.esp.callback.DigiwinEspCallbackManager;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspExecution;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspStdData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/eai"})
public class EspApiController {
    @PostMapping(value={""})
    public DigiwinEspResponse openApi(HttpServletRequest request, HttpServletResponse response) {
        DigiwinEspResponse digiwinEspResponse = new DigiwinEspResponse();
        String digiServiceStr = request.getHeader("digi-service");
        EspDigiService espDigiService = (EspDigiService)JsonUtil.jsonStringToObject((String)digiServiceStr, EspDigiService.class);
        String apiName = espDigiService.getName();
        response.setHeader("content-type", "application/json; charset=utf-8");
        response.setHeader("digi-srvver", "1.0");
        response.setHeader("digi-srvcode", "000");
        if ("mobile.api.test".equalsIgnoreCase(apiName)) {
            digiwinEspResponse.setStdData(this.mobileApiTest());
            return digiwinEspResponse;
        }
        DigiwinEspStdData digiwinEspStdData = new DigiwinEspStdData();
        Map<String, String> parameter = new HashMap<String, String>();
        String data = null;
        if ("mobile.test.project.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText((String)"static/esp_demo/esp_mobile_test_project_get.json");
        } else if ("mobile.test.task.list.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText((String)"static/esp_demo/esp_mobile_test_task_list_get.json");
        } else if ("mobile.test.project.task.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText((String)"static/esp_demo/esp_mobile_test_project_task_get.json");
        } else if ("mobile.smart.transport.get".equalsIgnoreCase(apiName)) {
            data = FileUtil.readText((String)"static/esp_demo/esp_mobile_smart_transport_get.json");
        } else if ("mobile.smart.transport.update".equalsIgnoreCase(apiName)) {
            data = "{}";
        }
        if (StringUtils.hasLength((String)data)) {
            parameter = (Map)JsonUtil.jsonStringToObject((String)data, Map.class);
        } else {
            parameter.put("msg", apiName + " not found");
        }
        digiwinEspStdData.setParameter(parameter);
        DigiwinEspExecution digiwinEspExecution = new DigiwinEspExecution();
        digiwinEspExecution.setCode("0");
        digiwinEspExecution.setDescription("success");
        digiwinEspStdData.setExecution(digiwinEspExecution);
        digiwinEspResponse.setStdData(digiwinEspStdData);
        return digiwinEspResponse;
    }

    private DigiwinEspStdData mobileApiTest() {
        DigiwinEspStdData digiwinEspStdData = new DigiwinEspStdData();
        HashMap<String, String> parameter = new HashMap<String, String>();
        digiwinEspStdData.setParameter(parameter);
        parameter.put("api", "Mobile-api-test");
        return digiwinEspStdData;
    }

    @PostMapping(value={"/callback"})
    public DigiwinEspResponse callback(HttpServletRequest request, @RequestBody DigiwinEspResponse digiwinEspResponse, HttpServletResponse response) {
        Map parameter = new HashMap();
        if (ObjectUtils.isNotEmpty((Object)digiwinEspResponse.getStdData()) && ObjectUtils.isNotEmpty((Object)digiwinEspResponse.getStdData().getParameter())) {
            parameter = digiwinEspResponse.getStdData().getParameter();
        }
        String digiReqId = Optional.ofNullable(request.getHeader("digi-reqid")).orElse("");
        DigiwinEspCallbackManager.notifyDataReceived((String)digiReqId, (String)JsonUtil.javaObjectToJsonString(parameter));
        return this.buildEspOk(response);
    }

    private DigiwinEspResponse buildEspOk(HttpServletResponse response) {
        response.setHeader("content-type", "application/json; charset=utf-8");
        response.setHeader("digi-srvver", "1.0");
        response.setHeader("digi-srvcode", "000");
        DigiwinEspResponse digiwinEspResponse = new DigiwinEspResponse();
        DigiwinEspStdData digiwinEspStdData = new DigiwinEspStdData();
        digiwinEspStdData.setParameter(new HashMap());
        DigiwinEspExecution digiwinEspExecution = new DigiwinEspExecution();
        digiwinEspExecution.setCode("0");
        digiwinEspExecution.setDescription("success");
        digiwinEspStdData.setExecution(digiwinEspExecution);
        digiwinEspResponse.setStdData(digiwinEspStdData);
        return digiwinEspResponse;
    }
}

