/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.feedback;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequestAgileDataInAiChat;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.feedback.ApiRequestFeedbackActionInAiChat;
import com.digiwin.mobile.mobileuibot.feedback.ApiRequestFeedbackCommentInAiChat;
import com.digiwin.mobile.mobileuibot.feedback.ApiRequestFeedbackGetBatchInAiChat;
import com.digiwin.mobile.mobileuibot.feedback.ChatInfo;
import com.digiwin.mobile.mobileuibot.feedback.FeedbackChoiceContent;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtUserFeedback;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/feedback"})
@Validated
public class FeedbackController {
    private static final Logger log = LoggerFactory.getLogger(FeedbackController.class);
    @Autowired
    private DigiwinAdtProxyService digiwinAdtProxyService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/aiassistant/chat/submit"})
    public ApiResponse<Boolean> aiAssistantChatSubmit(@Validated @RequestBody ApiRequestFeedbackActionInAiChat apiRequest) {
        Long generateSerialNo = apiRequest.getGenerateSerialNo();
        Integer feedbackType = apiRequest.getFeedbackType();
        ChatInfo chatInfo = apiRequest.getChatInfo();
        String skillType = chatInfo.getSkillType();
        String qu = chatInfo.getQu();
        String quTime = chatInfo.getQuTime();
        String a = chatInfo.getA();
        String aTime = chatInfo.getATime();
        String snapshotId = StringUtils.hasLength((String)apiRequest.getSnapshotId()) ? apiRequest.getSnapshotId() : a;
        JSONObject params = new JSONObject();
        params.put("generateSerialNo", (Object)generateSerialNo);
        params.put("snapshotId", (Object)snapshotId);
        params.put("feedbackType", (Object)apiRequest.getFeedbackType());
        params.put("question", (Object)qu);
        params.put("tenantName", (Object)apiRequest.getTenantName());
        params.put("userId", (Object)apiRequest.getUserId());
        params.put("userName", (Object)apiRequest.getUserName());
        JSONObject extendInfo = new JSONObject();
        params.put("extendInfo", (Object)extendInfo);
        extendInfo.put("appInfo", (Object)apiRequest.getAppInfo());
        extendInfo.put("chatInfo", (Object)apiRequest.getChatInfo());
        extendInfo.put("deviceInfo", (Object)apiRequest.getDeviceInfo());
        DigiwinAthenaApiResponse sendResult = this.digiwinAdtProxyService.sendUserFeedback(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), (Map)params);
        if (null == sendResult) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "ADT\u670d\u52a1\u65e0\u54cd\u5e94\uff0c\u53cd\u9988\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
        }
        if (sendResult.getStatus() == 200 && ((Boolean)sendResult.getResponse()).booleanValue()) {
            return ApiResponse.buildOK().setData((Object)true);
        }
        if (sendResult.getStatus() != 200) {
            return ApiResponse.buildError((String)sendResult.getErrorMessage());
        }
        return ApiResponse.buildError();
    }

    @PostMapping(value={"/aiassistant/chat/cancel"})
    public ApiResponse<Boolean> aiAssistantChatCancel(@Validated @RequestBody ApiRequestAgileDataInAiChat apiRequest) {
        Long generateSerialNo = apiRequest.getGenerateSerialNo();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("generateSerialNo", generateSerialNo);
        DigiwinAthenaApiResponse cancelResult = this.digiwinAdtProxyService.cancelUserFeedback(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        if (null == cancelResult) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "ADT\u670d\u52a1\u65e0\u54cd\u5e94\uff0c\u53d6\u6d88\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
        }
        if (cancelResult.getStatus() == 200 && ((Boolean)cancelResult.getResponse()).booleanValue()) {
            return ApiResponse.buildOK().setData((Object)true);
        }
        if (cancelResult.getStatus() != 200) {
            return ApiResponse.buildError((String)cancelResult.getErrorMessage());
        }
        return ApiResponse.buildError();
    }

    @PostMapping(value={"/aiassistant/chat/comment/submit"})
    public ApiResponse<Boolean> aiAssistantChatCommentSubmit(@Validated @RequestBody ApiRequestFeedbackCommentInAiChat apiRequest) {
        Long generateSerialNo = apiRequest.getGenerateSerialNo();
        String snapshotId = apiRequest.getSnapshotId();
        List contents = apiRequest.getBackContent();
        String opinion = apiRequest.getOpinion();
        if (CollectionUtils.isEmpty((Collection)contents) && !StringUtils.hasLength((String)opinion)) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u8bf7\u8ba9\u6211\u4eec\u77e5\u9053\u9700\u8981\u6539\u8fdb\u7684\u5730\u65b9"));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> answerBack = new HashMap<String, Object>(2);
        answerBack.put("opinion", opinion);
        answerBack.put("backContent", contents);
        params.put("answerBack", answerBack);
        String checkOpinions = String.join((CharSequence)"||", contents.stream().map(choice -> choice.getId() + "").collect(Collectors.toList()));
        String backContent = String.join((CharSequence)"||", contents.stream().map(FeedbackChoiceContent::getText).collect(Collectors.toList()));
        params.put("checkOpinions", checkOpinions);
        params.put("backContent", backContent);
        params.put("answerOpinion", opinion);
        params.put("generateSerialNo", generateSerialNo);
        params.put("snapshotId", snapshotId);
        DigiwinAthenaApiResponse submitResult = this.digiwinAdtProxyService.userAnswerFeedback(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        if (null == submitResult) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "ADT\u670d\u52a1\u65e0\u54cd\u5e94\uff0c\u610f\u89c1\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
        }
        if (submitResult.getStatus() == 200 && ((Boolean)submitResult.getResponse()).booleanValue()) {
            return ApiResponse.buildOK().setData((Object)true);
        }
        if (submitResult.getStatus() != 200) {
            return ApiResponse.buildError((String)submitResult.getErrorMessage());
        }
        return ApiResponse.buildError();
    }

    @PostMapping(value={"/aiassistant/chat/getBySerialNos"})
    public ApiResponse<List<DigiwinAdtUserFeedback>> aiAssistantChatGetBySerialNos(@Validated @RequestBody ApiRequestFeedbackGetBatchInAiChat apiRequest) {
        List generateSerialNos = apiRequest.getGenerateSerialNos();
        DigiwinAthenaApiResponse getUserFeedbackRsp = this.digiwinAdtProxyService.getUserFeedback(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), generateSerialNos);
        if (null == getUserFeedbackRsp) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "ADT\u670d\u52a1\u65e0\u54cd\u5e94\uff0c\u5386\u53f2\u53cd\u9988\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
        }
        if (getUserFeedbackRsp.getStatus() == 200) {
            return ApiResponse.buildOK().setData(getUserFeedbackRsp.getResponse());
        }
        if (getUserFeedbackRsp.getStatus() != 200) {
            return ApiResponse.buildError((String)getUserFeedbackRsp.getErrorMessage());
        }
        return ApiResponse.buildError();
    }
}

