/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.gptai;

import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.gptai.GptAiModel;
import com.digiwin.mobile.mobileuibot.gptai.GptAiRepository;
import com.digiwin.mobile.mobileuibot.gptai.GptAiService;
import com.digiwin.mobile.mobileuibot.gptai.GptAiServiceImpl;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Example;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GptAiServiceImpl
implements GptAiService {
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private HttpService httpService;
    @Autowired
    private GptAiRepository gptAiRepository;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<GptAiModel> findAll(String locale) {
        GptAiModel gptAiModel = new GptAiModel();
        Example example = Example.of((Object)gptAiModel);
        List gptAiModelList = this.gptAiRepository.findAll(example);
        for (GptAiModel aiModel : gptAiModelList) {
            aiModel.setTitle(this.localeService.getLanguageValue(locale, aiModel.getTitle()));
            aiModel.setSbuTitle(this.localeService.getLanguageValue(locale, aiModel.getSbuTitle()));
            aiModel.setToastMessage(this.localeService.getLanguageValue(locale, aiModel.getToastMessage()));
        }
        gptAiModelList.sort(Comparator.comparing(GptAiModel::getSort));
        return gptAiModelList;
    }

    public GptAiModel insertOrUpdateGptAi(GptAiModel gptAi) {
        GptAiModel gptAiModel = new GptAiModel();
        gptAiModel.setIcon(gptAi.getIcon());
        Example example = Example.of((Object)gptAiModel);
        Optional optional = this.gptAiRepository.findOne(example);
        if (optional.isPresent()) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"icon").is((Object)gptAi.getIcon()));
            Update update = new Update();
            if (StringUtils.isNotBlank((CharSequence)gptAi.getTitle())) {
                update.set("title", (Object)gptAi.getTitle());
            }
            if (StringUtils.isNotBlank((CharSequence)gptAi.getCode())) {
                update.set("code", (Object)gptAi.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)gptAi.getAppId())) {
                update.set("appId", (Object)gptAi.getAppId());
            }
            if (StringUtils.isNotBlank((CharSequence)gptAi.getSbuTitle())) {
                update.set("sbuTitle", (Object)gptAi.getSbuTitle());
            }
            if (ObjectUtils.isNotEmpty((Object)gptAi.getSwitchShow())) {
                update.set("switchShow", (Object)gptAi.getSwitchShow());
            }
            if (ObjectUtils.isNotEmpty((Object)gptAi.getSwitchClick())) {
                update.set("switchClick", (Object)gptAi.getSwitchClick());
            }
            if (StringUtils.isNotBlank((CharSequence)gptAi.getIcon())) {
                update.set("icon", (Object)gptAi.getIcon());
            }
            if (StringUtils.isNotBlank((CharSequence)gptAi.getUrlLink())) {
                update.set("urlLink", (Object)gptAi.getUrlLink());
            }
            if (StringUtils.isNotBlank((CharSequence)gptAi.getToastMessage())) {
                update.set("toastMessage", (Object)gptAi.getToastMessage());
            }
            if (ObjectUtils.isNotEmpty((Object)gptAi.getSort())) {
                update.set("sort", (Object)gptAi.getSort());
            }
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, GptAiModel.class);
            Optional one = this.gptAiRepository.findOne(example);
            return one.orElseGet(GptAiModel::new);
        }
        return (GptAiModel)this.gptAiRepository.save((Object)gptAi);
    }

    public Boolean pushReport(String report, String userId, String iamUserToken, String tenantId) {
        String url = this.sysEnvConfig.getSdAiUrl() + "/scrumbi/pushReport";
        HashMap<String, String> body = new HashMap<String, String>(3);
        body.put("tenantId", tenantId);
        body.put("userId", userId);
        body.put("report", report);
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            return true;
        }
        return false;
    }
}

