/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.briefingexpress.BriefingExpress;
import com.digiwin.mobile.mobileuibot.core.component.briefingexpress.BriefingExpressData;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceDirectionEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.DashboardService;
import com.digiwin.mobile.mobileuibot.index.IndexBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtReportData;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="indexBuildHasWorkStrategy")
public class IndexBuildHasWorkStrategy
implements IndexBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(IndexBuildHasWorkStrategy.class);
    private static final String DIGI_WIN_CLOUD = "digiwincloud";
    @Autowired
    private RecommendService recommendService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public String getIndexType() {
        return PageSettingIdPresetEnum.INDEX_HAS_WORK.toString();
    }

    public UiBotModel build(ApiRequest apiRequest, PageSetting pageSetting, Boolean hasProjectData) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Iterator layoutIterator = uiBotModel.getLayout().iterator();
        ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
        boolean haveRecommend = false;
        String locale = apiRequest.getLocale();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = (UiBotLayout)layoutIterator.next();
            if ("INDEX_NAVBAR".equals(layout.getType()) && pageData.get((Object)layout.getSchema()) != null) {
                IndexNavBar indexNavBar = (IndexNavBar)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), IndexNavBar.class);
                indexNavBar.initSetting(apiRequest.getLocale(), apiRequest.getAppInfo());
                indexNavBar.initShortcutButton(apiRequest, this.projectService, this.localeService);
                pageData.put((Object)layout.getSchema(), (Object)indexNavBar);
                layoutList.add(layout);
                continue;
            }
            if ("CUSTOM_TAB_CONTROLLER".equals(layout.getType()) && pageData.get((Object)layout.getSchema()) != null) {
                CustomTabController customTabController = (CustomTabController)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomTabController.class);
                customTabController.getTabItems().forEach(item -> {
                    item.setName(this.localeService.getLanguageValue(locale, item.getName()));
                    item.setJumpPageTitle(this.localeService.getLanguageValue(locale, item.getJumpPageTitle()));
                });
                ArrayList itemList = new ArrayList();
                if (!this.handleTripartiteToDo(apiRequest, customTabController, itemList).booleanValue()) {
                    customTabController.updateAsyncConfigParam(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId());
                    customTabController.getTabItems().removeIf(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId()));
                }
                if (!hasProjectData.booleanValue()) {
                    customTabController.getTabItems().removeIf(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_CARD_LIST.getReuqestId().equalsIgnoreCase(item.getId()));
                }
                pageData.put((Object)layout.getSchema(), (Object)customTabController);
                layoutList.add(layout);
                continue;
            }
            if ("UNI_SEARCH".equals(layout.getType()) && pageData.get((Object)layout.getSchema()) != null) {
                UniSearch uniSearch = (UniSearch)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), UniSearch.class);
                uniSearch.initSetting(apiRequest.getLocale());
                pageData.put((Object)layout.getSchema(), (Object)uniSearch);
                layoutList.add(layout);
                continue;
            }
            if ("CUSTOM_GROUP".equalsIgnoreCase(layout.getType())) {
                CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomGroup.class);
                customGroup.setName(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)customGroup.getName()));
                if (customGroup.getContent().getPageData() == null) {
                    customGroup.getContent().setPageData(new UiBotPageData());
                }
                List groupLayoutList = customGroup.getContent().getLayout();
                ArrayList<UiBotLayout> newGroupLayoutList = new ArrayList<UiBotLayout>();
                for (UiBotLayout groupLayout : groupLayoutList) {
                    if ("recommend_see".equals(groupLayout.getSchema()) || !"recommend_do".equals(groupLayout.getSchema())) continue;
                    List appFunctionTouchableList = this.recommendService.getRecommendAppList(apiRequest);
                    if (!CollectionUtils.isEmpty((Collection)appFunctionTouchableList)) {
                        haveRecommend = true;
                        AppEntrance appEntrance = new AppEntrance();
                        appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
                        appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
                        appEntrance.getAppList().addAll(appFunctionTouchableList);
                        List appList = appEntrance.getAppList();
                        ArrayList<AppFunctionTouchable> newAppList = new ArrayList<AppFunctionTouchable>(appList.size());
                        for (AppFunctionTouchable app : appList) {
                            if (app.getAction() == null || !StringUtils.hasLength((String)app.getName())) continue;
                            newAppList.add(app);
                        }
                        if (CollectionUtils.isEmpty(newAppList)) {
                            haveRecommend = false;
                        } else {
                            appEntrance.setAppList(newAppList);
                            String schema = UUIDUtil.getUuid();
                            UiBotLayout appLayout = new UiBotLayout();
                            appLayout.setType("APP_ENTRANCE");
                            appLayout.setSchema(schema);
                            newGroupLayoutList.add(appLayout);
                            customGroup.getContent().getPageData().put((Object)schema, (Object)appEntrance);
                        }
                    }
                    if (null == apiRequest.getIsHavePreset() || !apiRequest.getIsHavePreset().booleanValue()) continue;
                    String uuid = UUIDUtil.getUuid();
                    CustomContent customContent = CustomContent.create((String)apiRequest.getLocale(), (String)apiRequest.getClientId(), (String)apiRequest.getIamUserToken(), (String)"", (String)(AppContext.getBaseUrl() + "/machine/preset/myBench/queryClickAppJob"), (boolean)true);
                    customContent.getSysParam().put("tenantId", apiRequest.getTenantId());
                    customContent.getSysParam().put("userId", apiRequest.getUserId());
                    UiBotLayout customContentLayout = new UiBotLayout();
                    customContentLayout.setType("CUSTOM_CONTENT");
                    customContentLayout.setSchema(uuid);
                    newGroupLayoutList.add(customContentLayout);
                    customGroup.setIsSlide(Boolean.valueOf(true));
                    customGroup.getContent().getPageData().put((Object)uuid, (Object)customContent);
                }
                if (!haveRecommend && (null == apiRequest.getIsHavePreset() || !apiRequest.getIsHavePreset().booleanValue())) continue;
                customGroup.getContent().setLayout(newGroupLayoutList);
                layoutList.add(layout);
                pageData.put((Object)layout.getSchema(), (Object)customGroup);
                continue;
            }
            if ("BLANK_AREA".equalsIgnoreCase(layout.getType())) {
                if (!haveRecommend) continue;
                layoutList.add(layout);
                continue;
            }
            if (!"BRIEFING_EXPRESS_1".equals(layout.getType())) continue;
            BriefingExpress briefingExpress = (BriefingExpress)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), BriefingExpress.class);
            HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
            params.put("isRead", false);
            List datas = ModuleUtils.listToListObject((List)((List)JsonUtil.jsonStringToObject((String)FileUtil.readText((String)"static/appstore-use/briefingexpress_report_list.json"), List.class)), DigiwinAdtReportData.class);
            if (CollectionUtils.isEmpty((Collection)datas)) continue;
            briefingExpress.setTitle(this.localeService.getLanguageValue(locale, briefingExpress.getTitle()));
            int dataSize = 0;
            for (DigiwinAdtReportData reportData : datas) {
                if (dataSize >= 2) break;
                BriefingExpressData data = new BriefingExpressData();
                data.setContent(reportData.getTitle());
                data.setAction(Action.createExpressButton((DigiwinAdtReportData)reportData));
                data.setStatus(reportData.getStatus());
                data.setUnRead(Boolean.valueOf(reportData.getReadCount() == 0));
                briefingExpress.getDatas().add(data);
                ++dataSize;
            }
            briefingExpress.setSubTitle(briefingExpress, datas.size(), locale, this.localeService);
            if (datas.size() > briefingExpress.getShowDataNum()) {
                briefingExpress.setHasShowMore(Boolean.valueOf(true));
                briefingExpress.setShowMoreText(this.localeService.getLanguageValue(locale, briefingExpress.getShowMoreText()));
            }
            layoutList.add(layout);
            pageData.put((Object)layout.getSchema(), (Object)briefingExpress);
        }
        uiBotModel.setLayout(layoutList);
        return uiBotModel;
    }

    private Boolean checkData(List<DigiwinAdtReportData> datas) {
        if (CollectionUtils.isEmpty(datas)) {
            return false;
        }
        for (DigiwinAdtReportData reportData : datas) {
            if (reportData.getReadCount() != 0) continue;
            return true;
        }
        return false;
    }

    private Boolean handleTripartiteToDo(ApiRequest apiRequest, CustomTabController customTabController, List<CustomTabControllerItem> itemList) {
        try {
            boolean hasPermission = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.queryStatus(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), (Executor)this.threadPoolTaskExecutor).get();
            if (hasPermission) {
                List tripartiteTodoList = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.getTripartiteToDoList(apiRequest.getClientId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()), (Executor)this.threadPoolTaskExecutor).get();
                customTabController.updateAsyncTripartiteToDoConfigParam(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId(), tripartiteTodoList);
                if (!AppContext.getApiUrlSetting().getSemcUrl().contains(DIGI_WIN_CLOUD)) {
                    List newItemList = customTabController.getTabItems().stream().filter(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId())).collect(Collectors.toList());
                    customTabController.setTabItems(newItemList);
                } else if (CollectionUtils.isEmpty((Collection)tripartiteTodoList)) {
                    customTabController.getTabItems().removeIf(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId()));
                }
                return true;
            }
        }
        catch (InterruptedException e) {
            log.error("\u5f02\u6b65\u5904\u7406\u4e09\u65b9\u5f85\u529e\u9996\u9875\u4fe1\u606f\u88ab\u4e2d\u65ad: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (ExecutionException e) {
            log.error("\u5f02\u6b65\u5904\u7406\u4e09\u65b9\u5f85\u529e\u9996\u9875\u4fe1\u606f\u5f02\u5e38: {}", (Object)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()), (Object)e);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4e09\u65b9\u5f85\u529e\u9996\u9875\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }
}

