/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IndexBuildNoTenantStrategy {
    public UiBotModel build(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        if (!CollectionUtils.isEmpty((Collection)layoutList)) {
            layoutList.forEach(layout -> {
                switch (layout.getType()) {
                    case "INDEX_NAVBAR": {
                        IndexNavBar indexNavBar = (IndexNavBar)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), IndexNavBar.class);
                        indexNavBar.initSetting(apiRequest.getLocale(), null);
                        pageData.put((Object)layout.getSchema(), (Object)indexNavBar);
                        break;
                    }
                    case "CUSTOM_GROUP": {
                        CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomGroup.class);
                        customGroup.initSetting(apiRequest.getLocale());
                        pageData.put((Object)layout.getSchema(), (Object)customGroup);
                        break;
                    }
                    case "BLANK_AREA": {
                        BlankArea blankArea = (BlankArea)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), BlankArea.class);
                        pageData.put((Object)layout.getSchema(), (Object)blankArea);
                        break;
                    }
                    case "SWIPER": {
                        Swiper swiper = (Swiper)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Swiper.class);
                        swiper.initSetting(apiRequest.getLocale());
                        pageData.put((Object)layout.getSchema(), (Object)swiper);
                        break;
                    }
                    case "CUSTOM_TAB_CONTROLLER": {
                        CustomTabController customTabController = (CustomTabController)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomTabController.class);
                        customTabController.updateAsyncConfigParam(apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId());
                        CustomTabControllerItem controllerItem = (CustomTabControllerItem)customTabController.getTabItems().get(0);
                        controllerItem.setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)controllerItem.getJumpPageTitle()));
                        controllerItem.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)controllerItem.getName()));
                        List<Object> itemList = new ArrayList();
                        itemList = customTabController.getTabItems().stream().filter(item -> ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId())).collect(Collectors.toList());
                        customTabController.setTabItems(itemList);
                        pageData.put((Object)layout.getSchema(), (Object)customTabController);
                        break;
                    }
                }
            });
        }
        return uiBotModel;
    }
}

