/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.search.Search;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.index.IndexBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildIndexStrategy")
public class UiBotModelBuildIndexStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildIndexStrategy.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private IndexBuildStrategyFactory indexBuildStrategyFactory;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndex");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        stopWatch.start("Build Index Page Model");
        Boolean hasProjectData = this.hasProjectData(apiRequest);
        PageSetting indexHasDataPageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.INDEX_HAS_WORK.toString());
        UiBotModel uiBotModel = this.indexBuildStrategyFactory.get(PageSettingIdPresetEnum.INDEX_HAS_WORK.toString()).build(apiRequest, indexHasDataPageSetting, hasProjectData);
        stopWatch.stop();
        return uiBotModel;
    }

    private boolean hasTaskData(ApiRequest apiRequest) {
        boolean hasTaskData = false;
        try {
            hasTaskData = !this.taskService.getDigiwinAtmcBacklogList(apiRequest).isEmpty();
            return hasTaskData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasProjectData(ApiRequest apiRequest) {
        boolean hasProjectData = false;
        try {
            List cardCategoryList = this.projectService.getProjectList(apiRequest);
            int actualProjectCount = cardCategoryList.stream().mapToInt(cardCategory -> cardCategory.getCardList().size()).sum();
            hasProjectData = actualProjectCount > 0;
            return hasProjectData;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return false;
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        String data = FileUtil.readText((String)"static/appstore-use/index.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            if (!layout.getType().equals("SEARCH") || pageData.get((Object)layout.getSchema()) == null) continue;
            Search search = (Search)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Search.class);
            search.initSetting(apiRequest.getLocale());
            pageData.put((Object)layout.getSchema(), (Object)search);
        }
        return uiBotModel;
    }
}

