/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.locale.cache;

import com.digiwin.mobile.mobileuibot.config.CacheConfig;
import com.digiwin.mobile.mobileuibot.model.LanguageSource;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class LocaleCache {
    public static final String LANGUAGE_CACHE_NAME = "languageSourceList";
    @Autowired
    private CacheConfig cacheConfig;

    public void putLanguageSourceList(List<LanguageSource> languageSourceList) {
        if (CollectionUtils.isEmpty(languageSourceList)) {
            return;
        }
        CaffeineCacheManager cacheManager = this.cacheConfig.languageSourceCacheManager();
        Cache cache = cacheManager.getCache(LANGUAGE_CACHE_NAME);
        languageSourceList.forEach(languageSource -> cache.put((Object)(languageSource.getPhrase() + "-" + languageSource.getLocale()), (Object)languageSource.getSourceValue()));
    }

    public void putLanguageSource(LanguageSource languageSource) {
        if (languageSource == null) {
            return;
        }
        CaffeineCacheManager cacheManager = this.cacheConfig.languageSourceCacheManager();
        Cache cache = cacheManager.getCache(LANGUAGE_CACHE_NAME);
        cache.put((Object)(languageSource.getPhrase() + "-" + languageSource.getLocale()), (Object)languageSource.getSourceValue());
    }

    public String getLanguageCache(String locale, String phrase) {
        if (!StringUtils.hasLength((String)phrase)) {
            return "";
        }
        CaffeineCacheManager cacheManager = this.cacheConfig.languageSourceCacheManager();
        Cache cache = cacheManager.getCache(LANGUAGE_CACHE_NAME);
        return (String)cache.get((Object)(phrase + "-" + locale), String::new);
    }
}

