/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mongodb.designerconfig;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.EnvScope;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.LayoutComponentTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.CollectionUtils;

@Document(collection="mobileDesignerConfig")
public class MobileDesignerConfig
implements Serializable {
    private static final long serialVersionUID = -2755427549549760951L;
    @Id
    private String id;
    private String application;
    private String tmTaskId;
    private String tmActivityId;
    private String tmActivityIdMatch;
    private String tmPattern;
    private String tmCategory;
    private String type;
    private List<EnvScope> envScopes;
    private JSONObject data;
    private List<JSONObject> rules;
    private String createTime;
    private String updateTime;
    private String version;

    public List<JSONObject> getRules() {
        this.rules = Optional.ofNullable(this.rules).orElse(Lists.newArrayList());
        return this.rules;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public PcUiBotTmPage getPages() {
        return Optional.ofNullable(this.data).map(r -> r.getJSONObject("pageView")).map(r -> r.getJSONObject("pages")).map(r -> r.getJSONObject("task-detail-mobile")).map(r -> (PcUiBotTmPage)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElse(null);
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public PcUiBotTmPage getPagesProject() {
        return Optional.ofNullable(this.data).map(r -> r.getJSONObject("pageView")).map(r -> r.getJSONObject("pages")).map(r -> r.getJSONObject("project-detail-mobile")).map(r -> (PcUiBotTmPage)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElse(null);
    }

    public Boolean existMobileDsl(PcUiBotTmPage page) {
        if (page == null) {
            return false;
        }
        List dataStates = page.getDataStates();
        if (CollectionUtils.isEmpty((Collection)dataStates)) {
            return false;
        }
        for (PcUiBotTmDataState dataState : dataStates) {
            List pageLayout = dataState.getPageLayout();
            if (CollectionUtils.isEmpty((Collection)pageLayout)) continue;
            UiBotPageLayout mainPageLayout = new UiBotPageLayout();
            for (UiBotPageLayout uiBotPageLayout : pageLayout) {
                if (!LayoutComponentTypeEnum.MAIN_PAGE.getValue().equalsIgnoreCase(uiBotPageLayout.getComponentType())) continue;
                mainPageLayout = uiBotPageLayout;
                break;
            }
            if (CollectionUtils.isEmpty((Collection)mainPageLayout.getBody())) continue;
            return true;
        }
        return false;
    }

    public Boolean validWithAppEnvType(String appEnvType) {
        if (this.getEnvScopes() == null || this.getEnvScopes().isEmpty()) {
            return false;
        }
        boolean result = false;
        for (EnvScope envScope : this.getEnvScopes()) {
            String type = envScope.getType();
            boolean envScopeValid = envScope.getValid();
            if (!appEnvType.equals(type)) continue;
            result = envScopeValid;
            break;
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getApplication() {
        return this.application;
    }

    public String getTmTaskId() {
        return this.tmTaskId;
    }

    public String getTmActivityId() {
        return this.tmActivityId;
    }

    public String getTmActivityIdMatch() {
        return this.tmActivityIdMatch;
    }

    public String getTmPattern() {
        return this.tmPattern;
    }

    public String getTmCategory() {
        return this.tmCategory;
    }

    public String getType() {
        return this.type;
    }

    public List<EnvScope> getEnvScopes() {
        return this.envScopes;
    }

    public JSONObject getData() {
        return this.data;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getVersion() {
        return this.version;
    }

    public MobileDesignerConfig setId(String id) {
        this.id = id;
        return this;
    }

    public MobileDesignerConfig setApplication(String application) {
        this.application = application;
        return this;
    }

    public MobileDesignerConfig setTmTaskId(String tmTaskId) {
        this.tmTaskId = tmTaskId;
        return this;
    }

    public MobileDesignerConfig setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
        return this;
    }

    public MobileDesignerConfig setTmActivityIdMatch(String tmActivityIdMatch) {
        this.tmActivityIdMatch = tmActivityIdMatch;
        return this;
    }

    public MobileDesignerConfig setTmPattern(String tmPattern) {
        this.tmPattern = tmPattern;
        return this;
    }

    public MobileDesignerConfig setTmCategory(String tmCategory) {
        this.tmCategory = tmCategory;
        return this;
    }

    public MobileDesignerConfig setType(String type) {
        this.type = type;
        return this;
    }

    public MobileDesignerConfig setEnvScopes(List<EnvScope> envScopes) {
        this.envScopes = envScopes;
        return this;
    }

    public MobileDesignerConfig setData(JSONObject data) {
        this.data = data;
        return this;
    }

    public MobileDesignerConfig setRules(List<JSONObject> rules) {
        this.rules = rules;
        return this;
    }

    public MobileDesignerConfig setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public MobileDesignerConfig setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public MobileDesignerConfig setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileDesignerConfig)) {
            return false;
        }
        MobileDesignerConfig other = (MobileDesignerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$tmTaskId = this.getTmTaskId();
        String other$tmTaskId = other.getTmTaskId();
        if (this$tmTaskId == null ? other$tmTaskId != null : !this$tmTaskId.equals(other$tmTaskId)) {
            return false;
        }
        String this$tmActivityId = this.getTmActivityId();
        String other$tmActivityId = other.getTmActivityId();
        if (this$tmActivityId == null ? other$tmActivityId != null : !this$tmActivityId.equals(other$tmActivityId)) {
            return false;
        }
        String this$tmActivityIdMatch = this.getTmActivityIdMatch();
        String other$tmActivityIdMatch = other.getTmActivityIdMatch();
        if (this$tmActivityIdMatch == null ? other$tmActivityIdMatch != null : !this$tmActivityIdMatch.equals(other$tmActivityIdMatch)) {
            return false;
        }
        String this$tmPattern = this.getTmPattern();
        String other$tmPattern = other.getTmPattern();
        if (this$tmPattern == null ? other$tmPattern != null : !this$tmPattern.equals(other$tmPattern)) {
            return false;
        }
        String this$tmCategory = this.getTmCategory();
        String other$tmCategory = other.getTmCategory();
        if (this$tmCategory == null ? other$tmCategory != null : !this$tmCategory.equals(other$tmCategory)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List this$envScopes = this.getEnvScopes();
        List other$envScopes = other.getEnvScopes();
        if (this$envScopes == null ? other$envScopes != null : !((Object)this$envScopes).equals(other$envScopes)) {
            return false;
        }
        JSONObject this$data = this.getData();
        JSONObject other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        List this$rules = this.getRules();
        List other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MobileDesignerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $tmTaskId = this.getTmTaskId();
        result = result * 59 + ($tmTaskId == null ? 43 : $tmTaskId.hashCode());
        String $tmActivityId = this.getTmActivityId();
        result = result * 59 + ($tmActivityId == null ? 43 : $tmActivityId.hashCode());
        String $tmActivityIdMatch = this.getTmActivityIdMatch();
        result = result * 59 + ($tmActivityIdMatch == null ? 43 : $tmActivityIdMatch.hashCode());
        String $tmPattern = this.getTmPattern();
        result = result * 59 + ($tmPattern == null ? 43 : $tmPattern.hashCode());
        String $tmCategory = this.getTmCategory();
        result = result * 59 + ($tmCategory == null ? 43 : $tmCategory.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List $envScopes = this.getEnvScopes();
        result = result * 59 + ($envScopes == null ? 43 : ((Object)$envScopes).hashCode());
        JSONObject $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        List $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "MobileDesignerConfig(id=" + this.getId() + ", application=" + this.getApplication() + ", tmTaskId=" + this.getTmTaskId() + ", tmActivityId=" + this.getTmActivityId() + ", tmActivityIdMatch=" + this.getTmActivityIdMatch() + ", tmPattern=" + this.getTmPattern() + ", tmCategory=" + this.getTmCategory() + ", type=" + this.getType() + ", envScopes=" + this.getEnvScopes() + ", data=" + this.getData() + ", rules=" + this.getRules() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ")";
    }
}

