/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.notification.model;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.digiwin.mobile.mobileuibot.aiassistant.model.AiAssistantSkillTypeEnum;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.AppBasePageNameEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.cardnormal.Card;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMessageTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaNotificationTypeEnum;
import com.digiwin.mobile.mobileuibot.notification.model.DigiwinAimMessageExtendContent;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetailFastJsonDeserializer;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetailPersonalCard;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetailProjectCard;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationLabel;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationPerson;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageBoard;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContent;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContentConfig;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessageContentMessageFiled;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@JSONType(deserializer=NotificationDetailFastJsonDeserializer.class)
public class NotificationDetail
implements Serializable {
    private static final long serialVersionUID = 3614391637211741987L;
    private static LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
    private NotificationPerson person;
    private Card card;
    private String content;
    private String jumpPageId;
    private NotificationLabel label;
    private String publishTime;
    private String title;
    private String dataId;
    private Boolean showPhoto;
    private Boolean showSeeMore;
    private String noShowSeeMoreMsg;
    private Integer state;
    private String gid;
    private Action action;
    private String msgType = "";
    private Map<String, Object> msgContent;
    private Boolean isTemplateMessage;
    private DigiwinAimMessageExtendContent extendDisplayContent;

    public static NotificationDetail create(String locale, DigiwinAimMessage digiwinAimMessage, NotificationDetailPersonalCard card, String mobileNotificationCategoryId, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<CustomTaskConfig> customTaskConfigList, String iamUserToken) {
        NotificationDetail result = new NotificationDetail();
        result.setMsgType(Optional.ofNullable(digiwinAimMessage.getType()).orElse(""));
        result.setPerson(NotificationPerson.create((String)locale, (DigiwinAimMessage)digiwinAimMessage, (AthenaMobileNotificationCategoryEnum)AthenaMobileNotificationCategoryEnum.getEnumByName((String)mobileNotificationCategoryId)));
        result.setCard((Card)card);
        Action action = new Action();
        if (card != null && card.getAction() != null) {
            action = card.getAction();
            result.setJumpPageId(action.getJumpPageId());
            result.setShowSeeMore(card.getShowSeeMore());
        }
        result.setState(digiwinAimMessage.getState());
        result.setGid(digiwinAimMessage.getGid());
        result.setLabel(NotificationLabel.create((String)locale, (DigiwinAimMessage)digiwinAimMessage));
        result.setPublishTime(digiwinAimMessage.getCreateDate());
        if (AthenaMessageTypeEnum.BASE_DATA_ENTRY.getType().equals(digiwinAimMessage.getType())) {
            if (digiwinAimMessage.getContent() != null) {
                Integer failedNum = digiwinAimMessage.getContent().getFailedNum();
                Integer succeededNumN = digiwinAimMessage.getContent().getSucceededNum();
                Integer processingNum = digiwinAimMessage.getContent().getProcessingNum();
                if (AthenaNotificationTypeEnum.EXCEPTION.toString().equals(digiwinAimMessage.getCategory())) {
                    result.setContent(localeService.getLanguageValue(locale, "\u5bfc\u5165\u5f02\u5e38\uff0c\u603b\u6570") + (failedNum + succeededNumN + processingNum) + localeService.getLanguageValue(locale, "\u7b14") + "," + localeService.getLanguageValue(locale, "\u5f02\u5e38") + failedNum + localeService.getLanguageValue(locale, "\u7b14") + "\u3002");
                } else if (AthenaNotificationTypeEnum.OTHER.toString().equals(digiwinAimMessage.getCategory())) {
                    result.setContent(localeService.getLanguageValue(locale, "\u5bfc\u5165\u6210\u529f\uff0c\u603b\u6570") + (failedNum + succeededNumN + processingNum) + localeService.getLanguageValue(locale, "\u7b14") + "\u3002");
                }
                if (digiwinAimMessage.getContent().getActivityName() != null) {
                    if ("en_US".equals(locale)) {
                        result.setTitle(digiwinAimMessage.getContent().getActivityName().getEnUSName());
                    } else if ("zh_TW".equals(locale)) {
                        result.setTitle(digiwinAimMessage.getContent().getActivityName().getZhTWName());
                    } else {
                        result.setTitle(digiwinAimMessage.getContent().getActivityName().getDefaultName());
                    }
                }
            }
        } else if (AthenaMessageTypeEnum.REMINDER.getType().equals(digiwinAimMessage.getType())) {
            if (digiwinAimMessage.getContent() != null) {
                DigiwinAimMessageContent content = digiwinAimMessage.getContent();
                result.setTitle("\u3010" + localeService.getLanguageValue(locale, "\u4efb\u52a1\u50ac\u529e") + "\u3011");
                result.setContent(localeService.getLanguageValue(locale, "\u60a8\u7684\u4efb\u52a1") + content.getTaskName() + localeService.getLanguageValue(locale, "\u5373\u5c06\u903e\u671f") + "\uff0c" + localeService.getLanguageValue(locale, "\u6240\u5c5e\u9879\u76ee") + content.getProjectName() + "\uff0c" + localeService.getLanguageValue(locale, "\u9879\u76ee\u53d1\u8d77\u4eba") + content.getPersonInChargeName());
            }
        } else if (AthenaMessageTypeEnum.TASK.getType().equals(digiwinAimMessage.getType())) {
            result.setShowSeeMore(Boolean.valueOf(false));
            result.setTitle(digiwinAimMessage.getContent().getTitle());
            result.setContent(digiwinAimMessage.getContent().getMsg());
            if (ObjectUtils.isEmpty((Object)digiwinAimMessage.getSendDate())) {
                result.setPublishTime(digiwinAimMessage.getCreateDate());
            } else {
                result.setPublishTime(digiwinAimMessage.getSendDate());
            }
        } else {
            DigiwinAimMessageContentMessageFiled messageFiled = digiwinAimMessage.getContent().getMessageFiled();
            if (!ObjectUtils.isEmpty((Object)digiwinAimMessage.getContent().getMessageFiled())) {
                NotificationDetail.handleCardSpliceContent((String)locale, (DigiwinAimMessage)digiwinAimMessage, (DigiwinAimMessageContentMessageFiled)messageFiled, (NotificationDetail)result);
            } else {
                result.setContent(digiwinAimMessage.getContent().getMsg());
            }
            result.setTitle(digiwinAimMessage.getContent().getTitle());
        }
        result.setDataId(digiwinAimMessage.getContent().getId());
        result.setShowPhoto(Boolean.valueOf(false));
        if (StringUtils.hasLength((String)result.getJumpPageId())) {
            if (BooleanUtil.isFalse((Boolean)result.getShowSeeMore())) {
                if (AthenaMessageTypeEnum.ACTIVITY.getType().equals(digiwinAimMessage.getType())) {
                    result.setNoShowSeeMoreMsg(localeService.getLanguageValue(locale, "\u6b64\u4f5c\u4e1a\u672a\u914d\u7f6e\u79fb\u52a8\u7aef\u754c\u9762\uff0c\u6682\u4e0d\u652f\u6301\u67e5\u770b\n\u8bf7\u524d\u5f80Web\u7aef\u67e5\u9605\u5904\u7406"));
                }
            } else {
                result.setShowSeeMore(Boolean.valueOf(true));
            }
        } else {
            result.setShowSeeMore(Boolean.valueOf(false));
        }
        if (ObjectUtil.isNotEmpty((Object)digiwinAimMessage.getContent().getExtendDisplayContent()) && ObjectUtil.isNotEmpty((Object)digiwinAimMessage.getContent().getExtendDisplayContent().getMobile())) {
            result.setExtendDisplayContent(digiwinAimMessage.getContent().getExtendDisplayContent());
            result.setTemplateMessage(Boolean.valueOf(true));
        } else {
            result.setTemplateMessage(Boolean.valueOf(false));
        }
        for (CustomTaskConfig customTaskConfig : customTaskConfigList) {
            String tmTaskId = customTaskConfig.getTmTaskId();
            String tmActivityId = customTaskConfig.getTmActivityId();
            if (digiwinAtmcBacklogDetail != null && digiwinAtmcBacklogDetail.getId() != null && digiwinAtmcBacklogDetail.isEqualWithBacklogDetailInTaskIdAndActivityId(tmTaskId, tmActivityId)) {
                DigiwinAtmcBacklog digiwinAtmcBacklog = new DigiwinAtmcBacklog(Long.valueOf(digiwinAtmcBacklogDetail.getBacklogId()), digiwinAtmcBacklogDetail.getTmTaskId(), digiwinAtmcBacklogDetail.getTmActivityId(), digiwinAtmcBacklogDetail.getTmCategory(), digiwinAtmcBacklogDetail.getTmPattern(), digiwinAtmcBacklogDetail.getTenantId());
                String requestUrl = customTaskConfig.getCustomTaskUrl(locale, iamUserToken, digiwinAtmcBacklog);
                action.setType(DigiwinAtmcBacklogTypeEnum.ANSWER_TYPE_NINE.getValue());
                action.setRequestUrl(requestUrl);
                result.setAction(action);
                result.setShowSeeMore(Boolean.valueOf(true));
                break;
            }
            action.setDataId(result.getDataId());
            action.setJumpPageId(result.getJumpPageId());
            action.setType(DigiwinAtmcBacklogTypeEnum.ANSWER_TYPE_ONE.getValue());
            result.setAction(action);
        }
        if (AthenaMessageTypeEnum.AGILE_DATA_DETAIL.getType().equals(digiwinAimMessage.getType())) {
            result.setShowSeeMore(Boolean.valueOf(true));
            result.setContent(digiwinAimMessage.getContent().getTitle());
            if (ObjectUtils.isEmpty((Object)digiwinAimMessage.getSendDate())) {
                result.setPublishTime(digiwinAimMessage.getCreateDate());
            } else {
                result.setPublishTime(digiwinAimMessage.getSendDate());
            }
            action.setDataId(digiwinAimMessage.getContent().getId());
            action.setJumpPageId(AppBasePageNameEnum.AGILE_DATA_DETAIL.getValue());
            action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
            result.setAction(action);
        } else if (AthenaMessageTypeEnum.TEXT.getType().equals(digiwinAimMessage.getType())) {
            if (ObjectUtils.isEmpty((Object)digiwinAimMessage.getSendDate())) {
                result.setPublishTime(digiwinAimMessage.getCreateDate());
            } else {
                result.setPublishTime(digiwinAimMessage.getSendDate());
            }
            if ("ASA".equals(digiwinAimMessage.getSource())) {
                result.setShowSeeMore(Boolean.valueOf(true));
                result.setContent(digiwinAimMessage.getContent().getMsg());
                result.setTitle(digiwinAimMessage.getContent().getTitle());
                action.setJumpPageId(AppBasePageNameEnum.AI_ASSISTANT.getValue());
                action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
                HashMap rawData = new HashMap();
                HashMap<String, String> aiAssistantParams = new HashMap<String, String>();
                aiAssistantParams.put("skillType", AiAssistantSkillTypeEnum.ADMINISTRATIVE_ASSISTANT.getValue());
                rawData.put("aiAssistantParams", aiAssistantParams);
                action.setRawData(rawData);
                result.setAction(action);
            }
            if ("AGILE_DATA".equals(digiwinAimMessage.getSource())) {
                result.setShowSeeMore(Boolean.valueOf(true));
                result.setContent(digiwinAimMessage.getContent().getMsg());
                result.setTitle(digiwinAimMessage.getContent().getTitle());
                action.setRawData(digiwinAimMessage.getAction());
                action.setJumpPageId(AppBasePageNameEnum.AGILE_DATA_SUBSCRIPTION_DETAIL.getValue());
                action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
                result.setAction(action);
            }
        }
        if (Objects.equals(AthenaMessageTypeEnum.NEWS.getType(), digiwinAimMessage.getType()) && "semc".equals(digiwinAimMessage.getSource())) {
            result.setShowSeeMore(Boolean.valueOf(true));
            action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
            action.setJumpPageId("NOTICE_DETAIL_PAGE");
            HashMap<String, Long> map = new HashMap<String, Long>();
            if (!ObjectUtils.isEmpty((Object)digiwinAimMessage.getContent()) && StringUtil.isNotEmpty((CharSequence)digiwinAimMessage.getContent().getId())) {
                map.put("id", Long.parseLong(digiwinAimMessage.getContent().getId()));
            }
            action.setRawData(map);
            result.setAction(action);
        }
        if (Objects.equals(AthenaMessageTypeEnum.LINKURL.getType(), digiwinAimMessage.getType())) {
            result.setShowSeeMore(Boolean.valueOf(true));
            result.setContent("");
            result.setTitle(digiwinAimMessage.getContent().getMsg());
            result.getLabel().setText("");
            action.setRawData(digiwinAimMessage.getAction());
            String ssoUrl = NotificationDetail.buildSsoLinkUrl((String)locale, (String)iamUserToken, (DigiwinAimMessageContent)digiwinAimMessage.getContent());
            if (!ObjectUtils.isEmpty((Object)ssoUrl)) {
                action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                action.setRequestUrl(ssoUrl);
            }
            result.setAction(action);
        }
        if ("app".equals(digiwinAimMessage.getChannelType())) {
            String msg = digiwinAimMessage.getContent().getMsg();
            if (Objects.nonNull(msg)) {
                msg = msg.replace("\n", "<br/>");
            }
            result.setTitle(digiwinAimMessage.getContent().getTitle());
            result.setContent(msg);
        }
        return result;
    }

    public static String buildSsoLinkUrl(String locale, String iamUserToken, DigiwinAimMessageContent content) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return "";
        }
        String routerLink = content.getLinkUrl();
        DigiwinAimMessageContentConfig config = content.getConfig();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ssoLogin", config.getSsoLogin());
        params.put("ssoAppCode", config.getSsoAppCode());
        params.put("appType", config.getAppType());
        HashMap<String, String> dynamicParams = new HashMap<String, String>();
        dynamicParams.put("routerLink", routerLink);
        params.put("dynamicParams", dynamicParams);
        DigiwinSemcProxyService digiwinSemcProxyService = (DigiwinSemcProxyService)SpringContextHolder.getBean(DigiwinSemcProxyService.class);
        JSONObject url = digiwinSemcProxyService.getSsoUrl(locale, iamUserToken, params);
        if (Objects.isNull(config.getSsoLogin())) {
            return "";
        }
        String ssoUrl = config.getSsoLogin() != false ? url.getString("ssoAddress") : url.getString("address");
        return ssoUrl;
    }

    private static void handleCardSpliceContent(String locale, DigiwinAimMessage digiwinAimMessage, DigiwinAimMessageContentMessageFiled messageFiled, NotificationDetail result) {
        StringBuilder builder = new StringBuilder();
        String category = "";
        if (AthenaNotificationTypeEnum.NEW.name().equals(digiwinAimMessage.getCategory())) {
            category = localeService.getLanguageValue(locale, "\u65b0\u589e\u4efb\u52a1");
        }
        if (AthenaNotificationTypeEnum.UPDATE.name().equals(digiwinAimMessage.getCategory())) {
            category = localeService.getLanguageValue(locale, "\u66f4\u65b0\u4efb\u52a1");
        }
        builder.append("<p>");
        builder.append("\u3010").append(category).append("\u3011").append(localeService.getLanguageValue(locale, "\u9884\u8ba1\u5b8c\u6210\u65f6\u95f4")).append("-").append("<span style=\"color: black;\">").append(messageFiled.getEndTime()).append("</span>");
        builder.append("<br/>");
        builder.append("</p>");
        builder.append("<p>");
        builder.append(localeService.getLanguageValue(locale, "\u4efb\u52a1")).append("/");
        builder.append(localeService.getLanguageValue(locale, "\u9879\u76ee")).append("-");
        builder.append("<span style=\"font-weight: bold;color: black;\">\u3010").append(messageFiled.getTmActivityName()).append("\u3011</span>").append("  ").append("<span style=\"color: black;\">").append(messageFiled.getProjectName()).append("</span>");
        builder.append("<br/>");
        builder.append("</p>");
        if (StringUtils.hasLength((String)messageFiled.getSummaryLayout())) {
            builder.append(localeService.getLanguageValue(locale, "\u6458\u8981")).append("-").append("<span style=\"color: black;\">").append(messageFiled.getSummaryLayout()).append("</span>");
        }
        result.setContent(builder.toString());
    }

    @Deprecated
    public static NotificationDetail create(String locale, DigiwinAimMessage digiwinAimMessage, NotificationDetailProjectCard card, String mobileNotificationCategoryId) {
        NotificationDetail result = new NotificationDetail();
        result.setPerson(NotificationPerson.create((String)locale, (DigiwinAimMessage)digiwinAimMessage, (AthenaMobileNotificationCategoryEnum)AthenaMobileNotificationCategoryEnum.getEnumByName((String)mobileNotificationCategoryId)));
        result.setCard((Card)card);
        result.setContent(digiwinAimMessage.getContent().getMsg());
        result.setState(digiwinAimMessage.getState());
        result.setGid(digiwinAimMessage.getGid());
        result.setLabel(NotificationLabel.create((String)locale, (DigiwinAimMessage)digiwinAimMessage));
        result.setPublishTime(digiwinAimMessage.getCreateDate());
        result.setTitle(digiwinAimMessage.getTitle());
        result.setDataId(digiwinAimMessage.getContent().getId());
        result.setShowPhoto(Boolean.valueOf(false));
        return result;
    }

    public static NotificationDetail createPersonal(String locale, DigiwinAimMessage digiwinAimMessage, Card card, String mobileNotificationCategoryId) {
        NotificationDetail result = new NotificationDetail();
        result.setPerson(NotificationPerson.create((String)locale, (DigiwinAimMessage)digiwinAimMessage, (AthenaMobileNotificationCategoryEnum)AthenaMobileNotificationCategoryEnum.getEnumByName((String)mobileNotificationCategoryId)));
        result.setCard(card);
        result.setTitle(((DigiwinAimMessageBoard)digiwinAimMessage.getContent().getMessageBoard().get(0)).getComment());
        result.setPublishTime(digiwinAimMessage.getCreateDate());
        result.setDataId(digiwinAimMessage.getContent().getId());
        result.setState(digiwinAimMessage.getState());
        result.setGid(digiwinAimMessage.getGid());
        return result;
    }

    public static NotificationDetail createAthenaWelcomeDetail(String locale) {
        NotificationDetail notificationDetail = new NotificationDetail();
        notificationDetail.setPerson(NotificationPerson.create((String)locale, null, (AthenaMobileNotificationCategoryEnum)AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT));
        notificationDetail.setContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"WELCOME_TO_ATHENA"));
        return notificationDetail;
    }

    public NotificationPerson getPerson() {
        return this.person;
    }

    public void setPerson(NotificationPerson person) {
        this.person = person;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getJumpPageId() {
        return this.jumpPageId;
    }

    public void setJumpPageId(String jumpPageId) {
        this.jumpPageId = jumpPageId;
    }

    public NotificationLabel getLabel() {
        return this.label;
    }

    public void setLabel(NotificationLabel label) {
        this.label = label;
    }

    public String getPublishTime() {
        return this.publishTime;
    }

    public void setPublishTime(String publishTime) {
        this.publishTime = null == publishTime || "".equals(publishTime.trim()) ? "1970-01-01 00:00:00" : publishTime;
    }

    public String getTitle() {
        return StringUtil.applyLineFeed((String)this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Boolean getShowPhoto() {
        return this.showPhoto;
    }

    public void setShowPhoto(Boolean showPhoto) {
        this.showPhoto = showPhoto;
    }

    public Boolean getShowSeeMore() {
        return this.showSeeMore;
    }

    public void setShowSeeMore(Boolean showSeeMore) {
        this.showSeeMore = showSeeMore;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getGid() {
        return this.gid;
    }

    public void setGid(String gid) {
        this.gid = gid;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public Map<String, Object> getMsgContent() {
        return this.msgContent;
    }

    public void setMsgContent(Map<String, Object> msgContent) {
        this.msgContent = msgContent;
    }

    public Boolean getTemplateMessage() {
        return this.isTemplateMessage;
    }

    public void setTemplateMessage(Boolean templateMessage) {
        this.isTemplateMessage = templateMessage;
    }

    public DigiwinAimMessageExtendContent getExtendDisplayContent() {
        return this.extendDisplayContent;
    }

    public void setExtendDisplayContent(DigiwinAimMessageExtendContent extendDisplayContent) {
        this.extendDisplayContent = extendDisplayContent;
    }

    public String getNoShowSeeMoreMsg() {
        return this.noShowSeeMoreMsg;
    }

    public void setNoShowSeeMoreMsg(String noShowSeeMoreMsg) {
        this.noShowSeeMoreMsg = noShowSeeMoreMsg;
    }
}

