/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.openapi.service.impl;

import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcMobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcMobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcPageTaskRelationRepository;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTaskFilterRepository;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTenantRelation;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTenantRelationRepository;
import com.digiwin.mobile.mobileuibot.openapi.designer.enums.DataVersionEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterRepository;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ActivityFilterServiceImpl
implements ActivityFilterService {
    private static final Logger log = LoggerFactory.getLogger(ActivityFilterServiceImpl.class);
    @Autowired
    private TaskFilterRepository taskFilterRepository;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;
    @Autowired
    private UcTaskFilterRepository ucTaskFilterRepository;
    @Autowired
    private UcPageTaskRelationRepository ucPageTaskRelationRepository;
    @Autowired
    private UcMobileDesignerConfigRepository ucMobileDesignerConfigRepository;
    @Autowired
    private UcTenantRelationRepository ucTenantRelationRepository;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public String tenantVersion(String iamUserToken, String tenantId, String locale) {
        String tenantVersion = this.digiwinKnowledgeMapsProxyService.tenantVersion(iamUserToken, tenantId, locale);
        tenantVersion = StringUtils.hasLength((String)tenantVersion) ? (DataVersionEnum.V1_0.getVersion().equals(tenantVersion) ? DataVersionEnum.V1_0.getVersion() : DataVersionEnum.V2_0.getVersion()) : DataVersionEnum.V2_0.getVersion();
        return tenantVersion;
    }

    public List<TaskFilter> listValidInAthenaOfTaskFilter(String tenantId, String version) {
        List tenantRelations = this.ucTenantRelationRepository.selectByTenantId(tenantId, version);
        if (CollectionUtils.isEmpty((Collection)tenantRelations)) {
            return this.taskFilterRepository.listValidInAthena(version);
        }
        List openTaskCustom = tenantRelations.stream().filter(r -> BooleanUtils.isTrue((Boolean)r.getIndividualAll())).collect(Collectors.toList());
        Set codeList = openTaskCustom.stream().map(UcTenantRelation::getAppCode).collect(Collectors.toSet());
        Set ucCodeList = openTaskCustom.stream().map(UcTenantRelation::getUcAppCode).collect(Collectors.toSet());
        ArrayList ucTaskFilters = new ArrayList();
        if (!CollectionUtils.isEmpty(ucCodeList)) {
            ucTaskFilters = new ArrayList(this.ucTaskFilterRepository.listValidInAthena(version, ucCodeList));
        }
        List stdTaskFilters = this.taskFilterRepository.listValidInAthena(version).stream().filter(taskFilter -> !codeList.contains(taskFilter.getAppCode())).collect(Collectors.toList());
        return Stream.concat(stdTaskFilters.stream(), ucTaskFilters.stream()).collect(Collectors.toList());
    }

    public List<PageTaskRelation> listAthenaOfPageTaskRelations(String tenantId, String version) {
        List tenantRelations = this.ucTenantRelationRepository.selectByTenantId(tenantId, version);
        if (CollectionUtils.isEmpty((Collection)tenantRelations)) {
            return this.pageTaskRelationService.listAthenaPageTaskRelations(version);
        }
        List openTaskCustom = tenantRelations.stream().filter(r -> BooleanUtils.isTrue((Boolean)r.getIndividualAll())).collect(Collectors.toList());
        Set codeList = openTaskCustom.stream().map(UcTenantRelation::getAppCode).collect(Collectors.toSet());
        Set ucCodeList = openTaskCustom.stream().map(UcTenantRelation::getUcAppCode).collect(Collectors.toSet());
        ArrayList ucPageTaskRelations = new ArrayList();
        if (!CollectionUtils.isEmpty(ucCodeList)) {
            ucPageTaskRelations = new ArrayList(this.ucPageTaskRelationRepository.listAthenaPageTaskRelations(version, ucCodeList));
        }
        List stdPageTaskRelations = this.pageTaskRelationService.listAthenaPageTaskRelations(version).stream().filter(pageTaskRelation -> !codeList.contains(pageTaskRelation.getAppCode())).collect(Collectors.toList());
        return Stream.concat(stdPageTaskRelations.stream(), ucPageTaskRelations.stream()).collect(Collectors.toList());
    }

    public List<MobileDesignerConfig> findByTypeOfMobileDesignerConfig(String type, String tenantId, String version) {
        List tenantRelations = this.ucTenantRelationRepository.selectByTenantId(tenantId, version);
        if (CollectionUtils.isEmpty((Collection)tenantRelations)) {
            return this.mobileDesignerConfigRepository.findByType(type, version, null);
        }
        if (MobileDesignerConfigTypeEnum.TASK.getValue().equals(type) || MobileDesignerConfigTypeEnum.PROJECT.getValue().equals(type) || MobileDesignerConfigTypeEnum.START_PROJECT.getValue().equals(type)) {
            List openTaskCustom = tenantRelations.stream().filter(r -> BooleanUtils.isTrue((Boolean)r.getIndividualAll())).collect(Collectors.toList());
            Set codeList = openTaskCustom.stream().map(UcTenantRelation::getAppCode).collect(Collectors.toSet());
            Set ucCodeList = openTaskCustom.stream().map(UcTenantRelation::getUcAppCode).collect(Collectors.toSet());
            ArrayList ucMobileDesignerConfigs = new ArrayList();
            if (!CollectionUtils.isEmpty(ucCodeList)) {
                ucMobileDesignerConfigs = new ArrayList(this.ucMobileDesignerConfigRepository.findByType(type, version, ucCodeList));
            }
            List stdMobileDesignerConfigs = this.mobileDesignerConfigRepository.findByType(type, version, codeList);
            return Stream.concat(stdMobileDesignerConfigs.stream(), ucMobileDesignerConfigs.stream()).collect(Collectors.toList());
        }
        if (MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue().equals(type)) {
            List stdMobileDesignerConfigs = this.mobileDesignerConfigRepository.findByType(type, version, null);
            Set ucCodeList = tenantRelations.stream().map(UcTenantRelation::getUcAppCode).collect(Collectors.toSet());
            ArrayList ucMobileDesignerConfigs = new ArrayList(this.ucMobileDesignerConfigRepository.findByType(type, version, ucCodeList));
            return Stream.concat(stdMobileDesignerConfigs.stream(), ucMobileDesignerConfigs.stream()).collect(Collectors.toList());
        }
        return new ArrayList<MobileDesignerConfig>();
    }

    public Boolean isExsitTmActivityIdOfMobileDesignerConfig(String appCode, String tmActivityId, String type, String tenantId, String version) {
        List tenantRelations = this.ucTenantRelationRepository.selectByTenantId(tenantId, version);
        if (CollectionUtils.isEmpty((Collection)tenantRelations)) {
            return this.mobileDesignerConfigRepository.isExsitTmActivityId(tmActivityId, type, version);
        }
        if (MobileDesignerConfigTypeEnum.TASK.getValue().equals(type) || MobileDesignerConfigTypeEnum.PROJECT.getValue().equals(type) || MobileDesignerConfigTypeEnum.START_PROJECT.getValue().equals(type)) {
            UcTenantRelation ucTenantRelation = tenantRelations.stream().filter(t -> Objects.equals(t.getAppCode(), appCode)).findFirst().orElse(null);
            if (ucTenantRelation != null && BooleanUtils.isTrue((Boolean)ucTenantRelation.getIndividualAll())) {
                return this.ucMobileDesignerConfigRepository.isExsitTmActivityIdOfUcAppCode(tmActivityId, type, version, (Set)Sets.newHashSet((Object[])new String[]{ucTenantRelation.getUcAppCode()}));
            }
            return this.mobileDesignerConfigRepository.isExsitTmActivityId(tmActivityId, type, version);
        }
        if (MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue().equals(type)) {
            String ucAppCode = tenantRelations.stream().filter(t -> Objects.equals(t.getAppCode(), appCode)).findFirst().map(UcTenantRelation::getUcAppCode).orElse("");
            if (StringUtils.hasLength((String)ucAppCode)) {
                Boolean uc = this.ucMobileDesignerConfigRepository.isExsitTmActivityIdOfUcAppCode(tmActivityId, type, version, (Set)Sets.newHashSet((Object[])new String[]{ucAppCode}));
                if (BooleanUtils.isTrue((Boolean)uc)) {
                    return uc;
                }
                return this.mobileDesignerConfigRepository.isExsitTmActivityId(tmActivityId, type, version);
            }
            return this.mobileDesignerConfigRepository.isExsitTmActivityId(tmActivityId, type, version);
        }
        return false;
    }

    public MobileDesignerConfig selectOneData(String appCode, String tmActivityId, String type, String tenantId, String version) {
        List tenantRelations = this.ucTenantRelationRepository.selectByTenantId(tenantId, version);
        if (CollectionUtils.isEmpty((Collection)tenantRelations)) {
            return this.mobileDesignerConfigRepository.selectOneDsl(tmActivityId, type);
        }
        if (MobileDesignerConfigTypeEnum.TASK.getValue().equals(type) || MobileDesignerConfigTypeEnum.PROJECT.getValue().equals(type) || MobileDesignerConfigTypeEnum.START_PROJECT.getValue().equals(type)) {
            UcTenantRelation ucTenantRelation = tenantRelations.stream().filter(t -> Objects.equals(t.getAppCode(), appCode)).findFirst().orElse(null);
            if (ucTenantRelation != null && BooleanUtils.isTrue((Boolean)ucTenantRelation.getIndividualAll())) {
                return this.ucMobileDesignerConfigRepository.selectOneDsl(tmActivityId, type, (Set)Sets.newHashSet((Object[])new String[]{ucTenantRelation.getUcAppCode()}));
            }
            return this.mobileDesignerConfigRepository.selectOneDsl(tmActivityId, type);
        }
        if (MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue().equals(type)) {
            String ucAppCode = tenantRelations.stream().filter(t -> Objects.equals(t.getAppCode(), appCode)).findFirst().map(UcTenantRelation::getUcAppCode).orElse("");
            if (StringUtils.hasLength((String)ucAppCode)) {
                UcMobileDesignerConfig ucMobileDesignerConfig = this.ucMobileDesignerConfigRepository.selectOneDsl(tmActivityId, type, (Set)Sets.newHashSet((Object[])new String[]{ucAppCode}));
                if (ucMobileDesignerConfig != null) {
                    return ucMobileDesignerConfig;
                }
                return this.mobileDesignerConfigRepository.selectOneDsl(tmActivityId, type);
            }
            return this.mobileDesignerConfigRepository.selectOneDsl(tmActivityId, type);
        }
        return null;
    }
}

