/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.pipeline;

import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.PipelineNode;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.springframework.lang.Nullable;

public abstract class AbstractPipeline<T>
implements Pipeline<T> {
    private final List<PipelineNode<T>> nodes = Lists.newArrayList();
    @Nullable
    private Iterator<PipelineNode<T>> iterator;

    public void addPipelineNode(PipelineNode<T> node) {
        this.nodes.add(node);
    }

    public void execute(T t) {
        if (this.iterator == null) {
            this.iterator = this.nodes.iterator();
        }
        if (this.iterator.hasNext()) {
            PipelineNode node = (PipelineNode)this.iterator.next();
            node.execute((Pipeline)this, t);
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.iterator = null;
    }
}

