/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsWrapper;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomTabsWrapperPipelineNode
extends DslGeneratePipelineNode {
    private static final Logger log = LoggerFactory.getLogger(CustomTabsWrapperPipelineNode.class);
    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";

    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.CUSTOM_TABS_OBJECT;
    }

    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        pipeline.execute((Object)apiResponse);
        try {
            UiBotModel uiBotModel;
            if (null == apiResponse) {
                return;
            }
            if (RENDER_PAGE_URI.equalsIgnoreCase(AppRequestContext.getContextEntity().getRequestUri()) && ObjectUtils.isNotEmpty((Object)apiResponse.getData()) && !CollectionUtils.isEmpty((Collection)(uiBotModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)apiResponse.getData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).getLayout())) {
                for (UiBotLayout layoutToProcess : uiBotModel.getLayout()) {
                    String type;
                    Class customizeClazz;
                    Object rawComponentData = uiBotModel.getPageData().get((Object)layoutToProcess.getSchema());
                    if (null == rawComponentData || null == (customizeClazz = (Class)MobileRenderDataUtil.customizeListComponentsMap.getOrDefault(type = layoutToProcess.getType(), null)) || !customizeClazz.equals(CustomTabs.class)) continue;
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)layoutToProcess.getSchema()), CustomTabs.class);
                    CustomTabsWrapper wrapper = new CustomTabsWrapper();
                    wrapper.setData(customTabs);
                    wrapper.setStyle(Integer.valueOf(1));
                    wrapper.setAlignmentType(CustomTabControllerTabAlignEnum.CENTER.getValue());
                    wrapper.setScrollMode(CustomTabScrollModeEnum.TAB_SCROLL.getMode());
                    wrapper.setDefaultSelected(Integer.valueOf(0));
                    wrapper.setBackgroundColor();
                    uiBotModel.getPageData().put((Object)layoutToProcess.getSchema(), (Object)wrapper);
                    apiResponse.setData((Object)uiBotModel);
                }
            }
        }
        catch (Exception e) {
            log.error("CustomTabsToObjectPipelineNode failure, error:{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

