/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.request.mock.MockInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.mock.MockService;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MockScenePipelineNode
extends DslGeneratePipelineNode {
    private static final Logger log = LoggerFactory.getLogger(MockScenePipelineNode.class);
    @Autowired
    private MockService mockService;

    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.MOCK_SCENE;
    }

    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        pipeline.execute((Object)apiResponse);
        try {
            if (null == apiResponse) {
                return;
            }
            OuterMockData outerMockData = (OuterMockData)MockInterceptor.OUTER_MOCK_DATA.get();
            if (null == outerMockData) {
                return;
            }
            String mockId = outerMockData.getMockId();
            if ("/mobile/v1/proxy/loginInDigiwhale".equalsIgnoreCase(AppRequestContext.getContextEntity().getRequestUri())) {
                DigiwhaleLoginResponse body = (DigiwhaleLoginResponse)apiResponse.getData();
                mockId = this.mockService.settingMockUserInfo(mockId, body);
                body.setMockId(mockId);
                outerMockData.setMockId(mockId);
            }
            outerMockData.setResponse(JsonUtil.javaObjectToJsonString((Object)apiResponse));
        }
        catch (Exception e) {
            log.error("MockScenePipelineNode failure, error:", (Throwable)e);
        }
    }
}

