/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.node;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.pipeline.Pipeline;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNode;
import com.digiwin.mobile.mobileuibot.pipeline.dslgenerate.DslGeneratePipelineNodeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TeamTaskPipelineNode
extends DslGeneratePipelineNode {
    private static final Logger log = LoggerFactory.getLogger(TeamTaskPipelineNode.class);
    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";
    @Autowired
    private LocaleService localeService;

    public DslGeneratePipelineNodeEnum getDslGeneratePipelineNodeEnum() {
        return DslGeneratePipelineNodeEnum.TEAM_TASK;
    }

    public void execute(Pipeline<ApiResponse> pipeline, ApiResponse apiResponse) {
        pipeline.execute((Object)apiResponse);
        try {
            if (null == apiResponse) {
                return;
            }
            if ((BooleanUtils.isTrue((Boolean)AppRequestContext.getContextEntity().getIsTeamTask()) || BooleanUtils.isTrue((Boolean)AppRequestContext.getContextEntity().getPinning())) && RENDER_PAGE_URI.equalsIgnoreCase(AppRequestContext.getContextEntity().getRequestUri()) && ObjectUtils.isNotEmpty((Object)apiResponse.getData())) {
                String locale = AppRequestContext.getContextEntity().getLocale();
                UiBotModel uiBotModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)apiResponse.getData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                ArrayList<String> allowDisplayButtonNameList = new ArrayList<String>();
                allowDisplayButtonNameList.add(this.localeService.getLanguageValue(locale, "\u53d6\u6d88"));
                allowDisplayButtonNameList.add(this.localeService.getLanguageValue(locale, "\u8be6\u60c5"));
                uiBotModel = MobileRenderMetaData.RENDER_VERSION_2.equals(uiBotModel.getRenderVersion()) ? MobileRenderDataUtil.handleV2TeamWork((UiBotModel)uiBotModel, allowDisplayButtonNameList) : (UiBotModel)MobileRenderDataUtil.handleV1TeamWork((Object)uiBotModel, null, allowDisplayButtonNameList);
                uiBotModel.setAppbarButtonList(Collections.emptyList());
                apiResponse.setData((Object)uiBotModel);
            }
        }
        catch (Exception e) {
            log.error("TeamTaskPipelineNode failure, error:", (Throwable)e);
        }
    }
}

