/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.portal.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.model.UsePortalTypeResp;
import com.digiwin.mobile.mobileuibot.portal.service.PortalService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.ApplicationColumnReq;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileAppColumnResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileBallResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileClassificatonResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileFullBackResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalInfoContentResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalInfoItemResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.ValidMobileAppAuthResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="potalService")
public class PortalServiceImpl
implements PortalService {
    private final String PREVIEW_RENDER_PAGE = "INDEX_PORTAL";
    @Autowired
    private DigiwinSemcProxyService semcProxyService;
    @Autowired
    private LocaleService localeService;

    public Action buildQrCodePrePortalAction(ApiRequest apiRequest, Map<String, Object> conditon) {
        Action result = new Action();
        result.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        HashMap<String, String> map = new HashMap<String, String>();
        result.setRawData(map);
        if (!conditon.containsKey("d") || ObjectUtils.isEmpty((Object)conditon.get("d"))) {
            return result;
        }
        JSONObject data = JSONObject.parseObject((String)JsonUtil.javaObjectToJsonString((Object)conditon.get("d")));
        if (!data.containsKey("id") || ObjectUtils.isEmpty(data.get("id"))) {
            return result;
        }
        String s = data.get("id").toString();
        result.setJumpPageId("INDEX_PORTAL");
        map.put("id", s);
        map.put("scene", "1");
        String pageType = null == data.get("pageType") ? "0" : data.get("pageType").toString();
        map.put("pageType", pageType);
        result.setRawData(map);
        return result;
    }

    public List<MobilePortalInfoItemResp> selectUserPortal(ApiRequsetPortal apiRequsetPortal) {
        List<Object> respList = new ArrayList<MobilePortalInfoItemResp>();
        List mobilePortalInfoItemResps = this.semcProxyService.selectUserPortal(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken());
        if (!CollectionUtils.isEmpty((Collection)mobilePortalInfoItemResps)) {
            respList = mobilePortalInfoItemResps;
            respList.forEach(x -> x.setName(this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), x.getName())));
        }
        return respList;
    }

    public UsePortalTypeResp getUserPortalType(ApiRequsetPortal apiRequsetPortal) {
        UsePortalTypeResp result = new UsePortalTypeResp();
        UsePortalTypeResp usePortalTypeResp = this.semcProxyService.getUserPortalType(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken());
        if (!ObjectUtils.isEmpty((Object)usePortalTypeResp)) {
            result = usePortalTypeResp;
        }
        return result;
    }

    public Boolean addPortalType(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.addPortalType(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), apiRequsetPortal.getPortalType(), apiRequsetPortal.getDataId());
    }

    public Boolean addUserRecord(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.addUserRecord(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), apiRequsetPortal.getDataId());
    }

    public JSONObject check(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.checkPortalInfo(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken(), apiRequsetPortal.getDataId(), apiRequsetPortal.getPageType());
    }

    public String checkParam(MobilePortalInfoContentResp contentResp) {
        String error = "";
        if (ObjectUtils.isEmpty((Object)contentResp.getContentId())) {
            error = "\u7ec4\u4ef6id\u5fc5\u987b\u4f20\u5165";
            return "\u7ec4\u4ef6id\u5fc5\u987b\u4f20\u5165";
        }
        if (!PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue().equals(contentResp.getContentType()) || !PortalConstans.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(contentResp.getCustomType())) {
            error = "\u53ea\u53ef\u7f16\u8f91\u81ea\u5b9a\u4e49\u91d1\u521a\u533a";
            return "\u53ea\u53ef\u7f16\u8f91\u81ea\u5b9a\u4e49\u91d1\u521a\u533a";
        }
        List ballList = contentResp.getBallList();
        if (CollectionUtils.isEmpty((Collection)ballList)) {
            error = "\u81ea\u5b9a\u4e49\u5e94\u7528\u4e0d\u53ef\u4e3a\u7a7a";
            return "\u81ea\u5b9a\u4e49\u5e94\u7528\u4e0d\u53ef\u4e3a\u7a7a";
        }
        for (MobileBallResp ballResp : ballList) {
            if (!StringUtils.hasText((String)ballResp.getBallName())) {
                error = "\u5e94\u7528\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a";
                return "\u5e94\u7528\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a";
            }
            if (!PortalConstans.JumpTypeEnum.SSO_CONFIGURATION.getValue().equals(ballResp.getJumpType())) {
                error = "\u53ea\u53ef\u914d\u7f6e\u81ea\u5b9a\u4e49\u5e94\u7528";
                return "\u53ea\u53ef\u914d\u7f6e\u81ea\u5b9a\u4e49\u5e94\u7528";
            }
            if (!StringUtils.hasText((String)ballResp.getJumpTarget())) {
                error = "\u8bf7\u914d\u7f6e\u8df3\u8f6c\u8def\u5f84";
                return "\u8bf7\u914d\u7f6e\u8df3\u8f6c\u8def\u5f84";
            }
            if (ObjectUtils.isEmpty((Object)ballResp.getCustomApplicationId())) {
                error = "\u81ea\u5b9a\u4e49\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a";
                return "\u81ea\u5b9a\u4e49\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!ObjectUtils.isEmpty((Object)ballResp.getContentIcon())) continue;
            error = "\u81ea\u5b9a\u4e49icon\u4e0d\u80fd\u4e3a\u7a7a";
            return "\u81ea\u5b9a\u4e49icon\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return error;
    }

    public JSONObject saveCustomDistrict(Long mobilePortalId, MobilePortalInfoContentResp contentResp, ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.saveCustomDistrict(mobilePortalId, contentResp, apiRequsetPortal);
    }

    public MobilePortalInfoContentResp getCustomDistrict(Long mobilePortalId, Long contentId, ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.getCustomDistrict(mobilePortalId, contentId, apiRequsetPortal);
    }

    public List<MobileClassificatonResp> getClassificationList(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.getClassificationList(apiRequsetPortal);
    }

    public JSONObject saveApplicationColumn(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.saveApplicationColumn(apiRequsetPortal);
    }

    public List<ApplicationColumnReq> getApplicationColumnList(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.getApplicationColumnList(apiRequsetPortal);
    }

    public MobileAppColumnResp getApplicationColumnDetail(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.getApplicationColumnDetail(apiRequsetPortal);
    }

    public JSONObject setColumnOrder(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.setColumnOrder(apiRequsetPortal);
    }

    public JSONObject delColumn(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.delColumn(apiRequsetPortal);
    }

    public JSONObject updateColumnStatus(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.updateColumnStatus(apiRequsetPortal);
    }

    public MobileFullBackResp getFullCallBackUrl(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.getFullCallBackUrl(apiRequsetPortal);
    }

    public List<ValidMobileAppAuthResp> validUserAppAuth(ApiRequsetPortal apiRequsetPortal) {
        return this.semcProxyService.validUserAppAuth(apiRequsetPortal);
    }
}

