/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommand;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommandByImage;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestTemplate;
import com.digiwin.mobile.mobileuibot.printer.response.CommandVO;
import com.digiwin.mobile.mobileuibot.printer.response.PrintTemplateVO;
import com.digiwin.mobile.mobileuibot.printer.service.PrinterService;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/printer"})
public class PrinterController {
    @Autowired
    private PrinterService printerService;

    @PostMapping(value={"/command"})
    public ApiResponse<CommandVO> getCommand(@RequestBody ApiRequestCommand request) throws Exception {
        CommandVO command = new CommandVO();
        command = BooleanUtils.isTrue((Boolean)request.getRawData().getBoolean("isNewVersion")) ? this.printerService.getCommand2(request) : this.printerService.getCommand(request);
        if (ObjectUtils.isEmpty((Object)command.getCommands()) || ObjectUtils.isEmpty((Object)command.getPdfUrl())) {
            return ApiResponse.buildError().setData((Object)command);
        }
        return ApiResponse.buildOK().setData((Object)command);
    }

    @PostMapping(value={"/commandByImage"})
    public ApiResponse<CommandVO> getCommandByImage(@RequestBody ApiRequestCommandByImage request) throws Exception {
        return ApiResponse.buildOK().setData((Object)this.printerService.getCommandByImage(request));
    }

    @PostMapping(value={"/template/list"})
    public ApiResponse<List<PrintTemplateVO>> templateList(@RequestBody ApiRequestTemplate request) {
        return ApiResponse.buildOK().setData((Object)this.printerService.templateList(request));
    }
}

